/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer.rule;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.sql.InterpretedFunctionInvoker;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.In;
import io.trino.sql.ir.optimizer.IrOptimizerRule;
import io.trino.sql.planner.Symbol;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class EvaluateIn
implements IrOptimizerRule {
    private final Metadata metadata;
    private final InterpretedFunctionInvoker functionInvoker;

    public EvaluateIn(PlannerContext context) {
        this.metadata = context.getMetadata();
        this.functionInvoker = new InterpretedFunctionInvoker(context.getFunctionManager());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optional<Expression> apply(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        Object list;
        if (!(expression instanceof In)) return Optional.empty();
        In in = (In)expression;
        Object object = in.value();
        if (!(object instanceof Constant)) return Optional.empty();
        Constant value = (Constant)object;
        try {
            list = object = in.valueList();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (!list.stream().allMatch(Constant.class::isInstance)) {
            return Optional.empty();
        }
        if (list.isEmpty()) {
            return Optional.of(Booleans.FALSE);
        }
        if (value.value() == null) {
            return Optional.of(Booleans.NULL_BOOLEAN);
        }
        ResolvedFunction equalsOperator = this.metadata.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)value.type(), (Object)value.type()));
        ConnectorSession connectorSession = session.toConnectorSession();
        boolean nullMatch = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Expression item = (Expression)iterator.next();
            Constant constantItem = (Constant)item;
            Boolean equal = (Boolean)this.functionInvoker.invoke(equalsOperator, connectorSession, value.value(), constantItem.value());
            if (Boolean.TRUE.equals(equal)) {
                return Optional.of(Booleans.TRUE);
            }
            if (equal != null) continue;
            nullMatch = true;
        }
        return Optional.of(nullMatch ? Booleans.NULL_BOOLEAN : Booleans.FALSE);
    }
}

