/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer.rule;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.optimizer.IrOptimizerRule;
import io.trino.sql.planner.Symbol;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class EvaluateIsNull
implements IrOptimizerRule {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Optional<Expression> apply(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        Optional<Expression> optional;
        if (!(expression instanceof IsNull)) return Optional.empty();
        IsNull isNull = (IsNull)expression;
        Expression expression2 = isNull.value();
        Objects.requireNonNull(expression2);
        Expression expression3 = expression2;
        int n = 0;
        block9: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Constant.class, IsNull.class, Row.class, Comparison.class, Comparison.class, Call.class, Call.class}, (Expression)expression3, n)) {
                case 0: {
                    Constant inner = (Constant)expression3;
                    optional = Optional.of(inner.value() == null ? Booleans.TRUE : Booleans.FALSE);
                    return optional;
                }
                case 1: {
                    optional = Optional.of(Booleans.FALSE);
                    return optional;
                }
                case 2: {
                    optional = Optional.of(Booleans.FALSE);
                    return optional;
                }
                case 3: {
                    Comparison inner = (Comparison)expression3;
                    if (inner.operator() != Comparison.Operator.IDENTICAL) {
                        optional = Optional.of(new Logical(Logical.Operator.OR, (List<Expression>)ImmutableList.of((Object)new IsNull(inner.left()), (Object)new IsNull(inner.right()))));
                        return optional;
                    }
                    n = 4;
                    continue block9;
                }
                case 4: {
                    Comparison inner = (Comparison)expression3;
                    if (inner.operator() == Comparison.Operator.IDENTICAL) {
                        optional = Optional.of(Booleans.FALSE);
                        return optional;
                    }
                    n = 5;
                    continue block9;
                }
                case 5: {
                    Call inner = (Call)expression3;
                    if (inner.function().name().equals((Object)GlobalFunctionCatalog.builtinFunctionName("$not"))) {
                        optional = Optional.of(new IsNull(inner.arguments().getFirst()));
                        return optional;
                    }
                    n = 6;
                    continue block9;
                }
                case 6: {
                    Call inner = (Call)expression3;
                    if (inner.function().deterministic() && !inner.function().functionNullability().isReturnNullable()) {
                        if (inner.function().functionNullability().getArgumentNullable().stream().allMatch(Boolean.TRUE::equals)) {
                            optional = Optional.of(Booleans.FALSE);
                            return optional;
                        }
                    }
                    n = 7;
                    continue block9;
                }
            }
            break;
        }
        optional = Optional.empty();
        return optional;
    }
}

