/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableMap;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.spi.function.FunctionKind;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.WindowNode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PruneOrderByInWindowAggregation
implements Rule<WindowNode> {
    private static final Pattern<WindowNode> PATTERN = Patterns.window();
    private final Metadata metadata;

    public PruneOrderByInWindowAggregation(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<WindowNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(WindowNode node, Captures captures, Rule.Context context) {
        boolean anyRewritten = false;
        ImmutableMap.Builder rewritten = ImmutableMap.builder();
        for (Map.Entry<Symbol, WindowNode.Function> entry : node.getWindowFunctions().entrySet()) {
            WindowNode.Function function = entry.getValue();
            if (function.getOrderingScheme().isPresent() && function.getResolvedFunction().functionKind() == FunctionKind.AGGREGATE && !this.metadata.getAggregationFunctionMetadata(context.getSession(), function.getResolvedFunction()).isOrderSensitive()) {
                function = new WindowNode.Function(function.getResolvedFunction(), function.getArguments(), Optional.empty(), function.getFrame(), function.isIgnoreNulls(), function.isDistinct());
                anyRewritten = true;
            }
            rewritten.put((Object)entry.getKey(), (Object)function);
        }
        if (!anyRewritten) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(new WindowNode(node.getId(), node.getSource(), node.getSpecification(), (Map<Symbol, WindowNode.Function>)rewritten.buildOrThrow(), node.getHashSymbol(), node.getPrePartitionedInputs(), node.getPreSortedOrderPrefix()));
    }
}

