/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.relational;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.OperatorNameUtil;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.RowExpressionVisitor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public record SpecialForm(Form form, Type type, List<RowExpression> arguments, List<ResolvedFunction> functionDependencies) implements RowExpression
{
    public SpecialForm {
        Objects.requireNonNull(form, "form is null");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(arguments, "arguments is null");
        functionDependencies = ImmutableList.copyOf((Collection)Objects.requireNonNull(functionDependencies, "functionDependencies is null"));
    }

    public ResolvedFunction getOperatorDependency(OperatorType operator) {
        String mangleOperatorName = OperatorNameUtil.mangleOperatorName(operator);
        for (ResolvedFunction function : this.functionDependencies) {
            if (!function.signature().getName().getFunctionName().equalsIgnoreCase(mangleOperatorName)) continue;
            return function;
        }
        throw new IllegalArgumentException("Expected operator: " + String.valueOf(operator));
    }

    public Optional<ResolvedFunction> getCastDependency(Type fromType, Type toType) {
        if (fromType.equals((Object)toType)) {
            return Optional.empty();
        }
        BoundSignature boundSignature = new BoundSignature(GlobalFunctionCatalog.builtinFunctionName(OperatorType.CAST), toType, (List)ImmutableList.of((Object)fromType));
        for (ResolvedFunction function : this.functionDependencies) {
            if (!function.signature().equals((Object)boundSignature)) continue;
            return Optional.of(function);
        }
        throw new IllegalArgumentException("Expected cast: " + String.valueOf(boundSignature));
    }

    @Override
    public String toString() {
        return this.form.name() + "(" + Joiner.on((String)", ").join(this.arguments) + ")";
    }

    @Override
    public <R, C> R accept(RowExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitSpecialForm(this, context);
    }

    public static enum Form {
        IF,
        NULL_IF,
        SWITCH,
        WHEN,
        BETWEEN,
        IS_NULL,
        COALESCE,
        IN,
        AND,
        OR,
        DEREFERENCE,
        ROW_CONSTRUCTOR,
        ARRAY_CONSTRUCTOR,
        BIND;

    }
}

