/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import io.airlift.slice.Slice;
import io.trino.block.AbstractTestBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.Fixed12Block;
import io.trino.spi.block.Fixed12BlockBuilder;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFixed12Block
extends AbstractTestBlock {
    @Test
    public void test() {
        Slice[] expectedValues = TestFixed12Block.createTestValue(17);
        this.assertFixedWithValues(expectedValues);
        this.assertFixedWithValues(TestFixed12Block.alternatingNullValues(expectedValues));
    }

    @Test
    public void testCopyPositions() {
        Slice[] expectedValues = TestFixed12Block.alternatingNullValues(TestFixed12Block.createTestValue(17));
        BlockBuilder blockBuilder = TestFixed12Block.createBlockBuilderWithValues(expectedValues);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), 0, 2, 4, 6, 7, 9, 10, 16);
    }

    @Test
    public void testLazyBlockBuilderInitialization() {
        Slice[] expectedValues = TestFixed12Block.createTestValue(100);
        Fixed12BlockBuilder emptyBlockBuilder = new Fixed12BlockBuilder(null, 0);
        Fixed12BlockBuilder blockBuilder = new Fixed12BlockBuilder(null, expectedValues.length);
        Assertions.assertThat((long)blockBuilder.getSizeInBytes()).isEqualTo(emptyBlockBuilder.getSizeInBytes());
        Assertions.assertThat((long)blockBuilder.getRetainedSizeInBytes()).isEqualTo(emptyBlockBuilder.getRetainedSizeInBytes());
        TestFixed12Block.writeValues(expectedValues, blockBuilder);
        Assertions.assertThat((blockBuilder.getSizeInBytes() > emptyBlockBuilder.getSizeInBytes() ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((blockBuilder.getRetainedSizeInBytes() > emptyBlockBuilder.getRetainedSizeInBytes() ? 1 : 0) != 0).isTrue();
        blockBuilder = (Fixed12BlockBuilder)blockBuilder.newBlockBuilderLike(null);
        Assertions.assertThat((long)blockBuilder.getSizeInBytes()).isEqualTo(emptyBlockBuilder.getSizeInBytes());
        Assertions.assertThat((long)blockBuilder.getRetainedSizeInBytes()).isEqualTo(emptyBlockBuilder.getRetainedSizeInBytes());
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        Slice[] expectedValues = TestFixed12Block.createTestValue(100);
        TestFixed12Block.assertEstimatedDataSizeForStats(TestFixed12Block.createBlockBuilderWithValues(expectedValues), expectedValues);
    }

    @Test
    public void testCompactBlock() {
        int[] intArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 0, 3, 0, 0, 4};
        boolean[] valueIsNull = new boolean[]{false, true, false, false, false, false};
        TestFixed12Block.testCompactBlock((Block)new Fixed12Block(0, Optional.empty(), new int[0]));
        TestFixed12Block.testCompactBlock((Block)new Fixed12Block(valueIsNull.length, Optional.of(valueIsNull), intArray));
        TestFixed12Block.testNotCompactBlock((Block)new Fixed12Block(valueIsNull.length - 2, Optional.of(valueIsNull), intArray));
    }

    private void assertFixedWithValues(Slice[] expectedValues) {
        Block block = TestFixed12Block.createBlockBuilderWithValues(expectedValues).build();
        this.assertBlock(block, expectedValues);
    }

    private static BlockBuilder createBlockBuilderWithValues(Slice[] expectedValues) {
        Fixed12BlockBuilder blockBuilder = new Fixed12BlockBuilder(null, expectedValues.length);
        TestFixed12Block.writeValues(expectedValues, blockBuilder);
        return blockBuilder;
    }

    private static void writeValues(Slice[] expectedValues, Fixed12BlockBuilder blockBuilder) {
        for (Slice expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.writeFixed12(expectedValue.getLong(0), expectedValue.getInt(8));
        }
    }

    private static Slice[] createTestValue(int positionCount) {
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = TestFixed12Block.createExpectedValue(12);
        }
        return expectedValues;
    }

    @Override
    protected <T> void assertPositionValue(Block block, int position, T expectedValue) {
        if (expectedValue == null) {
            Assertions.assertThat((boolean)block.isNull(position)).isTrue();
            return;
        }
        Fixed12Block fixed12Block = (Fixed12Block)block;
        Slice expectedBytes = (Slice)expectedValue;
        Assertions.assertThat((long)fixed12Block.getFixed12First(position)).isEqualTo(expectedBytes.getLong(0));
        Assertions.assertThat((int)fixed12Block.getFixed12Second(position)).isEqualTo(expectedBytes.getInt(8));
    }
}

