/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.connector.MockConnectorColumnHandle;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.function.table.AbstractConnectorTableFunction;
import io.trino.spi.function.table.Argument;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.function.table.Descriptor;
import io.trino.spi.function.table.DescriptorArgumentSpecification;
import io.trino.spi.function.table.ReturnTypeSpecification;
import io.trino.spi.function.table.ScalarArgument;
import io.trino.spi.function.table.ScalarArgumentSpecification;
import io.trino.spi.function.table.TableArgument;
import io.trino.spi.function.table.TableArgumentSpecification;
import io.trino.spi.function.table.TableFunctionAnalysis;
import io.trino.spi.function.table.TableFunctionDataProcessor;
import io.trino.spi.function.table.TableFunctionProcessorProvider;
import io.trino.spi.function.table.TableFunctionProcessorState;
import io.trino.spi.function.table.TableFunctionSplitProcessor;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;

public class TestingTableFunctions {
    private static final String SCHEMA_NAME = "system";
    private static final String TABLE_NAME = "table";
    private static final String COLUMN_NAME = "column";
    private static final ConnectorTableFunctionHandle HANDLE = new TestingTableFunctionPushdownHandle();
    private static final TableFunctionAnalysis ANALYSIS = TableFunctionAnalysis.builder().handle(HANDLE).returnedType(new Descriptor((List)ImmutableList.of((Object)new Descriptor.Field("column", Optional.of(BooleanType.BOOLEAN))))).build();
    private static final TableFunctionAnalysis NO_DESCRIPTOR_ANALYSIS = TableFunctionAnalysis.builder().handle(HANDLE).requiredColumns("INPUT", (List)ImmutableList.of((Object)0)).build();

    public static class TestingTableFunctionPushdownHandle
    implements ConnectorTableFunctionHandle {
        private final MockConnectorTableHandle tableHandle = new MockConnectorTableHandle(new SchemaTableName("system", "table"), (TupleDomain<ColumnHandle>)TupleDomain.all(), Optional.of(ImmutableList.of((Object)new MockConnectorColumnHandle("column", (Type)BooleanType.BOOLEAN))));

        public MockConnectorTableHandle getTableHandle() {
            return this.tableHandle;
        }
    }

    public record TestingTableFunctionHandle(SchemaFunctionName name) implements ConnectorTableFunctionHandle
    {
        public TestingTableFunctionHandle {
            Objects.requireNonNull(name, "name is null");
        }
    }

    public static class EmptySourceFunction
    extends AbstractConnectorTableFunction {
        public static final String FUNCTION_NAME = "empty_source";

        public EmptySourceFunction() {
            super(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME, (List)ImmutableList.of(), (ReturnTypeSpecification)new ReturnTypeSpecification.DescribedTable(new Descriptor((List)ImmutableList.of((Object)new Descriptor.Field(TestingTableFunctions.COLUMN_NAME, Optional.of(BooleanType.BOOLEAN))))));
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            return TableFunctionAnalysis.builder().handle((ConnectorTableFunctionHandle)new TestingTableFunctionHandle(new SchemaFunctionName(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME))).build();
        }

        public static class EmptySourceFunctionProcessor
        implements TableFunctionSplitProcessor {
            private static final Page EMPTY_PAGE = new Page(new Block[]{BooleanType.BOOLEAN.createFixedSizeBlockBuilder(0).build()});
            private boolean produced;

            public TableFunctionProcessorState process() {
                if (!this.produced) {
                    this.produced = true;
                    return TableFunctionProcessorState.Processed.produced((Page)EMPTY_PAGE);
                }
                return TableFunctionProcessorState.Finished.FINISHED;
            }
        }

        public static class EmptySourceFunctionProcessorProvider
        implements TableFunctionProcessorProvider {
            public TableFunctionSplitProcessor getSplitProcessor(ConnectorSession session, ConnectorTableFunctionHandle handle, ConnectorSplit split) {
                return new EmptySourceFunctionProcessor();
            }
        }
    }

    public static class ConstantFunction
    extends AbstractConnectorTableFunction {
        public ConstantFunction() {
            super(TestingTableFunctions.SCHEMA_NAME, "constant", (List)ImmutableList.of((Object)ScalarArgumentSpecification.builder().name("VALUE").type((Type)IntegerType.INTEGER).build(), (Object)ScalarArgumentSpecification.builder().name("N").type((Type)IntegerType.INTEGER).defaultValue((Object)1L).build()), (ReturnTypeSpecification)new ReturnTypeSpecification.DescribedTable(Descriptor.descriptor((List)ImmutableList.of((Object)"constant_column"), (List)ImmutableList.of((Object)IntegerType.INTEGER))));
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            ScalarArgument count = (ScalarArgument)arguments.get("N");
            Objects.requireNonNull(count.getValue(), "count value for function repeat() is null");
            Preconditions.checkArgument(((Long)count.getValue() >= 0L ? 1 : 0) != 0, (Object)"count value for function repeat() must not be negative");
            return TableFunctionAnalysis.builder().handle((ConnectorTableFunctionHandle)new ConstantFunctionHandle((Long)((ScalarArgument)arguments.get("VALUE")).getValue(), (Long)count.getValue())).build();
        }

        public static ConnectorSplitSource getConstantFunctionSplitSource(ConstantFunctionHandle handle) {
            long splitSize = 5500L;
            ImmutableList.Builder splits = ImmutableList.builder();
            for (long i = 0L; i < handle.getCount() / splitSize; ++i) {
                splits.add((Object)new ConstantFunctionSplit(splitSize));
            }
            long remainingSize = handle.getCount() % splitSize;
            if (remainingSize > 0L) {
                splits.add((Object)new ConstantFunctionSplit(remainingSize));
            }
            return new FixedSplitSource((Iterable)splits.build());
        }

        public static final class ConstantFunctionSplit
        implements ConnectorSplit {
            private static final int INSTANCE_SIZE = SizeOf.instanceSize(ConstantFunctionSplit.class);
            public static final int DEFAULT_SPLIT_SIZE = 5500;
            private final long count;

            @JsonCreator
            public ConstantFunctionSplit(@JsonProperty(value="count") long count) {
                this.count = count;
            }

            @JsonProperty
            public long getCount() {
                return this.count;
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("count", this.count).toString();
            }

            public long getRetainedSizeInBytes() {
                return INSTANCE_SIZE;
            }
        }

        public static class ConstantFunctionHandle
        implements ConnectorTableFunctionHandle {
            private final Long value;
            private final long count;

            @JsonCreator
            public ConstantFunctionHandle(@JsonProperty(value="value") Long value, @JsonProperty(value="count") long count) {
                this.value = value;
                this.count = count;
            }

            @JsonProperty
            public Long getValue() {
                return this.value;
            }

            @JsonProperty
            public long getCount() {
                return this.count;
            }
        }

        public static class ConstantFunctionProcessor
        implements TableFunctionSplitProcessor {
            private static final int PAGE_SIZE = 1000;
            private final Block value;
            private long fullPagesCount;
            private long processedPages;
            private int reminder;

            public ConstantFunctionProcessor(Long value, ConstantFunctionSplit split) {
                this.value = Utils.nativeValueToBlock((Type)IntegerType.INTEGER, (Object)value);
                long count = split.getCount();
                this.fullPagesCount = count / 1000L;
                this.reminder = Math.toIntExact(count % 1000L);
            }

            public TableFunctionProcessorState process() {
                if (this.processedPages < this.fullPagesCount) {
                    ++this.processedPages;
                    Page result = new Page(new Block[]{RunLengthEncodedBlock.create((Block)this.value, (int)1000)});
                    return TableFunctionProcessorState.Processed.produced((Page)result);
                }
                if (this.reminder > 0) {
                    Page result = new Page(new Block[]{RunLengthEncodedBlock.create((Block)this.value, (int)this.reminder)});
                    this.reminder = 0;
                    return TableFunctionProcessorState.Processed.produced((Page)result);
                }
                return TableFunctionProcessorState.Finished.FINISHED;
            }
        }

        public static class ConstantFunctionProcessorProvider
        implements TableFunctionProcessorProvider {
            public TableFunctionSplitProcessor getSplitProcessor(ConnectorSession session, ConnectorTableFunctionHandle handle, ConnectorSplit split) {
                return new ConstantFunctionProcessor(((ConstantFunctionHandle)handle).getValue(), (ConstantFunctionSplit)split);
            }
        }
    }

    public static class TestSingleInputRowSemanticsFunction
    extends AbstractConnectorTableFunction {
        public static final String FUNCTION_NAME = "test_single_input_function";

        public TestSingleInputRowSemanticsFunction() {
            super(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME, (List)ImmutableList.of((Object)TableArgumentSpecification.builder().rowSemantics().name("INPUT").build()), (ReturnTypeSpecification)new ReturnTypeSpecification.DescribedTable(new Descriptor((List)ImmutableList.of((Object)new Descriptor.Field("boolean_result", Optional.of(BooleanType.BOOLEAN))))));
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            return TableFunctionAnalysis.builder().handle((ConnectorTableFunctionHandle)new TestingTableFunctionHandle(new SchemaFunctionName(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME))).requiredColumns("INPUT", (List)IntStream.range(0, ((TableArgument)arguments.get("INPUT")).getRowType().getFields().size()).boxed().collect(ImmutableList.toImmutableList())).build();
        }

        public static class TestSingleInputFunctionProcessorProvider
        implements TableFunctionProcessorProvider {
            public TableFunctionDataProcessor getDataProcessor(ConnectorSession session, ConnectorTableFunctionHandle handle) {
                BlockBuilder builder = BooleanType.BOOLEAN.createFixedSizeBlockBuilder(1);
                BooleanType.BOOLEAN.writeBoolean(builder, true);
                Page result = new Page(new Block[]{builder.build()});
                return input -> {
                    if (input == null) {
                        return TableFunctionProcessorState.Finished.FINISHED;
                    }
                    return TableFunctionProcessorState.Processed.usedInputAndProduced((Page)result);
                };
            }
        }
    }

    public static class TestInputFunction
    extends AbstractConnectorTableFunction {
        public static final String FUNCTION_NAME = "test_input";

        public TestInputFunction() {
            super(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME, (List)ImmutableList.of((Object)TableArgumentSpecification.builder().name("INPUT").keepWhenEmpty().build()), (ReturnTypeSpecification)new ReturnTypeSpecification.DescribedTable(new Descriptor((List)ImmutableList.of((Object)new Descriptor.Field("got_input", Optional.of(BooleanType.BOOLEAN))))));
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            return TableFunctionAnalysis.builder().handle((ConnectorTableFunctionHandle)new TestingTableFunctionHandle(new SchemaFunctionName(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME))).requiredColumns("INPUT", (List)IntStream.range(0, ((TableArgument)arguments.get("INPUT")).getRowType().getFields().size()).boxed().collect(ImmutableList.toImmutableList())).build();
        }

        private static class TestInputProcessor
        implements TableFunctionDataProcessor {
            private boolean processorGotInput;
            private boolean finished;

            private TestInputProcessor() {
            }

            public TableFunctionProcessorState process(List<Optional<Page>> input) {
                if (this.finished) {
                    return TableFunctionProcessorState.Finished.FINISHED;
                }
                if (input == null) {
                    this.finished = true;
                    BlockBuilder builder = BooleanType.BOOLEAN.createFixedSizeBlockBuilder(1);
                    BooleanType.BOOLEAN.writeBoolean(builder, this.processorGotInput);
                    return TableFunctionProcessorState.Processed.produced((Page)new Page(new Block[]{builder.build()}));
                }
                this.processorGotInput = true;
                return TableFunctionProcessorState.Processed.usedInput();
            }
        }

        public static class TestInputProcessorProvider
        implements TableFunctionProcessorProvider {
            public TableFunctionDataProcessor getDataProcessor(ConnectorSession session, ConnectorTableFunctionHandle handle) {
                return new TestInputProcessor();
            }
        }
    }

    public static class PassThroughInputFunction
    extends AbstractConnectorTableFunction {
        public static final String FUNCTION_NAME = "pass_through";

        public PassThroughInputFunction() {
            super(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME, (List)ImmutableList.of((Object)TableArgumentSpecification.builder().name("INPUT_1").passThroughColumns().keepWhenEmpty().build(), (Object)TableArgumentSpecification.builder().name("INPUT_2").passThroughColumns().keepWhenEmpty().build()), (ReturnTypeSpecification)new ReturnTypeSpecification.DescribedTable(new Descriptor((List)ImmutableList.of((Object)new Descriptor.Field("input_1_present", Optional.of(BooleanType.BOOLEAN)), (Object)new Descriptor.Field("input_2_present", Optional.of(BooleanType.BOOLEAN))))));
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            return TableFunctionAnalysis.builder().handle((ConnectorTableFunctionHandle)new TestingTableFunctionHandle(new SchemaFunctionName(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME))).requiredColumns("INPUT_1", (List)ImmutableList.of((Object)0)).requiredColumns("INPUT_2", (List)ImmutableList.of((Object)0)).build();
        }

        private static class PassThroughInputProcessor
        implements TableFunctionDataProcessor {
            private boolean input1Present;
            private boolean input2Present;
            private int input1EndIndex;
            private int input2EndIndex;
            private boolean finished;

            private PassThroughInputProcessor() {
            }

            public TableFunctionProcessorState process(List<Optional<Page>> input) {
                if (this.finished) {
                    return TableFunctionProcessorState.Finished.FINISHED;
                }
                if (input == null) {
                    this.finished = true;
                    BlockBuilder input1Builder = BooleanType.BOOLEAN.createFixedSizeBlockBuilder(1);
                    BooleanType.BOOLEAN.writeBoolean(input1Builder, this.input1Present);
                    BlockBuilder input2Builder = BooleanType.BOOLEAN.createFixedSizeBlockBuilder(1);
                    BooleanType.BOOLEAN.writeBoolean(input2Builder, this.input2Present);
                    BlockBuilder input1PassThroughBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(1);
                    if (this.input1Present) {
                        BigintType.BIGINT.writeLong(input1PassThroughBuilder, (long)(this.input1EndIndex - 1));
                    } else {
                        input1PassThroughBuilder.appendNull();
                    }
                    BlockBuilder input2PassThroughBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(1);
                    if (this.input2Present) {
                        BigintType.BIGINT.writeLong(input2PassThroughBuilder, (long)(this.input2EndIndex - 1));
                    } else {
                        input2PassThroughBuilder.appendNull();
                    }
                    return TableFunctionProcessorState.Processed.produced((Page)new Page(new Block[]{input1Builder.build(), input2Builder.build(), input1PassThroughBuilder.build(), input2PassThroughBuilder.build()}));
                }
                input.get(0).ifPresent(page -> {
                    this.input1Present = true;
                    this.input1EndIndex += page.getPositionCount();
                });
                input.get(1).ifPresent(page -> {
                    this.input2Present = true;
                    this.input2EndIndex += page.getPositionCount();
                });
                return TableFunctionProcessorState.Processed.usedInput();
            }
        }

        public static class PassThroughInputProcessorProvider
        implements TableFunctionProcessorProvider {
            public TableFunctionDataProcessor getDataProcessor(ConnectorSession session, ConnectorTableFunctionHandle handle) {
                return new PassThroughInputProcessor();
            }
        }
    }

    public static class TestInputsFunction
    extends AbstractConnectorTableFunction {
        public static final String FUNCTION_NAME = "test_inputs_function";

        public TestInputsFunction() {
            super(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME, (List)ImmutableList.of((Object)TableArgumentSpecification.builder().rowSemantics().name("INPUT_1").build(), (Object)TableArgumentSpecification.builder().name("INPUT_2").keepWhenEmpty().build(), (Object)TableArgumentSpecification.builder().name("INPUT_3").keepWhenEmpty().build(), (Object)TableArgumentSpecification.builder().name("INPUT_4").keepWhenEmpty().build()), (ReturnTypeSpecification)new ReturnTypeSpecification.DescribedTable(new Descriptor((List)ImmutableList.of((Object)new Descriptor.Field("boolean_result", Optional.of(BooleanType.BOOLEAN))))));
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            return TableFunctionAnalysis.builder().handle((ConnectorTableFunctionHandle)new TestingTableFunctionHandle(new SchemaFunctionName(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME))).requiredColumns("INPUT_1", (List)IntStream.range(0, ((TableArgument)arguments.get("INPUT_1")).getRowType().getFields().size()).boxed().collect(ImmutableList.toImmutableList())).requiredColumns("INPUT_2", (List)IntStream.range(0, ((TableArgument)arguments.get("INPUT_2")).getRowType().getFields().size()).boxed().collect(ImmutableList.toImmutableList())).requiredColumns("INPUT_3", (List)IntStream.range(0, ((TableArgument)arguments.get("INPUT_3")).getRowType().getFields().size()).boxed().collect(ImmutableList.toImmutableList())).requiredColumns("INPUT_4", (List)IntStream.range(0, ((TableArgument)arguments.get("INPUT_4")).getRowType().getFields().size()).boxed().collect(ImmutableList.toImmutableList())).build();
        }

        public static class TestInputsFunctionProcessorProvider
        implements TableFunctionProcessorProvider {
            public TableFunctionDataProcessor getDataProcessor(ConnectorSession session, ConnectorTableFunctionHandle handle) {
                BlockBuilder resultBuilder = BooleanType.BOOLEAN.createFixedSizeBlockBuilder(1);
                BooleanType.BOOLEAN.writeBoolean(resultBuilder, true);
                Page result = new Page(new Block[]{resultBuilder.build()});
                return input -> {
                    if (input == null) {
                        return TableFunctionProcessorState.Finished.FINISHED;
                    }
                    return TableFunctionProcessorState.Processed.usedInputAndProduced((Page)result);
                };
            }
        }
    }

    public static class EmptyOutputWithPassThroughFunction
    extends AbstractConnectorTableFunction {
        public static final String FUNCTION_NAME = "empty_output_with_pass_through";

        public EmptyOutputWithPassThroughFunction() {
            super(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME, (List)ImmutableList.of((Object)TableArgumentSpecification.builder().name("INPUT").keepWhenEmpty().passThroughColumns().build()), (ReturnTypeSpecification)new ReturnTypeSpecification.DescribedTable(new Descriptor((List)ImmutableList.of((Object)new Descriptor.Field(TestingTableFunctions.COLUMN_NAME, Optional.of(BooleanType.BOOLEAN))))));
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            return TableFunctionAnalysis.builder().handle((ConnectorTableFunctionHandle)new TestingTableFunctionHandle(new SchemaFunctionName(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME))).requiredColumns("INPUT", (List)IntStream.range(0, ((TableArgument)arguments.get("INPUT")).getRowType().getFields().size()).boxed().collect(ImmutableList.toImmutableList())).build();
        }

        private static class EmptyOutputWithPassThroughProcessor
        implements TableFunctionDataProcessor {
            private static final Page EMPTY_PAGE = new Page(new Block[]{BooleanType.BOOLEAN.createFixedSizeBlockBuilder(0).build(), BigintType.BIGINT.createFixedSizeBlockBuilder(0).build()});

            private EmptyOutputWithPassThroughProcessor() {
            }

            public TableFunctionProcessorState process(List<Optional<Page>> input) {
                if (input == null) {
                    return TableFunctionProcessorState.Finished.FINISHED;
                }
                return TableFunctionProcessorState.Processed.usedInputAndProduced((Page)EMPTY_PAGE);
            }
        }

        public static class EmptyOutputWithPassThroughProcessorProvider
        implements TableFunctionProcessorProvider {
            public TableFunctionDataProcessor getDataProcessor(ConnectorSession session, ConnectorTableFunctionHandle handle) {
                return new EmptyOutputWithPassThroughProcessor();
            }
        }
    }

    public static class EmptyOutputFunction
    extends AbstractConnectorTableFunction {
        public static final String FUNCTION_NAME = "empty_output";

        public EmptyOutputFunction() {
            super(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME, (List)ImmutableList.of((Object)TableArgumentSpecification.builder().name("INPUT").keepWhenEmpty().build()), (ReturnTypeSpecification)new ReturnTypeSpecification.DescribedTable(new Descriptor((List)ImmutableList.of((Object)new Descriptor.Field(TestingTableFunctions.COLUMN_NAME, Optional.of(BooleanType.BOOLEAN))))));
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            return TableFunctionAnalysis.builder().handle((ConnectorTableFunctionHandle)new TestingTableFunctionHandle(new SchemaFunctionName(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME))).requiredColumns("INPUT", (List)IntStream.range(0, ((TableArgument)arguments.get("INPUT")).getRowType().getFields().size()).boxed().collect(ImmutableList.toImmutableList())).build();
        }

        private static class EmptyOutputProcessor
        implements TableFunctionDataProcessor {
            private static final Page EMPTY_PAGE = new Page(new Block[]{BooleanType.BOOLEAN.createFixedSizeBlockBuilder(0).build()});

            private EmptyOutputProcessor() {
            }

            public TableFunctionProcessorState process(List<Optional<Page>> input) {
                if (input == null) {
                    return TableFunctionProcessorState.Finished.FINISHED;
                }
                return TableFunctionProcessorState.Processed.usedInputAndProduced((Page)EMPTY_PAGE);
            }
        }

        public static class EmptyOutputProcessorProvider
        implements TableFunctionProcessorProvider {
            public TableFunctionDataProcessor getDataProcessor(ConnectorSession session, ConnectorTableFunctionHandle handle) {
                return new EmptyOutputProcessor();
            }
        }
    }

    public static class RepeatFunction
    extends AbstractConnectorTableFunction {
        public RepeatFunction() {
            super(TestingTableFunctions.SCHEMA_NAME, "repeat", (List)ImmutableList.of((Object)TableArgumentSpecification.builder().name("INPUT").passThroughColumns().keepWhenEmpty().build(), (Object)ScalarArgumentSpecification.builder().name("N").type((Type)IntegerType.INTEGER).defaultValue((Object)2L).build()), (ReturnTypeSpecification)ReturnTypeSpecification.OnlyPassThrough.ONLY_PASS_THROUGH);
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            ScalarArgument count = (ScalarArgument)arguments.get("N");
            Objects.requireNonNull(count.getValue(), "count value for function repeat() is null");
            Preconditions.checkArgument(((Long)count.getValue() > 0L ? 1 : 0) != 0, (Object)"count value for function repeat() must be positive");
            return TableFunctionAnalysis.builder().handle((ConnectorTableFunctionHandle)new RepeatFunctionHandle((Long)count.getValue())).requiredColumns("INPUT", (List)ImmutableList.of((Object)0)).build();
        }

        public static class RepeatFunctionHandle
        implements ConnectorTableFunctionHandle {
            private final long count;

            @JsonCreator
            public RepeatFunctionHandle(@JsonProperty(value="count") long count) {
                this.count = count;
            }

            @JsonProperty
            public long getCount() {
                return this.count;
            }
        }

        public static class RepeatFunctionProcessor
        implements TableFunctionDataProcessor {
            private final long count;
            private long processedPositions;
            private long processedRounds;
            private Block indexes;
            boolean usedData;

            public RepeatFunctionProcessor(long count) {
                this.count = count;
            }

            public TableFunctionProcessorState process(List<Optional<Page>> input) {
                if (input == null) {
                    if (this.processedRounds < this.count && this.indexes != null) {
                        ++this.processedRounds;
                        return TableFunctionProcessorState.Processed.produced((Page)new Page(new Block[]{this.indexes}));
                    }
                    return TableFunctionProcessorState.Finished.FINISHED;
                }
                Page page = (Page)((Optional)Iterables.getOnlyElement(input)).orElseThrow();
                if (this.processedRounds == 0L) {
                    BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(page.getPositionCount());
                    for (long index = this.processedPositions; index < this.processedPositions + (long)page.getPositionCount(); ++index) {
                        BigintType.BIGINT.writeLong(builder, index);
                    }
                    this.processedPositions += (long)page.getPositionCount();
                    this.indexes = builder.build();
                    this.usedData = true;
                } else {
                    this.usedData = false;
                }
                ++this.processedRounds;
                Page result = new Page(new Block[]{this.indexes});
                if (this.processedRounds == this.count) {
                    this.processedRounds = 0L;
                    this.indexes = null;
                }
                if (this.usedData) {
                    return TableFunctionProcessorState.Processed.usedInputAndProduced((Page)result);
                }
                return TableFunctionProcessorState.Processed.produced((Page)result);
            }
        }

        public static class RepeatFunctionProcessorProvider
        implements TableFunctionProcessorProvider {
            public TableFunctionDataProcessor getDataProcessor(ConnectorSession session, ConnectorTableFunctionHandle handle) {
                return new RepeatFunctionProcessor(((RepeatFunctionHandle)handle).getCount());
            }
        }
    }

    public static class IdentityPassThroughFunction
    extends AbstractConnectorTableFunction {
        public static final String FUNCTION_NAME = "identity_pass_through_function";

        public IdentityPassThroughFunction() {
            super(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME, (List)ImmutableList.of((Object)TableArgumentSpecification.builder().name("INPUT").passThroughColumns().keepWhenEmpty().build()), (ReturnTypeSpecification)ReturnTypeSpecification.OnlyPassThrough.ONLY_PASS_THROUGH);
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            return TableFunctionAnalysis.builder().handle((ConnectorTableFunctionHandle)new TestingTableFunctionHandle(new SchemaFunctionName(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME))).requiredColumns("INPUT", (List)ImmutableList.of((Object)0)).build();
        }

        public static class IdentityPassThroughFunctionProcessor
        implements TableFunctionDataProcessor {
            private long processedPositions;

            public TableFunctionProcessorState process(List<Optional<Page>> input) {
                if (input == null) {
                    return TableFunctionProcessorState.Finished.FINISHED;
                }
                Page page = (Page)((Optional)Iterables.getOnlyElement(input)).orElseThrow();
                BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(page.getPositionCount());
                for (long index = this.processedPositions; index < this.processedPositions + (long)page.getPositionCount(); ++index) {
                    BigintType.BIGINT.writeLong(builder, index);
                }
                this.processedPositions += (long)page.getPositionCount();
                return TableFunctionProcessorState.Processed.usedInputAndProduced((Page)new Page(new Block[]{builder.build()}));
            }
        }

        public static class IdentityPassThroughFunctionProcessorProvider
        implements TableFunctionProcessorProvider {
            public TableFunctionDataProcessor getDataProcessor(ConnectorSession session, ConnectorTableFunctionHandle handle) {
                return new IdentityPassThroughFunctionProcessor();
            }
        }
    }

    public static class IdentityFunction
    extends AbstractConnectorTableFunction {
        public static final String FUNCTION_NAME = "identity_function";

        public IdentityFunction() {
            super(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME, (List)ImmutableList.of((Object)TableArgumentSpecification.builder().name("INPUT").keepWhenEmpty().build()), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            List inputColumns = ((TableArgument)arguments.get("INPUT")).getRowType().getFields();
            Descriptor returnedType = new Descriptor((List)inputColumns.stream().map(field -> new Descriptor.Field(field.getName().orElse("anonymous_column"), Optional.of(field.getType()))).collect(ImmutableList.toImmutableList()));
            return TableFunctionAnalysis.builder().handle((ConnectorTableFunctionHandle)new TestingTableFunctionHandle(new SchemaFunctionName(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME))).returnedType(returnedType).requiredColumns("INPUT", (List)IntStream.range(0, inputColumns.size()).boxed().collect(ImmutableList.toImmutableList())).build();
        }

        public static class IdentityFunctionProcessorProvider
        implements TableFunctionProcessorProvider {
            public TableFunctionDataProcessor getDataProcessor(ConnectorSession session, ConnectorTableFunctionHandle handle) {
                return input -> {
                    if (input == null) {
                        return TableFunctionProcessorState.Finished.FINISHED;
                    }
                    Optional inputPage = (Optional)Iterables.getOnlyElement((Iterable)input);
                    return (TableFunctionProcessorState)inputPage.map(TableFunctionProcessorState.Processed::usedInputAndProduced).orElseThrow();
                };
            }
        }
    }

    public static class RequiredColumnsFunction
    extends AbstractConnectorTableFunction {
        public static final String FUNCTION_NAME = "required_columns_function";

        public RequiredColumnsFunction() {
            super(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME, (List)ImmutableList.of((Object)TableArgumentSpecification.builder().name("INPUT").keepWhenEmpty().build()), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            return TableFunctionAnalysis.builder().handle((ConnectorTableFunctionHandle)new TestingTableFunctionHandle(new SchemaFunctionName(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME))).returnedType(new Descriptor((List)ImmutableList.of((Object)new Descriptor.Field(TestingTableFunctions.COLUMN_NAME, Optional.of(BooleanType.BOOLEAN))))).requiredColumns("INPUT", (List)ImmutableList.of((Object)0, (Object)1)).build();
        }
    }

    public static class DifferentArgumentTypesFunction
    extends AbstractConnectorTableFunction {
        public static final String FUNCTION_NAME = "different_arguments_function";

        public DifferentArgumentTypesFunction() {
            super(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME, (List)ImmutableList.of((Object)TableArgumentSpecification.builder().name("INPUT_1").passThroughColumns().keepWhenEmpty().build(), (Object)DescriptorArgumentSpecification.builder().name("LAYOUT").build(), (Object)TableArgumentSpecification.builder().name("INPUT_2").rowSemantics().passThroughColumns().build(), (Object)ScalarArgumentSpecification.builder().name("ID").type((Type)BigintType.BIGINT).build(), (Object)TableArgumentSpecification.builder().name("INPUT_3").pruneWhenEmpty().build()), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            return TableFunctionAnalysis.builder().handle((ConnectorTableFunctionHandle)new TestingTableFunctionHandle(new SchemaFunctionName(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME))).returnedType(new Descriptor((List)ImmutableList.of((Object)new Descriptor.Field(TestingTableFunctions.COLUMN_NAME, Optional.of(BooleanType.BOOLEAN))))).requiredColumns("INPUT_1", (List)ImmutableList.of((Object)0)).requiredColumns("INPUT_2", (List)ImmutableList.of((Object)0)).requiredColumns("INPUT_3", (List)ImmutableList.of((Object)0)).build();
        }
    }

    public static class PassThroughFunction
    extends AbstractConnectorTableFunction {
        public PassThroughFunction() {
            super(TestingTableFunctions.SCHEMA_NAME, "pass_through_function", (List)ImmutableList.of((Object)TableArgumentSpecification.builder().name("INPUT").passThroughColumns().keepWhenEmpty().build()), (ReturnTypeSpecification)new ReturnTypeSpecification.DescribedTable(Descriptor.descriptor((List)ImmutableList.of((Object)"x"), (List)ImmutableList.of((Object)BooleanType.BOOLEAN))));
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            return NO_DESCRIPTOR_ANALYSIS;
        }
    }

    public static class PolymorphicStaticReturnTypeFunction
    extends AbstractConnectorTableFunction {
        public PolymorphicStaticReturnTypeFunction() {
            super(TestingTableFunctions.SCHEMA_NAME, "polymorphic_static_return_type_function", (List)ImmutableList.of((Object)TableArgumentSpecification.builder().name("INPUT").keepWhenEmpty().build()), (ReturnTypeSpecification)new ReturnTypeSpecification.DescribedTable(Descriptor.descriptor((List)ImmutableList.of((Object)"a", (Object)"b"), (List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)IntegerType.INTEGER))));
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            return NO_DESCRIPTOR_ANALYSIS;
        }
    }

    public static class MonomorphicStaticReturnTypeFunction
    extends AbstractConnectorTableFunction {
        public MonomorphicStaticReturnTypeFunction() {
            super(TestingTableFunctions.SCHEMA_NAME, "monomorphic_static_return_type_function", (List)ImmutableList.of(), (ReturnTypeSpecification)new ReturnTypeSpecification.DescribedTable(Descriptor.descriptor((List)ImmutableList.of((Object)"a", (Object)"b"), (List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)IntegerType.INTEGER))));
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            return TableFunctionAnalysis.builder().handle(HANDLE).build();
        }
    }

    public static class OnlyPassThroughFunction
    extends AbstractConnectorTableFunction {
        public OnlyPassThroughFunction() {
            super(TestingTableFunctions.SCHEMA_NAME, "only_pass_through_function", (List)ImmutableList.of((Object)TableArgumentSpecification.builder().name("INPUT").passThroughColumns().keepWhenEmpty().build()), (ReturnTypeSpecification)ReturnTypeSpecification.OnlyPassThrough.ONLY_PASS_THROUGH);
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            return NO_DESCRIPTOR_ANALYSIS;
        }
    }

    public static class TwoTableArgumentsFunction
    extends AbstractConnectorTableFunction {
        public static final String FUNCTION_NAME = "two_table_arguments_function";

        public TwoTableArgumentsFunction() {
            super(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME, (List)ImmutableList.of((Object)TableArgumentSpecification.builder().name("INPUT1").keepWhenEmpty().build(), (Object)TableArgumentSpecification.builder().name("INPUT2").keepWhenEmpty().build()), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            return TableFunctionAnalysis.builder().handle((ConnectorTableFunctionHandle)new TestingTableFunctionHandle(new SchemaFunctionName(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME))).returnedType(new Descriptor((List)ImmutableList.of((Object)new Descriptor.Field(TestingTableFunctions.COLUMN_NAME, Optional.of(BooleanType.BOOLEAN))))).requiredColumns("INPUT1", (List)ImmutableList.of((Object)0)).requiredColumns("INPUT2", (List)ImmutableList.of((Object)0)).build();
        }
    }

    public static class DescriptorArgumentFunction
    extends AbstractConnectorTableFunction {
        public DescriptorArgumentFunction() {
            super(TestingTableFunctions.SCHEMA_NAME, "descriptor_argument_function", (List)ImmutableList.of((Object)DescriptorArgumentSpecification.builder().name("SCHEMA").defaultValue(null).build()), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            return ANALYSIS;
        }
    }

    public static class TableArgumentRowSemanticsFunction
    extends AbstractConnectorTableFunction {
        public static final String FUNCTION_NAME = "table_argument_row_semantics_function";

        public TableArgumentRowSemanticsFunction() {
            super(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME, (List)ImmutableList.of((Object)TableArgumentSpecification.builder().name("INPUT").rowSemantics().build()), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            return TableFunctionAnalysis.builder().handle((ConnectorTableFunctionHandle)new TestingTableFunctionHandle(new SchemaFunctionName(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME))).returnedType(new Descriptor((List)ImmutableList.of((Object)new Descriptor.Field(TestingTableFunctions.COLUMN_NAME, Optional.of(BooleanType.BOOLEAN))))).requiredColumns("INPUT", (List)ImmutableList.of((Object)0)).build();
        }
    }

    public static class TableArgumentFunction
    extends AbstractConnectorTableFunction {
        public static final String FUNCTION_NAME = "table_argument_function";

        public TableArgumentFunction() {
            super(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME, (List)ImmutableList.of((Object)TableArgumentSpecification.builder().name("INPUT").keepWhenEmpty().build()), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            return TableFunctionAnalysis.builder().handle((ConnectorTableFunctionHandle)new TestingTableFunctionHandle(new SchemaFunctionName(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME))).returnedType(new Descriptor((List)ImmutableList.of((Object)new Descriptor.Field(TestingTableFunctions.COLUMN_NAME, Optional.of(BooleanType.BOOLEAN))))).requiredColumns("INPUT", (List)ImmutableList.of((Object)0)).build();
        }
    }

    public static class TwoScalarArgumentsFunction
    extends AbstractConnectorTableFunction {
        public TwoScalarArgumentsFunction() {
            super(TestingTableFunctions.SCHEMA_NAME, "two_arguments_function", (List)ImmutableList.of((Object)ScalarArgumentSpecification.builder().name("TEXT").type((Type)VarcharType.VARCHAR).build(), (Object)ScalarArgumentSpecification.builder().name("NUMBER").type((Type)BigintType.BIGINT).defaultValue(null).build()), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            return ANALYSIS;
        }
    }

    public static class SimpleTableFunctionWithAccessControl
    extends SimpleTableFunction {
        @Override
        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            TableFunctionAnalysis analyzeResult = super.analyze(session, transaction, arguments, accessControl);
            SimpleTableFunction.SimpleTableFunctionHandle handle = (SimpleTableFunction.SimpleTableFunctionHandle)analyzeResult.getHandle();
            accessControl.checkCanSelectFromColumns(null, handle.getTableHandle().getTableName(), (Set)ImmutableSet.of((Object)handle.getColumnName()));
            return analyzeResult;
        }
    }

    public static class SimpleTableFunction
    extends AbstractConnectorTableFunction {
        private static final String FUNCTION_NAME = "simple_table_function";
        private static final String TABLE_NAME = "simple_table";

        public SimpleTableFunction() {
            super(TestingTableFunctions.SCHEMA_NAME, FUNCTION_NAME, List.of(ScalarArgumentSpecification.builder().name("COLUMN").type((Type)VarcharType.VARCHAR).defaultValue((Object)Slices.utf8Slice((String)"col")).build(), ScalarArgumentSpecification.builder().name("IGNORED").type((Type)BigintType.BIGINT).defaultValue((Object)0L).build()), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            ScalarArgument argument = (ScalarArgument)arguments.get("COLUMN");
            String columnName = ((Slice)argument.getValue()).toStringUtf8();
            String schema = this.getSchema();
            return TableFunctionAnalysis.builder().handle((ConnectorTableFunctionHandle)new SimpleTableFunctionHandle(schema, TABLE_NAME, columnName)).returnedType(new Descriptor((List)ImmutableList.of((Object)new Descriptor.Field(columnName, Optional.of(BooleanType.BOOLEAN))))).build();
        }

        public static class SimpleTableFunctionHandle
        implements ConnectorTableFunctionHandle {
            private final MockConnectorTableHandle tableHandle;
            private final String columnName;

            public SimpleTableFunctionHandle(String schema, String table, String column) {
                this.tableHandle = new MockConnectorTableHandle(new SchemaTableName(schema, table), (TupleDomain<ColumnHandle>)TupleDomain.all(), Optional.of(ImmutableList.of((Object)new MockConnectorColumnHandle(column, (Type)BooleanType.BOOLEAN))));
                this.columnName = Objects.requireNonNull(column, "column is null");
            }

            public MockConnectorTableHandle getTableHandle() {
                return this.tableHandle;
            }

            public String getColumnName() {
                return this.columnName;
            }
        }
    }
}

