/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.cost.BaseStatsCalculatorTest;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.TestingColumnHandle;
import io.trino.spi.statistics.ColumnStatistics;
import io.trino.spi.statistics.DoubleRange;
import io.trino.spi.statistics.Estimate;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestTableScanStatsRule
extends BaseStatsCalculatorTest {
    @Test
    public void testStatsForTableScan() {
        TestingColumnHandle columnA = new TestingColumnHandle("a");
        TestingColumnHandle columnB = new TestingColumnHandle("b");
        TestingColumnHandle columnC = new TestingColumnHandle("c");
        TestingColumnHandle columnD = new TestingColumnHandle("d");
        TestingColumnHandle columnE = new TestingColumnHandle("e");
        TestingColumnHandle unknownColumn = new TestingColumnHandle("unknown");
        this.tester().assertStatsFor(arg_0 -> TestTableScanStatsRule.lambda$testStatsForTableScan$0((ColumnHandle)columnA, (ColumnHandle)columnB, (ColumnHandle)columnC, (ColumnHandle)columnD, (ColumnHandle)columnE, (ColumnHandle)unknownColumn, arg_0)).withTableStatisticsProvider(arg_0 -> TestTableScanStatsRule.lambda$testStatsForTableScan$1((ColumnHandle)columnA, (ColumnHandle)columnB, (ColumnHandle)columnC, (ColumnHandle)columnD, (ColumnHandle)columnE, (ColumnHandle)unknownColumn, arg_0)).check(check -> check.outputRowsCount(33.0).symbolStats("a", assertion -> assertion.distinctValuesCount(20.0).nullsFraction(0.1)).symbolStats("b", assertion -> assertion.distinctValuesCount(23.1).nullsFraction(0.3)).symbolStats("c", assertion -> assertion.distinctValuesCountUnknown().nullsFractionUnknown().lowValue(15.0).highValue(20.0)).symbolStats("d", assertion -> assertion.distinctValuesCount(33.0).nullsFraction(0.0)).symbolStats("e", assertion -> assertion.distinctValuesCount(31.0).nullsFraction(0.06060606)).symbolStats("unknown", assertion -> assertion.unknownRange().distinctValuesCountUnknown().nullsFractionUnknown().dataSizeUnknown()));
    }

    @Test
    public void testZeroStatsForTableScan() {
        TestingColumnHandle columnHandle = new TestingColumnHandle("zero");
        this.tester().assertStatsFor(arg_0 -> TestTableScanStatsRule.lambda$testZeroStatsForTableScan$0((ColumnHandle)columnHandle, arg_0)).withTableStatisticsProvider(arg_0 -> TestTableScanStatsRule.lambda$testZeroStatsForTableScan$1((ColumnHandle)columnHandle, arg_0)).check(check -> check.outputRowsCount(0.0).symbolStats("zero", assertion -> assertion.isEqualTo(SymbolStatsEstimate.zero())));
    }

    private static /* synthetic */ TableStatistics lambda$testZeroStatsForTableScan$1(ColumnHandle columnHandle, TableHandle tableHandle) {
        return TableStatistics.builder().setRowCount(Estimate.zero()).setColumnStatistics(columnHandle, ColumnStatistics.builder().setDistinctValuesCount(Estimate.zero()).build()).build();
    }

    private static /* synthetic */ PlanNode lambda$testZeroStatsForTableScan$0(ColumnHandle columnHandle, PlanBuilder pb) {
        Symbol column = pb.symbol("zero", (Type)DoubleType.DOUBLE);
        return pb.tableScan((List<Symbol>)ImmutableList.of((Object)column), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)column, (Object)columnHandle));
    }

    private static /* synthetic */ TableStatistics lambda$testStatsForTableScan$1(ColumnHandle columnA, ColumnHandle columnB, ColumnHandle columnC, ColumnHandle columnD, ColumnHandle columnE, ColumnHandle unknownColumn, TableHandle tableHandle) {
        return TableStatistics.builder().setRowCount(Estimate.of((double)33.0)).setColumnStatistics(columnA, ColumnStatistics.builder().setDistinctValuesCount(Estimate.of((double)20.0)).build()).setColumnStatistics(columnB, ColumnStatistics.builder().setNullsFraction(Estimate.of((double)0.3)).setDistinctValuesCount(Estimate.of((double)23.1)).build()).setColumnStatistics(columnC, ColumnStatistics.builder().setRange(new DoubleRange(15.0, 20.0)).build()).setColumnStatistics(columnD, ColumnStatistics.builder().setDistinctValuesCount(Estimate.of((double)33.0)).build()).setColumnStatistics(columnE, ColumnStatistics.builder().setDistinctValuesCount(Estimate.of((double)31.0)).build()).setColumnStatistics(unknownColumn, ColumnStatistics.empty()).build();
    }

    private static /* synthetic */ PlanNode lambda$testStatsForTableScan$0(ColumnHandle columnA, ColumnHandle columnB, ColumnHandle columnC, ColumnHandle columnD, ColumnHandle columnE, ColumnHandle unknownColumn, PlanBuilder pb) {
        Symbol a = pb.symbol("a", (Type)DoubleType.DOUBLE);
        Symbol b = pb.symbol("b", (Type)DoubleType.DOUBLE);
        Symbol c = pb.symbol("c", (Type)DoubleType.DOUBLE);
        Symbol d = pb.symbol("d", (Type)DoubleType.DOUBLE);
        Symbol e = pb.symbol("e", (Type)DoubleType.DOUBLE);
        Symbol unknown = pb.symbol("unknown", (Type)DoubleType.DOUBLE);
        return pb.tableScan((List<Symbol>)ImmutableList.of((Object)a, (Object)b, (Object)c, (Object)d, (Object)e, (Object)unknown), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)a, (Object)columnA, (Object)b, (Object)columnB, (Object)c, (Object)columnC, (Object)d, (Object)columnD, (Object)e, (Object)columnE, (Object)unknown, (Object)unknownColumn));
    }
}

