/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MoreCollectors;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.execution.BaseDataDefinitionTaskTest;
import io.trino.execution.CommentTask;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.metadata.ViewColumn;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SaveMode;
import io.trino.spi.type.BigintType;
import io.trino.sql.tree.Comment;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCommentTask
extends BaseDataDefinitionTaskTest {
    @Test
    public void testCommentTable() {
        QualifiedObjectName tableName = TestCommentTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test_catalog", TestCommentTask.someTable(tableName), SaveMode.FAIL);
        Assertions.assertThat((Optional)this.metadata.getTableMetadata(this.testSession, this.metadata.getTableHandle(this.testSession, tableName).get()).metadata().getComment()).isEmpty();
        MoreFutures.getFutureValue(this.setComment(Comment.Type.TABLE, TestCommentTask.asQualifiedName(tableName), Optional.of("new comment")));
        Assertions.assertThat((Optional)this.metadata.getTableMetadata(this.testSession, this.metadata.getTableHandle(this.testSession, tableName).get()).metadata().getComment()).isEqualTo(Optional.of("new comment"));
    }

    @Test
    public void testCommentTableOnView() {
        QualifiedObjectName viewName = TestCommentTask.qualifiedObjectName("existing_view");
        this.metadata.createView(this.testSession, viewName, TestCommentTask.someView(), (Map<String, Object>)ImmutableMap.of(), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.setComment(Comment.Type.TABLE, TestCommentTask.asQualifiedName(viewName), Optional.of("new comment")))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%1$s' does not exist, but a view with that name exists. Did you mean COMMENT ON VIEW %1$s IS ...?", new Object[]{viewName});
    }

    @Test
    public void testCommentTableOnMaterializedView() {
        QualifiedObjectName materializedViewName = TestCommentTask.qualifiedObjectName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, QualifiedObjectName.valueOf((String)materializedViewName.toString()), this.someMaterializedView(), MATERIALIZED_VIEW_PROPERTIES, false, false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.setComment(Comment.Type.TABLE, TestCommentTask.asQualifiedName(materializedViewName), Optional.of("new comment")))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist, but a materialized view with that name exists. Setting comments on materialized views is unsupported.", new Object[]{materializedViewName});
    }

    @Test
    public void testCommentView() {
        QualifiedObjectName viewName = TestCommentTask.qualifiedObjectName("existing_view");
        this.metadata.createView(this.testSession, viewName, TestCommentTask.someView(), (Map<String, Object>)ImmutableMap.of(), false);
        Assertions.assertThat((boolean)this.metadata.isView(this.testSession, viewName)).isTrue();
        MoreFutures.getFutureValue(this.setComment(Comment.Type.VIEW, TestCommentTask.asQualifiedName(viewName), Optional.of("new comment")));
        Assertions.assertThat((Optional)this.metadata.getView(this.testSession, viewName).get().getComment()).isEqualTo(Optional.of("new comment"));
    }

    @Test
    public void testCommentViewOnTable() {
        QualifiedObjectName tableName = TestCommentTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test_catalog", TestCommentTask.someTable(tableName), SaveMode.FAIL);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.setComment(Comment.Type.VIEW, TestCommentTask.asQualifiedName(tableName), Optional.of("new comment")))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("View '%1$s' does not exist, but a table with that name exists. Did you mean COMMENT ON TABLE %1$s IS ...?", new Object[]{tableName});
    }

    @Test
    public void testCommentViewOnMaterializedView() {
        QualifiedObjectName materializedViewName = TestCommentTask.qualifiedObjectName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, QualifiedObjectName.valueOf((String)materializedViewName.toString()), this.someMaterializedView(), MATERIALIZED_VIEW_PROPERTIES, false, false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.setComment(Comment.Type.VIEW, TestCommentTask.asQualifiedName(materializedViewName), Optional.of("new comment")))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("View '%s' does not exist, but a materialized view with that name exists. Setting comments on materialized views is unsupported.", new Object[]{materializedViewName});
    }

    @Test
    public void testCommentTableColumn() {
        QualifiedObjectName tableName = TestCommentTask.qualifiedObjectName("existing_table");
        QualifiedName columnName = TestCommentTask.qualifiedColumnName("existing_table", "test");
        this.metadata.createTable(this.testSession, "test_catalog", TestCommentTask.someTable(tableName), SaveMode.FAIL);
        MoreFutures.getFutureValue(this.setComment(Comment.Type.COLUMN, columnName, Optional.of("new test column comment")));
        TableHandle tableHandle = this.metadata.getTableHandle(this.testSession, tableName).get();
        ConnectorTableMetadata connectorTableMetadata = this.metadata.getTableMetadata(this.testSession, tableHandle).metadata();
        Assertions.assertThat(Optional.ofNullable(((ColumnMetadata)connectorTableMetadata.getColumns().stream().filter(column -> "test".equals(column.getName())).collect(MoreCollectors.onlyElement())).getComment())).isEqualTo(Optional.of("new test column comment"));
    }

    @Test
    public void testCommentViewColumn() {
        QualifiedObjectName viewName = TestCommentTask.qualifiedObjectName("existing_view");
        QualifiedName columnName = TestCommentTask.qualifiedColumnName("existing_view", "test");
        QualifiedName missingColumnName = TestCommentTask.qualifiedColumnName("existing_view", "missing");
        this.metadata.createView(this.testSession, viewName, TestCommentTask.someView(), (Map<String, Object>)ImmutableMap.of(), false);
        Assertions.assertThat((boolean)this.metadata.isView(this.testSession, viewName)).isTrue();
        MoreFutures.getFutureValue(this.setComment(Comment.Type.COLUMN, columnName, Optional.of("new test column comment")));
        Assertions.assertThat((Optional)((ViewColumn)this.metadata.getView(this.testSession, viewName).get().getColumns().stream().filter(column -> "test".equals(column.name())).collect(MoreCollectors.onlyElement())).comment()).isEqualTo(Optional.of("new test column comment"));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.setComment(Comment.Type.COLUMN, missingColumnName, Optional.of("comment for missing column")))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessageContaining("Column does not exist: %s", new Object[]{missingColumnName.getSuffix()});
    }

    @Test
    public void testCommentOnMixedCaseViewColumn() {
        QualifiedObjectName viewName = TestCommentTask.qualifiedObjectName("existing_view");
        this.metadata.createView(this.testSession, viewName, TestCommentTask.viewDefinition("SELECT 1", (List<ViewColumn>)ImmutableList.of((Object)new ViewColumn("Mixed", BigintType.BIGINT.getTypeId(), Optional.empty()))), (Map<String, Object>)ImmutableMap.of(), false);
        Assertions.assertThat((boolean)this.metadata.isView(this.testSession, viewName)).isTrue();
        QualifiedName columnNameLowerCase = TestCommentTask.qualifiedColumnName("existing_view", "mixed");
        MoreFutures.getFutureValue(this.setComment(Comment.Type.COLUMN, columnNameLowerCase, Optional.of("new mixed column comment")));
        Assertions.assertThat((Optional)((ViewColumn)this.metadata.getView(this.testSession, viewName).get().getColumns().stream().filter(column -> "Mixed".equals(column.name())).collect(MoreCollectors.onlyElement())).comment()).isEqualTo(Optional.of("new mixed column comment"));
        QualifiedName columnNameMixedCase = TestCommentTask.qualifiedColumnName("existing_view", "Mixed");
        MoreFutures.getFutureValue(this.setComment(Comment.Type.COLUMN, columnNameMixedCase, Optional.of("new Mixed column comment")));
        Assertions.assertThat((Optional)((ViewColumn)this.metadata.getView(this.testSession, viewName).get().getColumns().stream().filter(column -> "Mixed".equals(column.name())).collect(MoreCollectors.onlyElement())).comment()).isEqualTo(Optional.of("new Mixed column comment"));
    }

    @Test
    public void testCommentMaterializedViewColumn() {
        QualifiedObjectName materializedViewName = TestCommentTask.qualifiedObjectName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, QualifiedObjectName.valueOf((String)materializedViewName.toString()), this.someMaterializedView(), MATERIALIZED_VIEW_PROPERTIES, false, false);
        Assertions.assertThat((boolean)this.metadata.isMaterializedView(this.testSession, materializedViewName)).isTrue();
        QualifiedName columnName = TestCommentTask.qualifiedColumnName("existing_materialized_view", "test");
        QualifiedName missingColumnName = TestCommentTask.qualifiedColumnName("existing_materialized_view", "missing");
        MoreFutures.getFutureValue(this.setComment(Comment.Type.COLUMN, columnName, Optional.of("new test column comment")));
        Assertions.assertThat((Optional)((ViewColumn)this.metadata.getMaterializedView(this.testSession, materializedViewName).get().getColumns().stream().filter(column -> "test".equals(column.name())).collect(MoreCollectors.onlyElement())).comment()).isEqualTo(Optional.of("new test column comment"));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.setComment(Comment.Type.COLUMN, missingColumnName, Optional.of("comment for missing column")))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessageContaining("Column does not exist: %s", new Object[]{missingColumnName.getSuffix()});
    }

    private ListenableFuture<Void> setComment(Comment.Type type, QualifiedName viewName, Optional<String> comment) {
        return new CommentTask((Metadata)this.metadata, (AccessControl)new AllowAllAccessControl()).execute(new Comment(new NodeLocation(1, 1), type, viewName, comment), this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP);
    }
}

