/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.connector.CatalogServiceProvider;
import io.trino.execution.BaseDataDefinitionTaskTest;
import io.trino.execution.CreateViewTask;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.AnalyzePropertyManager;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TablePropertyManager;
import io.trino.metadata.ViewPropertyManager;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.SaveMode;
import io.trino.spi.session.PropertyMetadata;
import io.trino.sql.PlannerContext;
import io.trino.sql.QueryUtil;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.analyzer.StatementAnalyzerFactory;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.rewrite.StatementRewrite;
import io.trino.sql.tree.AllColumns;
import io.trino.sql.tree.CreateView;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.SelectItem;
import io.trino.sql.tree.StringLiteral;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
public class TestCreateViewTask
extends BaseDataDefinitionTaskTest {
    private static final String CATALOG_NAME = "catalog";
    private SqlParser parser;
    private AnalyzerFactory analyzerFactory;

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.parser = new SqlParser();
        this.analyzerFactory = new AnalyzerFactory(StatementAnalyzerFactory.createTestingStatementAnalyzerFactory((PlannerContext)this.plannerContext, (AccessControl)new AllowAllAccessControl(), (TablePropertyManager)new TablePropertyManager(CatalogServiceProvider.fail()), (AnalyzePropertyManager)new AnalyzePropertyManager(CatalogServiceProvider.fail())), new StatementRewrite((Set)ImmutableSet.of()), this.plannerContext.getTracer());
        QualifiedObjectName tableName = TestCreateViewTask.qualifiedObjectName("mock_table");
        this.metadata.createTable(this.testSession, CATALOG_NAME, TestCreateViewTask.someTable(tableName), SaveMode.FAIL);
    }

    @Test
    public void testCreateViewOnViewIfNotExists() {
        QualifiedObjectName viewName = TestCreateViewTask.qualifiedObjectName("new_view");
        MoreFutures.getFutureValue(this.executeCreateView(TestCreateViewTask.asQualifiedName(viewName), false));
        Assertions.assertThat((boolean)this.metadata.isView(this.testSession, viewName)).isTrue();
    }

    @Test
    public void testCreateViewOnViewIfExists() {
        QualifiedObjectName viewName = TestCreateViewTask.qualifiedObjectName("existing_view");
        this.metadata.createView(this.testSession, viewName, TestCreateViewTask.someView(), (Map<String, Object>)ImmutableMap.of(), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeCreateView(TestCreateViewTask.asQualifiedName(viewName), false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_ALREADY_EXISTS}).hasMessage("line 1:1: View already exists: '%s'", new Object[]{viewName});
    }

    @Test
    public void testReplaceViewOnViewIfExists() {
        QualifiedObjectName viewName = TestCreateViewTask.qualifiedObjectName("existing_view");
        this.metadata.createView(this.testSession, viewName, TestCreateViewTask.someView(), (Map<String, Object>)ImmutableMap.of(), false);
        MoreFutures.getFutureValue(this.executeCreateView(TestCreateViewTask.asQualifiedName(viewName), true));
        Assertions.assertThat((boolean)this.metadata.isView(this.testSession, viewName)).isTrue();
    }

    @Test
    public void testCreateViewOnTableIfExists() {
        QualifiedObjectName tableName = TestCreateViewTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, CATALOG_NAME, TestCreateViewTask.someTable(tableName), SaveMode.FAIL);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeCreateView(TestCreateViewTask.asQualifiedName(tableName), false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_ALREADY_EXISTS}).hasMessage("line 1:1: Table already exists: '%s'", new Object[]{tableName, tableName});
    }

    @Test
    public void testReplaceViewOnTableIfExists() {
        QualifiedObjectName tableName = TestCreateViewTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, CATALOG_NAME, TestCreateViewTask.someTable(tableName), SaveMode.FAIL);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeCreateView(TestCreateViewTask.asQualifiedName(tableName), true))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_ALREADY_EXISTS}).hasMessage("line 1:1: Table already exists: '%s'", new Object[]{tableName, tableName});
    }

    @Test
    public void testCreateViewOnMaterializedView() {
        QualifiedObjectName viewName = TestCreateViewTask.qualifiedObjectName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, viewName, this.someMaterializedView(), MATERIALIZED_VIEW_PROPERTIES, false, false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeCreateView(TestCreateViewTask.asQualifiedName(viewName), false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_ALREADY_EXISTS}).hasMessage("line 1:1: Materialized view already exists: '%s'", new Object[]{viewName});
    }

    @Test
    public void testCreateViewWithUnknownProperty() {
        QualifiedObjectName viewName = TestCreateViewTask.qualifiedObjectName("view_with_unknown_property");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeCreateView(TestCreateViewTask.asQualifiedName(viewName), (List<Property>)ImmutableList.of((Object)new Property(new NodeLocation(1, 88), new Identifier("unknown_property"), (Expression)new StringLiteral("unknown"))), false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_VIEW_PROPERTY}).hasMessage("line 1:88: Catalog 'test_catalog' view property 'unknown_property' does not exist");
    }

    @Test
    public void testCreateViewWithInvalidProperty() {
        QualifiedObjectName viewName = TestCreateViewTask.qualifiedObjectName("view_with_unknown_property");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeCreateView(TestCreateViewTask.asQualifiedName(viewName), (List<Property>)ImmutableList.of((Object)new Property(new NodeLocation(1, 88), new Identifier("boolean_property"), (Expression)new StringLiteral("unknown"))), false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_VIEW_PROPERTY}).hasMessage("line 1:88: Invalid value for catalog 'test_catalog' view property 'boolean_property': Cannot convert ['unknown'] to boolean");
    }

    private ListenableFuture<Void> executeCreateView(QualifiedName viewName, boolean replace) {
        return this.executeCreateView(viewName, (List<Property>)ImmutableList.of(), replace);
    }

    private ListenableFuture<Void> executeCreateView(QualifiedName viewName, List<Property> viewProperties, boolean replace) {
        Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"mock_table")));
        CreateView statement = new CreateView(new NodeLocation(1, 1), viewName, query, replace, Optional.empty(), Optional.empty(), viewProperties);
        return new CreateViewTask(this.plannerContext, (AccessControl)new AllowAllAccessControl(), this.parser, this.analyzerFactory, new ViewPropertyManager(catalogHandle -> ImmutableMap.of((Object)"boolean_property", (Object)PropertyMetadata.booleanProperty((String)"boolean_property", (String)"Mock description", (Boolean)false, (boolean)false)))).execute(statement, this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP);
    }
}

