/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import io.airlift.units.DataSize;
import io.trino.execution.HeapSizeParser;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestHeapSizeParser {
    private static final Supplier<Long> MAX_HEAP_MEMORY = () -> DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.GIGABYTE).toBytes();
    private static final HeapSizeParser HEAP_SIZE_PARSER = new HeapSizeParser(MAX_HEAP_MEMORY);

    TestHeapSizeParser() {
    }

    @Test
    void testAbsoluteMemory() {
        Assertions.assertThat((Comparable)HEAP_SIZE_PARSER.parse("1GB")).isEqualTo((Object)DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        Assertions.assertThat((Comparable)HEAP_SIZE_PARSER.parse("8GB")).isEqualTo((Object)DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> HEAP_SIZE_PARSER.parse("9GB")).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Heap size cannot be greater than maximum heap size");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> HEAP_SIZE_PARSER.parse("0B")).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Heap size cannot be less than or equal to 0");
    }

    @Test
    void testRelativeMemory() {
        Assertions.assertThat((Comparable)HEAP_SIZE_PARSER.parse("12.5%")).isEqualTo((Object)DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        Assertions.assertThat((Comparable)HEAP_SIZE_PARSER.parse("100%")).isEqualTo((Object)DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        Assertions.assertThat((Comparable)HEAP_SIZE_PARSER.parse("50%")).isEqualTo((Object)DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> HEAP_SIZE_PARSER.parse("125%")).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Heap size cannot be greater than maximum heap size");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> HEAP_SIZE_PARSER.parse("0%")).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Heap size cannot be less than or equal to 0");
    }
}

