/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.trino.memory.NodeMemoryConfig;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestNodeMemoryConfig {
    private static final long AVAILABLE_HEAP_MEMORY = Runtime.getRuntime().maxMemory();

    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((NodeMemoryConfig)ConfigAssertions.recordDefaults(NodeMemoryConfig.class)).setMaxQueryMemoryPerNode(DataSize.ofBytes((long)Math.round((double)AVAILABLE_HEAP_MEMORY * 0.3)).toString()).setHeapHeadroom(DataSize.ofBytes((long)Math.round((double)AVAILABLE_HEAP_MEMORY * 0.3)).toString()));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"query.max-memory-per-node", (Object)"1GB").put((Object)"memory.heap-headroom-per-node", (Object)"1GB").buildOrThrow();
        NodeMemoryConfig expected = new NodeMemoryConfig().setMaxQueryMemoryPerNode("1GB").setHeapHeadroom("1GB");
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testExplicitPropertyMappingsWithRelativeValues() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"query.max-memory-per-node", (Object)"50%").put((Object)"memory.heap-headroom-per-node", (Object)"25%").buildOrThrow();
        NodeMemoryConfig expected = new NodeMemoryConfig().setMaxQueryMemoryPerNode(DataSize.ofBytes((long)Math.round((double)AVAILABLE_HEAP_MEMORY * 0.5)).toString()).setHeapHeadroom(DataSize.ofBytes((long)Math.round((double)AVAILABLE_HEAP_MEMORY * 0.25)).toString());
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

