/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.trino.jmh.Benchmarks;
import io.trino.operator.CyclingGroupByHash;
import io.trino.operator.GroupByHash;
import io.trino.operator.GroupedTopNBuilder;
import io.trino.operator.GroupedTopNRankBuilder;
import io.trino.operator.PageWithPositionComparator;
import io.trino.operator.PageWithPositionEqualsAndHash;
import io.trino.operator.SimplePageWithPositionEqualsAndHash;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.OrderingCompiler;
import io.trino.tpch.LineItem;
import io.trino.tpch.LineItemGenerator;
import io.trino.type.BlockTypeOperators;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=4)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkGroupedTopNRankBuilder {
    private static final int EXTENDED_PRICE = 0;
    private static final int DISCOUNT = 1;
    private static final int STATUS = 2;
    private static final int QUANTITY = 3;

    @Benchmark
    public long processTopNInput(BenchmarkData data) {
        GroupedTopNBuilder builder = data.newTopNBuilder();
        Page inputPage = data.getPage();
        for (int i = 0; i < data.addPageCalls; ++i) {
            if (builder.processPage(inputPage).process()) continue;
            throw new IllegalStateException("Work did not complete");
        }
        return builder.getEstimatedSizeInBytes();
    }

    @Benchmark
    public List<Page> topN(BenchmarkData data) {
        GroupedTopNBuilder builder = data.newTopNBuilder();
        Page inputPage = data.getPage();
        for (int i = 0; i < data.addPageCalls; ++i) {
            if (builder.processPage(inputPage).process()) continue;
            throw new IllegalStateException("Work did not complete");
        }
        return ImmutableList.copyOf((Iterator)builder.buildResult());
    }

    public static void main(String[] args) throws RunnerException {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        BenchmarkGroupedTopNRankBuilder benchmark = new BenchmarkGroupedTopNRankBuilder();
        benchmark.topN(data);
        benchmark.processTopNInput(data);
        Benchmarks.benchmark(BenchmarkGroupedTopNRankBuilder.class).run();
    }

    private static Page createInputPage(int positions, List<Type> types) {
        PageBuilder pageBuilder = new PageBuilder(types);
        LineItemGenerator lineItemGenerator = new LineItemGenerator(1.0, 1, 1);
        Iterator iterator = lineItemGenerator.iterator();
        for (int i = 0; i < positions; ++i) {
            pageBuilder.declarePosition();
            LineItem lineItem = (LineItem)iterator.next();
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(0), lineItem.extendedPrice());
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(1), lineItem.discount());
            VarcharType.VARCHAR.writeString(pageBuilder.getBlockBuilder(2), lineItem.status());
            BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(3), lineItem.quantity());
        }
        return pageBuilder.build();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"1", "10", "100"})
        private int topN = 1;
        @Param(value={"10000", "1000000"})
        private int positions = 1;
        @Param(value={"1", "10000", "1000000"})
        private int groupCount = 1;
        @Param(value={"100"})
        private int addPageCalls = 100;
        private List<Type> types;
        private PageWithPositionComparator comparator;
        private PageWithPositionEqualsAndHash equalsAndHash;
        private Page page;

        @Setup
        public void setup() {
            this.types = ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT);
            TypeOperators typeOperators = new TypeOperators();
            BlockTypeOperators blockTypeOperators = new BlockTypeOperators(typeOperators);
            OrderingCompiler orderingCompiler = new OrderingCompiler(typeOperators);
            ImmutableList sortChannels = ImmutableList.of((Object)0, (Object)2);
            List sortTypes = (List)sortChannels.stream().map(this.types::get).collect(ImmutableList.toImmutableList());
            this.comparator = orderingCompiler.compilePageWithPositionComparator(sortTypes, (List)sortChannels, (List)ImmutableList.of((Object)SortOrder.DESC_NULLS_LAST, (Object)SortOrder.ASC_NULLS_FIRST));
            this.equalsAndHash = new SimplePageWithPositionEqualsAndHash(sortTypes, (List)sortChannels, blockTypeOperators);
            this.page = BenchmarkGroupedTopNRankBuilder.createInputPage(this.positions, this.types);
        }

        public GroupedTopNBuilder newTopNBuilder() {
            return new GroupedTopNRankBuilder(this.types, this.comparator, this.equalsAndHash, this.topN, true, new int[0], (GroupByHash)new CyclingGroupByHash(this.groupCount));
        }

        public Page getPage() {
            return this.page;
        }
    }
}

