/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.trino.jmh.Benchmarks;
import io.trino.operator.CyclingGroupByHash;
import io.trino.operator.GroupByHash;
import io.trino.operator.GroupedTopNRowNumberBuilder;
import io.trino.operator.PageWithPositionComparator;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.gen.OrderingCompiler;
import io.trino.tpch.LineItem;
import io.trino.tpch.LineItemGenerator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=4)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkGroupedTopNRowNumberBuilder {
    private static final int EXTENDED_PRICE = 0;
    private static final int DISCOUNT = 1;
    private static final int SHIP_DATE = 2;
    private static final int QUANTITY = 3;

    @Benchmark
    public long processTopNInput(BenchmarkData data) {
        GroupedTopNRowNumberBuilder topNBuilder = data.newTopNRowNumberBuilder();
        Page inputPage = data.getPage();
        for (int i = 0; i < data.addPageCalls; ++i) {
            if (topNBuilder.processPage(inputPage).process()) continue;
            throw new IllegalStateException("Work did not complete");
        }
        return topNBuilder.getEstimatedSizeInBytes();
    }

    @Benchmark
    public List<Page> topN(BenchmarkData data) {
        GroupedTopNRowNumberBuilder topNBuilder = data.newTopNRowNumberBuilder();
        Page inputPage = data.getPage();
        for (int i = 0; i < data.addPageCalls; ++i) {
            if (topNBuilder.processPage(inputPage).process()) continue;
            throw new IllegalStateException("Work did not complete");
        }
        return ImmutableList.copyOf((Iterator)topNBuilder.buildResult());
    }

    public static void main(String[] args) throws RunnerException {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        BenchmarkGroupedTopNRowNumberBuilder benchmark = new BenchmarkGroupedTopNRowNumberBuilder();
        benchmark.topN(data);
        benchmark.processTopNInput(data);
        Benchmarks.benchmark(BenchmarkGroupedTopNRowNumberBuilder.class).run();
    }

    private static Page createInputPage(int positions, List<Type> types) {
        PageBuilder pageBuilder = new PageBuilder(types);
        LineItemGenerator lineItemGenerator = new LineItemGenerator(1.0, 1, 1);
        Iterator iterator = lineItemGenerator.iterator();
        for (int i = 0; i < positions; ++i) {
            pageBuilder.declarePosition();
            LineItem lineItem = (LineItem)iterator.next();
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(0), lineItem.extendedPrice());
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(1), lineItem.discount());
            DateType.DATE.writeLong(pageBuilder.getBlockBuilder(2), (long)lineItem.shipDate());
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(3), (double)lineItem.quantity());
        }
        return pageBuilder.build();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private final List<Type> types = ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE, (Object)DateType.DATE, (Object)DoubleType.DOUBLE);
        @Param(value={"1", "10", "100"})
        private int topN = 1;
        @Param(value={"10000", "1000000"})
        private int positions = 1000;
        @Param(value={"1", "10000", "1000000"})
        private int groupCount = 1;
        @Param(value={"100"})
        private int addPageCalls = 1;
        private PageWithPositionComparator comparator;
        private Page page;

        @Setup
        public void setup() {
            OrderingCompiler orderingCompiler = new OrderingCompiler(new TypeOperators());
            ImmutableList sortColumns = ImmutableList.of((Object)0, (Object)2);
            List sortTypes = (List)sortColumns.stream().map(this.types::get).collect(ImmutableList.toImmutableList());
            ImmutableList sortOrders = ImmutableList.of((Object)SortOrder.DESC_NULLS_LAST, (Object)SortOrder.ASC_NULLS_FIRST);
            this.comparator = orderingCompiler.compilePageWithPositionComparator(sortTypes, (List)sortColumns, (List)sortOrders);
            this.page = BenchmarkGroupedTopNRowNumberBuilder.createInputPage(this.positions, this.types);
        }

        public GroupedTopNRowNumberBuilder newTopNRowNumberBuilder() {
            return new GroupedTopNRowNumberBuilder(this.types, this.comparator, this.topN, false, new int[0], (GroupByHash)new CyclingGroupByHash(this.groupCount));
        }

        public Page getPage() {
            return this.page;
        }
    }
}

