/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.trino.SessionTestUtils;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.InternalFunctionDependencies;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.OperatorNameUtil;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.SignatureBinder;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.operator.AnnotationEngineAssertions;
import io.trino.operator.ParametricImplementationsGroup;
import io.trino.operator.aggregation.AggregationFromAnnotationsParser;
import io.trino.operator.aggregation.AggregationFunctionAdapter;
import io.trino.operator.aggregation.ParametricAggregation;
import io.trino.operator.aggregation.ParametricAggregationImplementation;
import io.trino.operator.aggregation.state.LongState;
import io.trino.operator.aggregation.state.NullableDoubleState;
import io.trino.operator.aggregation.state.NullableLongState;
import io.trino.operator.aggregation.state.TriStateBooleanState;
import io.trino.operator.aggregation.state.VarianceState;
import io.trino.operator.annotations.ImplementationDependency;
import io.trino.operator.annotations.LiteralImplementationDependency;
import io.trino.operator.annotations.OperatorImplementationDependency;
import io.trino.operator.annotations.TypeImplementationDependency;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationFunctionMetadata;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Constraint;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.FunctionDependencies;
import io.trino.spi.function.FunctionDependencyDeclaration;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.Signature;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.TypeParameterSpecialization;
import io.trino.spi.function.TypeParameters;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.tree.QualifiedName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TestAnnotationEngineForAggregates {
    private static final FunctionManager FUNCTION_MANAGER = FunctionManager.createTestingFunctionManager();
    private static final FunctionDependencies NO_FUNCTION_DEPENDENCIES = new InternalFunctionDependencies((arg_0, arg_1) -> ((FunctionManager)FUNCTION_MANAGER).getScalarFunctionImplementation(arg_0, arg_1), (Map)ImmutableMap.of(), (Collection)ImmutableSet.of());

    @Test
    public void testSimpleExactAggregationParse() {
        Signature expectedSignature = Signature.builder().returnType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).build();
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(ExactAggregationFunction.class));
        Assertions.assertThat((String)aggregation.getFunctionMetadata().getDescription()).isEqualTo("Simple exact aggregate description");
        Assertions.assertThat((boolean)aggregation.getFunctionMetadata().isDeterministic()).isTrue();
        Assertions.assertThat((Object)aggregation.getFunctionMetadata().getSignature()).isEqualTo((Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        AnnotationEngineAssertions.assertImplementationCount(implementations, 1, 0, 0);
        ParametricAggregationImplementation implementation = (ParametricAggregationImplementation)Iterables.getOnlyElement(implementations.getExactImplementations().values());
        Assertions.assertThat((Class)implementation.getDefinitionClass()).isEqualTo(ExactAggregationFunction.class);
        AnnotationEngineAssertions.assertDependencyCount(implementation, 0, 0, 0);
        Assertions.assertThat((boolean)implementation.hasSpecializedTypeParameters()).isFalse();
        Assertions.assertThat((List)implementation.getInputParameterKinds()).isEqualTo((Object)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        BoundSignature boundSignature = TestAnnotationEngineForAggregates.builtinFunction("simple_exact_aggregate", (Type)DoubleType.DOUBLE, (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE));
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata();
        Assertions.assertThat((boolean)aggregationMetadata.isOrderSensitive()).isFalse();
        Assertions.assertThat((List)aggregationMetadata.getIntermediateTypes()).isNotEmpty();
        aggregation.specialize(boundSignature, NO_FUNCTION_DEPENDENCIES);
    }

    @Test
    public void testInputParameterOrderEnforced() {
        Assertions.assertThatThrownBy(() -> AggregationFromAnnotationsParser.parseFunctionDefinitions(InputParametersWrongOrder.class)).hasMessage("Expected input function non-dependency parameters to begin with state types [NullableDoubleState]: public static void io.trino.operator.TestAnnotationEngineForAggregates$InputParametersWrongOrder.input(double,io.trino.operator.aggregation.state.NullableDoubleState)");
    }

    @Test
    public void testOutputParameterOrderEnforced() {
        Assertions.assertThatThrownBy(() -> AggregationFromAnnotationsParser.parseFunctionDefinitions(OutputParametersWrongOrder.class)).hasMessage("Expected output function non-dependency parameters to be [NullableDoubleState, BlockBuilder]: public static void io.trino.operator.TestAnnotationEngineForAggregates$OutputParametersWrongOrder.output(io.trino.spi.block.BlockBuilder,io.trino.operator.aggregation.state.NullableDoubleState)");
    }

    @Test
    public void testNotAnnotatedAggregateStateAggregationParse() {
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(NotAnnotatedAggregateStateAggregationFunction.class));
        ParametricAggregationImplementation implementation = (ParametricAggregationImplementation)Iterables.getOnlyElement(aggregation.getImplementations().getExactImplementations().values());
        Assertions.assertThat((List)implementation.getInputParameterKinds()).isEqualTo((Object)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        BoundSignature boundSignature = TestAnnotationEngineForAggregates.builtinFunction(aggregation.getFunctionMetadata().getCanonicalName(), (Type)DoubleType.DOUBLE, (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE));
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata();
        Assertions.assertThat((boolean)aggregationMetadata.isOrderSensitive()).isFalse();
        Assertions.assertThat((List)aggregationMetadata.getIntermediateTypes()).isNotEmpty();
        aggregation.specialize(boundSignature, NO_FUNCTION_DEPENDENCIES);
    }

    @Test
    public void testNotDecomposableAggregationParse() {
        Signature expectedSignature = Signature.builder().returnType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).build();
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(NotDecomposableAggregationFunction.class));
        Assertions.assertThat((String)aggregation.getFunctionMetadata().getDescription()).isEqualTo("Aggregate with Decomposable=false");
        Assertions.assertThat((boolean)aggregation.getFunctionMetadata().isDeterministic()).isTrue();
        Assertions.assertThat((Object)aggregation.getFunctionMetadata().getSignature()).isEqualTo((Object)expectedSignature);
        BoundSignature boundSignature = TestAnnotationEngineForAggregates.builtinFunction(aggregation.getFunctionMetadata().getCanonicalName(), (Type)DoubleType.DOUBLE, (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE));
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata();
        Assertions.assertThat((boolean)aggregationMetadata.isOrderSensitive()).isFalse();
        Assertions.assertThat((List)aggregationMetadata.getIntermediateTypes()).isEmpty();
        aggregation.specialize(boundSignature, NO_FUNCTION_DEPENDENCIES);
    }

    @Test
    public void testSimpleGenericAggregationFunctionParse() {
        Signature expectedSignature = Signature.builder().typeVariable("T").returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).build();
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(GenericAggregationFunction.class));
        Assertions.assertThat((String)aggregation.getFunctionMetadata().getDescription()).isEqualTo("Simple aggregate with two generic implementations");
        Assertions.assertThat((boolean)aggregation.getFunctionMetadata().isDeterministic()).isTrue();
        Assertions.assertThat((Object)aggregation.getFunctionMetadata().getSignature()).isEqualTo((Object)expectedSignature);
        Assertions.assertThat((List)aggregation.getStateDetails()).isEqualTo((Object)ImmutableList.of((Object)AggregationFromAnnotationsParser.toAccumulatorStateDetails(NullableLongState.class, (List)ImmutableList.of())));
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        AnnotationEngineAssertions.assertImplementationCount(implementations, 0, 0, 2);
        ParametricAggregationImplementation implementationDouble = (ParametricAggregationImplementation)((ImmutableList)implementations.getGenericImplementations().stream().filter(impl -> impl.getInputFunction().type().equals((Object)MethodType.methodType(Void.TYPE, NullableLongState.class, Double.TYPE))).collect(ImmutableList.toImmutableList())).get(0);
        Assertions.assertThat((Class)implementationDouble.getDefinitionClass()).isEqualTo(GenericAggregationFunction.class);
        AnnotationEngineAssertions.assertDependencyCount(implementationDouble, 0, 0, 0);
        Assertions.assertThat((boolean)implementationDouble.hasSpecializedTypeParameters()).isFalse();
        Assertions.assertThat((List)implementationDouble.getInputParameterKinds()).isEqualTo((Object)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        ParametricAggregationImplementation implementationLong = (ParametricAggregationImplementation)((ImmutableList)implementations.getGenericImplementations().stream().filter(impl -> impl.getInputFunction().type().equals((Object)MethodType.methodType(Void.TYPE, NullableLongState.class, Long.TYPE))).collect(ImmutableList.toImmutableList())).get(0);
        Assertions.assertThat((Class)implementationLong.getDefinitionClass()).isEqualTo(GenericAggregationFunction.class);
        AnnotationEngineAssertions.assertDependencyCount(implementationLong, 0, 0, 0);
        Assertions.assertThat((boolean)implementationLong.hasSpecializedTypeParameters()).isFalse();
        Assertions.assertThat((List)implementationLong.getInputParameterKinds()).isEqualTo((Object)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        BoundSignature boundSignature = TestAnnotationEngineForAggregates.builtinFunction(aggregation.getFunctionMetadata().getCanonicalName(), (Type)DoubleType.DOUBLE, (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE));
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata();
        Assertions.assertThat((boolean)aggregationMetadata.isOrderSensitive()).isFalse();
        Assertions.assertThat((List)aggregationMetadata.getIntermediateTypes()).isNotEmpty();
        aggregation.specialize(boundSignature, NO_FUNCTION_DEPENDENCIES);
    }

    @Test
    public void testSimpleBlockInputAggregationParse() {
        Signature expectedSignature = Signature.builder().returnType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).build();
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(BlockInputAggregationFunction.class));
        Assertions.assertThat((String)aggregation.getFunctionMetadata().getDescription()).isEqualTo("Simple aggregate with @BlockPosition usage");
        Assertions.assertThat((boolean)aggregation.getFunctionMetadata().isDeterministic()).isTrue();
        Assertions.assertThat((Object)aggregation.getFunctionMetadata().getSignature()).isEqualTo((Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        AnnotationEngineAssertions.assertImplementationCount(implementations, 1, 0, 0);
        ParametricAggregationImplementation implementation = (ParametricAggregationImplementation)Iterables.getOnlyElement(implementations.getExactImplementations().values());
        Assertions.assertThat((Class)implementation.getDefinitionClass()).isEqualTo(BlockInputAggregationFunction.class);
        AnnotationEngineAssertions.assertDependencyCount(implementation, 0, 0, 0);
        Assertions.assertThat((boolean)implementation.hasSpecializedTypeParameters()).isFalse();
        Assertions.assertThat((List)implementation.getInputParameterKinds()).isEqualTo((Object)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.BLOCK_INPUT_CHANNEL, (Object)AggregationFunctionAdapter.AggregationParameterKind.BLOCK_INDEX));
        BoundSignature boundSignature = TestAnnotationEngineForAggregates.builtinFunction(aggregation.getFunctionMetadata().getCanonicalName(), (Type)DoubleType.DOUBLE, (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE));
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata();
        Assertions.assertThat((boolean)aggregationMetadata.isOrderSensitive()).isFalse();
        Assertions.assertThat((List)aggregationMetadata.getIntermediateTypes()).isNotEmpty();
        aggregation.specialize(boundSignature, NO_FUNCTION_DEPENDENCIES);
    }

    @Test
    @Disabled
    public void testSimpleImplicitSpecializedAggregationParse() {
        Signature expectedSignature = Signature.builder().typeVariable("T").returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).build();
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(ImplicitSpecializedAggregationFunction.class));
        Assertions.assertThat((String)aggregation.getFunctionMetadata().getDescription()).isEqualTo("Simple implicit specialized aggregate");
        Assertions.assertThat((boolean)aggregation.getFunctionMetadata().isDeterministic()).isTrue();
        Assertions.assertThat((Object)aggregation.getFunctionMetadata().getSignature()).isEqualTo((Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        AnnotationEngineAssertions.assertImplementationCount(implementations, 0, 0, 2);
        ParametricAggregationImplementation implementation1 = (ParametricAggregationImplementation)implementations.getSpecializedImplementations().get(0);
        Assertions.assertThat((boolean)implementation1.hasSpecializedTypeParameters()).isTrue();
        Assertions.assertThat((boolean)implementation1.hasSpecializedTypeParameters()).isFalse();
        Assertions.assertThat((List)implementation1.getInputParameterKinds()).isEqualTo((Object)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        ParametricAggregationImplementation implementation2 = (ParametricAggregationImplementation)implementations.getSpecializedImplementations().get(1);
        Assertions.assertThat((boolean)implementation2.hasSpecializedTypeParameters()).isTrue();
        Assertions.assertThat((boolean)implementation2.hasSpecializedTypeParameters()).isFalse();
        Assertions.assertThat((List)implementation2.getInputParameterKinds()).isEqualTo((Object)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        BoundSignature boundSignature = TestAnnotationEngineForAggregates.builtinFunction(aggregation.getFunctionMetadata().getCanonicalName(), (Type)DoubleType.DOUBLE, (List<Type>)ImmutableList.of((Object)new ArrayType((Type)DoubleType.DOUBLE)));
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata();
        Assertions.assertThat((boolean)aggregationMetadata.isOrderSensitive()).isFalse();
        Assertions.assertThat((List)aggregationMetadata.getIntermediateTypes()).isNotEmpty();
        aggregation.specialize(boundSignature, NO_FUNCTION_DEPENDENCIES);
    }

    @Test
    @Disabled
    public void testSimpleExplicitSpecializedAggregationParse() {
        Signature expectedSignature = Signature.builder().typeVariable("T").returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).build();
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(ExplicitSpecializedAggregationFunction.class));
        Assertions.assertThat((String)aggregation.getFunctionMetadata().getDescription()).isEqualTo("Simple explicit specialized aggregate");
        Assertions.assertThat((boolean)aggregation.getFunctionMetadata().isDeterministic()).isTrue();
        Assertions.assertThat((Object)aggregation.getFunctionMetadata().getSignature()).isEqualTo((Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        AnnotationEngineAssertions.assertImplementationCount(implementations, 0, 1, 1);
        ParametricAggregationImplementation implementation1 = (ParametricAggregationImplementation)implementations.getSpecializedImplementations().get(0);
        Assertions.assertThat((boolean)implementation1.hasSpecializedTypeParameters()).isTrue();
        Assertions.assertThat((boolean)implementation1.hasSpecializedTypeParameters()).isFalse();
        Assertions.assertThat((List)implementation1.getInputParameterKinds()).isEqualTo((Object)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        ParametricAggregationImplementation implementation2 = (ParametricAggregationImplementation)implementations.getSpecializedImplementations().get(1);
        Assertions.assertThat((boolean)implementation2.hasSpecializedTypeParameters()).isTrue();
        Assertions.assertThat((boolean)implementation2.hasSpecializedTypeParameters()).isFalse();
        Assertions.assertThat((List)implementation2.getInputParameterKinds()).isEqualTo((Object)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        BoundSignature boundSignature = TestAnnotationEngineForAggregates.builtinFunction(aggregation.getFunctionMetadata().getCanonicalName(), (Type)DoubleType.DOUBLE, (List<Type>)ImmutableList.of((Object)new ArrayType((Type)DoubleType.DOUBLE)));
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata();
        Assertions.assertThat((boolean)aggregationMetadata.isOrderSensitive()).isFalse();
        Assertions.assertThat((List)aggregationMetadata.getIntermediateTypes()).isNotEmpty();
        aggregation.specialize(boundSignature, NO_FUNCTION_DEPENDENCIES);
    }

    @Test
    public void testMultiOutputAggregationParse() {
        Signature expectedSignature1 = Signature.builder().returnType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).build();
        Signature expectedSignature2 = Signature.builder().returnType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).build();
        List aggregations = AggregationFromAnnotationsParser.parseFunctionDefinitions(MultiOutputAggregationFunction.class);
        Assertions.assertThat((List)aggregations).hasSize(2);
        ParametricAggregation aggregation1 = (ParametricAggregation)((ImmutableList)aggregations.stream().filter(aggregate -> aggregate.getFunctionMetadata().getCanonicalName().equals("multi_output_aggregate_1")).collect(ImmutableList.toImmutableList())).get(0);
        Assertions.assertThat((Object)aggregation1.getFunctionMetadata().getSignature()).isEqualTo((Object)expectedSignature1);
        Assertions.assertThat((String)aggregation1.getFunctionMetadata().getDescription()).isEqualTo("Simple multi output function aggregate specialized description");
        ParametricAggregation aggregation2 = (ParametricAggregation)((ImmutableList)aggregations.stream().filter(aggregate -> aggregate.getFunctionMetadata().getCanonicalName().equals("multi_output_aggregate_2")).collect(ImmutableList.toImmutableList())).get(0);
        Assertions.assertThat((Object)aggregation2.getFunctionMetadata().getSignature()).isEqualTo((Object)expectedSignature2);
        Assertions.assertThat((String)aggregation2.getFunctionMetadata().getDescription()).isEqualTo("Simple multi output function aggregate generic description");
        ParametricImplementationsGroup implementations1 = aggregation1.getImplementations();
        AnnotationEngineAssertions.assertImplementationCount(implementations1, 1, 0, 0);
        ParametricImplementationsGroup implementations2 = aggregation2.getImplementations();
        AnnotationEngineAssertions.assertImplementationCount(implementations2, 1, 0, 0);
        ParametricAggregationImplementation implementation = (ParametricAggregationImplementation)Iterables.getOnlyElement(implementations1.getExactImplementations().values());
        Assertions.assertThat((Class)implementation.getDefinitionClass()).isEqualTo(MultiOutputAggregationFunction.class);
        AnnotationEngineAssertions.assertDependencyCount(implementation, 0, 0, 0);
        Assertions.assertThat((boolean)implementation.hasSpecializedTypeParameters()).isFalse();
        Assertions.assertThat((List)implementation.getInputParameterKinds()).isEqualTo((Object)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        BoundSignature boundSignature = TestAnnotationEngineForAggregates.builtinFunction(aggregation1.getFunctionMetadata().getCanonicalName(), (Type)DoubleType.DOUBLE, (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE));
        AggregationFunctionMetadata aggregationMetadata = aggregation1.getAggregationMetadata();
        Assertions.assertThat((boolean)aggregationMetadata.isOrderSensitive()).isFalse();
        Assertions.assertThat((List)aggregationMetadata.getIntermediateTypes()).isNotEmpty();
        aggregation1.specialize(boundSignature, NO_FUNCTION_DEPENDENCIES);
    }

    @Test
    public void testInjectOperatorAggregateParse() {
        Signature expectedSignature = Signature.builder().returnType((Type)DoubleType.DOUBLE).argumentType((Type)DoubleType.DOUBLE).build();
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(InjectOperatorAggregateFunction.class));
        Assertions.assertThat((String)aggregation.getFunctionMetadata().getDescription()).isEqualTo("Simple aggregate with operator injected");
        Assertions.assertThat((boolean)aggregation.getFunctionMetadata().isDeterministic()).isTrue();
        Assertions.assertThat((Object)aggregation.getFunctionMetadata().getSignature()).isEqualTo((Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        ParametricAggregationImplementation implementation = (ParametricAggregationImplementation)Iterables.getOnlyElement(implementations.getExactImplementations().values());
        Assertions.assertThat((Class)implementation.getDefinitionClass()).isEqualTo(InjectOperatorAggregateFunction.class);
        AnnotationEngineAssertions.assertDependencyCount(implementation, 1, 1, 1);
        Assertions.assertThat((Object)((ImplementationDependency)implementation.getInputDependencies().get(0))).isInstanceOf(OperatorImplementationDependency.class);
        Assertions.assertThat((Object)((ImplementationDependency)implementation.getCombineDependencies().get(0))).isInstanceOf(OperatorImplementationDependency.class);
        Assertions.assertThat((Object)((ImplementationDependency)implementation.getOutputDependencies().get(0))).isInstanceOf(OperatorImplementationDependency.class);
        Assertions.assertThat((boolean)implementation.hasSpecializedTypeParameters()).isFalse();
        Assertions.assertThat((List)implementation.getInputParameterKinds()).isEqualTo((Object)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        BoundSignature boundSignature = TestAnnotationEngineForAggregates.builtinFunction(aggregation.getFunctionMetadata().getCanonicalName(), (Type)DoubleType.DOUBLE, (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE));
        TestAnnotationEngineForAggregates.specializeAggregationFunction(boundSignature, (SqlAggregationFunction)aggregation);
    }

    @Test
    public void testInjectTypeAggregateParse() {
        Signature expectedSignature = Signature.builder().typeVariable("T").returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).build();
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(InjectTypeAggregateFunction.class));
        Assertions.assertThat((String)aggregation.getFunctionMetadata().getDescription()).isEqualTo("Simple aggregate with type injected");
        Assertions.assertThat((boolean)aggregation.getFunctionMetadata().isDeterministic()).isTrue();
        Assertions.assertThat((Object)aggregation.getFunctionMetadata().getSignature()).isEqualTo((Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        Assertions.assertThat((List)implementations.getGenericImplementations()).hasSize(1);
        ParametricAggregationImplementation implementation = (ParametricAggregationImplementation)implementations.getGenericImplementations().get(0);
        Assertions.assertThat((Class)implementation.getDefinitionClass()).isEqualTo(InjectTypeAggregateFunction.class);
        AnnotationEngineAssertions.assertDependencyCount(implementation, 1, 1, 1);
        Assertions.assertThat((Object)((ImplementationDependency)implementation.getInputDependencies().get(0))).isInstanceOf(TypeImplementationDependency.class);
        Assertions.assertThat((Object)((ImplementationDependency)implementation.getCombineDependencies().get(0))).isInstanceOf(TypeImplementationDependency.class);
        Assertions.assertThat((Object)((ImplementationDependency)implementation.getOutputDependencies().get(0))).isInstanceOf(TypeImplementationDependency.class);
        Assertions.assertThat((boolean)implementation.hasSpecializedTypeParameters()).isFalse();
        Assertions.assertThat((List)implementation.getInputParameterKinds()).isEqualTo((Object)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        BoundSignature boundSignature = TestAnnotationEngineForAggregates.builtinFunction(aggregation.getFunctionMetadata().getCanonicalName(), (Type)DoubleType.DOUBLE, (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE));
        TestAnnotationEngineForAggregates.specializeAggregationFunction(boundSignature, (SqlAggregationFunction)aggregation);
    }

    @Test
    public void testInjectLiteralAggregateParse() {
        Signature expectedSignature = Signature.builder().returnType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})).argumentType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})).build();
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(InjectLiteralAggregateFunction.class));
        Assertions.assertThat((String)aggregation.getFunctionMetadata().getDescription()).isEqualTo("Simple aggregate with type literal");
        Assertions.assertThat((boolean)aggregation.getFunctionMetadata().isDeterministic()).isTrue();
        Assertions.assertThat((Object)aggregation.getFunctionMetadata().getSignature()).isEqualTo((Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        Assertions.assertThat((List)implementations.getGenericImplementations()).hasSize(1);
        ParametricAggregationImplementation implementation = (ParametricAggregationImplementation)implementations.getGenericImplementations().get(0);
        Assertions.assertThat((Class)implementation.getDefinitionClass()).isEqualTo(InjectLiteralAggregateFunction.class);
        AnnotationEngineAssertions.assertDependencyCount(implementation, 1, 1, 1);
        Assertions.assertThat((Object)((ImplementationDependency)implementation.getInputDependencies().get(0))).isInstanceOf(LiteralImplementationDependency.class);
        Assertions.assertThat((Object)((ImplementationDependency)implementation.getCombineDependencies().get(0))).isInstanceOf(LiteralImplementationDependency.class);
        Assertions.assertThat((Object)((ImplementationDependency)implementation.getOutputDependencies().get(0))).isInstanceOf(LiteralImplementationDependency.class);
        Assertions.assertThat((boolean)implementation.hasSpecializedTypeParameters()).isFalse();
        Assertions.assertThat((List)implementation.getInputParameterKinds()).isEqualTo((Object)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        BoundSignature boundSignature = TestAnnotationEngineForAggregates.builtinFunction(aggregation.getFunctionMetadata().getCanonicalName(), (Type)VarcharType.createVarcharType((int)17), (List<Type>)ImmutableList.of((Object)VarcharType.createVarcharType((int)17)));
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata();
        Assertions.assertThat((boolean)aggregationMetadata.isOrderSensitive()).isFalse();
        Assertions.assertThat((List)aggregationMetadata.getIntermediateTypes()).isNotEmpty();
        aggregation.specialize(boundSignature, NO_FUNCTION_DEPENDENCIES);
    }

    @Test
    public void testLongConstraintAggregateFunctionParse() {
        Signature expectedSignature = Signature.builder().longVariable("z", "x + y").returnType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"z")})).argumentType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})).argumentType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"y")})).build();
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(LongConstraintAggregateFunction.class));
        Assertions.assertThat((String)aggregation.getFunctionMetadata().getDescription()).isEqualTo("Parametric aggregate with parametric type returned");
        Assertions.assertThat((boolean)aggregation.getFunctionMetadata().isDeterministic()).isTrue();
        Assertions.assertThat((Object)aggregation.getFunctionMetadata().getSignature()).isEqualTo((Object)expectedSignature);
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        Assertions.assertThat((List)implementations.getGenericImplementations()).hasSize(1);
        ParametricAggregationImplementation implementation = (ParametricAggregationImplementation)implementations.getGenericImplementations().get(0);
        Assertions.assertThat((Class)implementation.getDefinitionClass()).isEqualTo(LongConstraintAggregateFunction.class);
        AnnotationEngineAssertions.assertDependencyCount(implementation, 0, 0, 0);
        Assertions.assertThat((boolean)implementation.hasSpecializedTypeParameters()).isFalse();
        Assertions.assertThat((List)implementation.getInputParameterKinds()).isEqualTo((Object)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        BoundSignature boundSignature = TestAnnotationEngineForAggregates.builtinFunction(aggregation.getFunctionMetadata().getCanonicalName(), (Type)VarcharType.createVarcharType((int)30), (List<Type>)ImmutableList.of((Object)VarcharType.createVarcharType((int)17), (Object)VarcharType.createVarcharType((int)13)));
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata();
        Assertions.assertThat((boolean)aggregationMetadata.isOrderSensitive()).isFalse();
        Assertions.assertThat((List)aggregationMetadata.getIntermediateTypes()).isNotEmpty();
        aggregation.specialize(boundSignature, NO_FUNCTION_DEPENDENCIES);
    }

    @Test
    public void testFixedTypeParameterInjectionAggregateFunctionParse() {
        Signature expectedSignature = Signature.builder().returnType(DoubleType.DOUBLE.getTypeSignature()).argumentType(DoubleType.DOUBLE.getTypeSignature()).build();
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(FixedTypeParameterInjectionAggregateFunction.class));
        Assertions.assertThat((String)aggregation.getFunctionMetadata().getDescription()).isEqualTo("Simple aggregate with fixed parameter type injected");
        Assertions.assertThat((boolean)aggregation.getFunctionMetadata().isDeterministic()).isTrue();
        Assertions.assertThat((Object)aggregation.getFunctionMetadata().getSignature()).isEqualTo((Object)expectedSignature);
        Assertions.assertThat((List)aggregation.getStateDetails()).isEqualTo((Object)ImmutableList.of((Object)AggregationFromAnnotationsParser.toAccumulatorStateDetails(NullableDoubleState.class, (List)ImmutableList.of())));
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        AnnotationEngineAssertions.assertImplementationCount(implementations, 1, 0, 0);
        ParametricAggregationImplementation implementationDouble = (ParametricAggregationImplementation)implementations.getExactImplementations().get(expectedSignature);
        Assertions.assertThat((Class)implementationDouble.getDefinitionClass()).isEqualTo(FixedTypeParameterInjectionAggregateFunction.class);
        AnnotationEngineAssertions.assertDependencyCount(implementationDouble, 1, 1, 1);
        Assertions.assertThat((boolean)implementationDouble.hasSpecializedTypeParameters()).isFalse();
        Assertions.assertThat((List)implementationDouble.getInputParameterKinds()).isEqualTo((Object)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
    }

    @Test
    public void testPartiallyFixedTypeParameterInjectionAggregateFunctionParse() {
        Signature expectedSignature = Signature.builder().typeVariable("T1").typeVariable("T2").returnType((Type)DoubleType.DOUBLE).argumentType(new TypeSignature("T1", new TypeSignatureParameter[0])).argumentType(new TypeSignature("T2", new TypeSignatureParameter[0])).build();
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)AggregationFromAnnotationsParser.parseFunctionDefinitions(PartiallyFixedTypeParameterInjectionAggregateFunction.class));
        Assertions.assertThat((String)aggregation.getFunctionMetadata().getDescription()).isEqualTo("Simple aggregate with fixed parameter type injected");
        Assertions.assertThat((boolean)aggregation.getFunctionMetadata().isDeterministic()).isTrue();
        Assertions.assertThat((Object)aggregation.getFunctionMetadata().getSignature()).isEqualTo((Object)expectedSignature);
        Assertions.assertThat((List)aggregation.getStateDetails()).isEqualTo((Object)ImmutableList.of((Object)AggregationFromAnnotationsParser.toAccumulatorStateDetails(NullableDoubleState.class, (List)ImmutableList.of())));
        ParametricImplementationsGroup implementations = aggregation.getImplementations();
        AnnotationEngineAssertions.assertImplementationCount(implementations, 0, 0, 1);
        ParametricAggregationImplementation implementationDouble = (ParametricAggregationImplementation)Iterables.getOnlyElement((Iterable)implementations.getGenericImplementations());
        Assertions.assertThat((Class)implementationDouble.getDefinitionClass()).isEqualTo(PartiallyFixedTypeParameterInjectionAggregateFunction.class);
        AnnotationEngineAssertions.assertDependencyCount(implementationDouble, 1, 1, 1);
        Assertions.assertThat((boolean)implementationDouble.hasSpecializedTypeParameters()).isFalse();
        Assertions.assertThat((List)implementationDouble.getInputParameterKinds()).isEqualTo((Object)ImmutableList.of((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL, (Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        BoundSignature boundSignature = TestAnnotationEngineForAggregates.builtinFunction(aggregation.getFunctionMetadata().getCanonicalName(), (Type)DoubleType.DOUBLE, (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE));
        TestAnnotationEngineForAggregates.specializeAggregationFunction(boundSignature, (SqlAggregationFunction)aggregation);
    }

    @Test
    public void testAggregateFunctionGetCanonicalName() {
        List aggregationFunctions = AggregationFromAnnotationsParser.parseFunctionDefinitions(AggregationOutputFunctionWithAlias.class);
        Assertions.assertThat((List)aggregationFunctions).hasSize(1);
        ParametricAggregation aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)aggregationFunctions);
        Assertions.assertThat((String)aggregation.getFunctionMetadata().getCanonicalName()).isEqualTo("aggregation_output");
        Assertions.assertThat((Collection)aggregation.getFunctionMetadata().getNames()).containsExactlyInAnyOrder((Object[])new String[]{"aggregation_output", "aggregation_output_alias_1", "aggregation_output_alias_2"});
        aggregationFunctions = AggregationFromAnnotationsParser.parseFunctionDefinitions(AggregationFunctionWithAlias.class);
        Assertions.assertThat((List)aggregationFunctions).hasSize(1);
        aggregation = (ParametricAggregation)Iterables.getOnlyElement((Iterable)aggregationFunctions);
        Assertions.assertThat((String)aggregation.getFunctionMetadata().getCanonicalName()).isEqualTo("aggregation");
        Assertions.assertThat((Collection)aggregation.getFunctionMetadata().getNames()).containsExactlyInAnyOrder((Object[])new String[]{"aggregation", "aggregation_alias_1", "aggregation_alias_2"});
    }

    private static void specializeAggregationFunction(BoundSignature boundSignature, SqlAggregationFunction aggregation) {
        FunctionMetadata functionMetadata = aggregation.getFunctionMetadata();
        FunctionBinding functionBinding = MetadataManager.toFunctionBinding((FunctionId)functionMetadata.getFunctionId(), (BoundSignature)boundSignature, (Signature)functionMetadata.getSignature());
        AggregationFunctionMetadata aggregationMetadata = aggregation.getAggregationMetadata();
        Assertions.assertThat((boolean)aggregationMetadata.isOrderSensitive()).isFalse();
        Assertions.assertThat((List)aggregationMetadata.getIntermediateTypes()).isNotEmpty();
        FunctionDependencyDeclaration dependencyDeclaration = aggregation.getFunctionDependencies(boundSignature);
        ImmutableMap.Builder typeDependencies = ImmutableMap.builder();
        for (TypeSignature typeSignature : dependencyDeclaration.getTypeDependencies()) {
            typeSignature = SignatureBinder.applyBoundVariables((TypeSignature)typeSignature, (FunctionBinding)functionBinding);
            typeDependencies.put((Object)typeSignature, (Object)TestingPlannerContext.PLANNER_CONTEXT.getTypeManager().getType(typeSignature));
        }
        ImmutableSet.Builder functionDependencies = ImmutableSet.builder();
        dependencyDeclaration.getOperatorDependencies().stream().map(TestAnnotationEngineForAggregates::resolveDependency).forEach(arg_0 -> ((ImmutableSet.Builder)functionDependencies).add(arg_0));
        dependencyDeclaration.getFunctionDependencies().stream().map(TestAnnotationEngineForAggregates::resolveDependency).forEach(arg_0 -> ((ImmutableSet.Builder)functionDependencies).add(arg_0));
        aggregation.specialize(boundSignature, (FunctionDependencies)new InternalFunctionDependencies((arg_0, arg_1) -> ((FunctionManager)FUNCTION_MANAGER).getScalarFunctionImplementation(arg_0, arg_1), (Map)typeDependencies.buildOrThrow(), (Collection)functionDependencies.build()));
    }

    private static ResolvedFunction resolveDependency(FunctionDependencyDeclaration.OperatorDependency dependency) {
        QualifiedName name = QualifiedName.of((String)"system", (String[])new String[]{"builtin", OperatorNameUtil.mangleOperatorName((OperatorType)dependency.getOperatorType())});
        return TestingPlannerContext.PLANNER_CONTEXT.getFunctionResolver().resolveFunction(SessionTestUtils.TEST_SESSION, name, TypeSignatureProvider.fromTypeSignatures((List)dependency.getArgumentTypes()), (AccessControl)new AllowAllAccessControl());
    }

    private static ResolvedFunction resolveDependency(FunctionDependencyDeclaration.FunctionDependency dependency) {
        QualifiedName name = QualifiedName.of((String)dependency.getName().getCatalogName(), (String[])new String[]{dependency.getName().getSchemaName(), dependency.getName().getFunctionName()});
        return TestingPlannerContext.PLANNER_CONTEXT.getFunctionResolver().resolveFunction(SessionTestUtils.TEST_SESSION, name, TypeSignatureProvider.fromTypeSignatures((List)dependency.getArgumentTypes()), (AccessControl)new AllowAllAccessControl());
    }

    private static BoundSignature builtinFunction(String name, Type returnType, List<Type> argumentTypes) {
        return new BoundSignature(GlobalFunctionCatalog.builtinFunctionName((String)name), returnType, argumentTypes);
    }

    @AggregationFunction(value="simple_exact_aggregate")
    @Description(value="Simple exact aggregate description")
    public static final class ExactAggregationFunction {
        @InputFunction
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="no_aggregation_state_aggregate")
    @Description(value="Aggregate with no @AggregationState annotations")
    public static final class NotAnnotatedAggregateStateAggregationFunction {
        @InputFunction
        public static void input(NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(NullableDoubleState combine1, NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="custom_decomposable_aggregate", decomposable=false)
    @Description(value="Aggregate with Decomposable=false")
    public static final class NotDecomposableAggregationFunction {
        @InputFunction
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @OutputFunction(value="double")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="simple_generic_implementations")
    @Description(value="Simple aggregate with two generic implementations")
    public static final class GenericAggregationFunction {
        @InputFunction
        @TypeParameter(value="T")
        public static void input(@AggregationState NullableLongState state, @SqlType(value="T") double value) {
        }

        @InputFunction
        @TypeParameter(value="T")
        public static void input(@AggregationState NullableLongState state, @SqlType(value="T") long value) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableLongState state, @AggregationState NullableLongState otherState) {
        }

        @OutputFunction(value="T")
        public static void output(@AggregationState NullableLongState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="block_input_aggregate")
    @Description(value="Simple aggregate with @BlockPosition usage")
    public static final class BlockInputAggregationFunction {
        @InputFunction
        public static void input(@AggregationState NullableDoubleState state, @BlockPosition @SqlType(value="double") ValueBlock value, @BlockIndex int id) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="implicit_specialized_aggregate")
    @Description(value="Simple implicit specialized aggregate")
    public static final class ImplicitSpecializedAggregationFunction {
        @InputFunction
        @TypeParameter(value="T")
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") double additionalValue) {
        }

        @InputFunction
        @TypeParameter(value="T")
        public static void input(@AggregationState NullableLongState state, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") long additionalValue) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableLongState state, @AggregationState NullableLongState otherState) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState state, @AggregationState NullableDoubleState otherState) {
        }

        @OutputFunction(value="T")
        public static void output(@AggregationState NullableLongState state, BlockBuilder out) {
        }

        @OutputFunction(value="T")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="explicit_specialized_aggregate")
    @Description(value="Simple explicit specialized aggregate")
    public static final class ExplicitSpecializedAggregationFunction {
        @InputFunction
        @TypeParameterSpecialization(name="T", nativeContainerType=double.class)
        @TypeParameter(value="T")
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="array(T)") Block arrayBlock) {
        }

        @InputFunction
        @TypeParameter(value="T")
        public static void input(@AggregationState NullableLongState state, @SqlType(value="array(T)") Block arrayBlock) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableLongState state, @AggregationState NullableLongState otherState) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState state, @AggregationState NullableDoubleState otherState) {
        }

        @OutputFunction(value="T")
        public static void output(@AggregationState NullableLongState state, BlockBuilder out) {
        }

        @OutputFunction(value="T")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="multi_output_aggregate")
    @Description(value="Simple multi output function aggregate generic description")
    public static final class MultiOutputAggregationFunction {
        @InputFunction
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @AggregationFunction(value="multi_output_aggregate_1")
        @Description(value="Simple multi output function aggregate specialized description")
        @OutputFunction(value="double")
        public static void output1(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }

        @AggregationFunction(value="multi_output_aggregate_2")
        @OutputFunction(value="double")
        public static void output2(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="inject_operator_aggregate")
    @Description(value="Simple aggregate with operator injected")
    public static final class InjectOperatorAggregateFunction {
        @InputFunction
        public static void input(@OperatorDependency(operator=OperatorType.LESS_THAN, argumentTypes={"double", "double"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle methodHandle, @AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(@OperatorDependency(operator=OperatorType.LESS_THAN, argumentTypes={"double", "double"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle methodHandle, @AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(@OperatorDependency(operator=OperatorType.LESS_THAN, argumentTypes={"double", "double"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle methodHandle, @AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="inject_type_aggregate")
    @Description(value="Simple aggregate with type injected")
    public static final class InjectTypeAggregateFunction {
        @InputFunction
        @TypeParameter(value="T")
        public static void input(@TypeParameter(value="T") Type type, @AggregationState NullableDoubleState state, @SqlType(value="T") double value) {
        }

        @CombineFunction
        public static void combine(@TypeParameter(value="T") Type type, @AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="T")
        public static void output(@TypeParameter(value="T") Type type, @AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="inject_literal_aggregate")
    @Description(value="Simple aggregate with type literal")
    public static final class InjectLiteralAggregateFunction {
        @InputFunction
        @LiteralParameters(value={"x"})
        public static void input(@LiteralParameter(value="x") Long varcharSize, @AggregationState LongState state, @SqlType(value="varchar(x)") Slice slice) {
        }

        @CombineFunction
        public static void combine(@LiteralParameter(value="x") Long varcharSize, @AggregationState LongState combine1, @AggregationState LongState combine2) {
        }

        @OutputFunction(value="varchar(x)")
        public static void output(@LiteralParameter(value="x") Long varcharSize, @AggregationState LongState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="parametric_aggregate_long_constraint")
    @Description(value="Parametric aggregate with parametric type returned")
    public static final class LongConstraintAggregateFunction {
        @InputFunction
        @LiteralParameters(value={"x", "y", "z"})
        @Constraint(variable="z", expression="x + y")
        public static void input(@AggregationState LongState state, @SqlType(value="varchar(x)") Slice slice1, @SqlType(value="varchar(y)") Slice slice2) {
        }

        @CombineFunction
        public static void combine(@AggregationState LongState combine1, @AggregationState LongState combine2) {
        }

        @OutputFunction(value="varchar(z)")
        public static void output(@AggregationState LongState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="fixed_type_parameter_injection")
    @Description(value="Simple aggregate with fixed parameter type injected")
    public static final class FixedTypeParameterInjectionAggregateFunction {
        @InputFunction
        public static void input(@TypeParameter(value="ROW(ARRAY(BIGINT),ROW(ROW(CHAR)),BIGINT,MAP(BIGINT,CHAR))") Type type, @AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(@TypeParameter(value="ROW(ARRAY(BIGINT),ROW(ROW(CHAR)),BIGINT,MAP(BIGINT,CHAR))") Type type, @AggregationState NullableDoubleState state, @AggregationState NullableDoubleState otherState) {
        }

        @OutputFunction(value="double")
        public static void output(@TypeParameter(value="ROW(ARRAY(BIGINT),ROW(ROW(CHAR)),BIGINT,MAP(BIGINT,CHAR))") Type type, @AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="partially_fixed_type_parameter_injection")
    @Description(value="Simple aggregate with fixed parameter type injected")
    public static final class PartiallyFixedTypeParameterInjectionAggregateFunction {
        @InputFunction
        @TypeParameters(value={@TypeParameter(value="T1"), @TypeParameter(value="T2")})
        public static void input(@TypeParameter(value="ROW(ARRAY(T1),ROW(ROW(T2)),CHAR)") Type type, @AggregationState NullableDoubleState state, @SqlType(value="T1") double x, @SqlType(value="T2") double y) {
        }

        @CombineFunction
        @TypeParameters(value={@TypeParameter(value="T1"), @TypeParameter(value="T2")})
        public static void combine(@TypeParameter(value="ROW(ARRAY(T1),ROW(ROW(T2)),CHAR)") Type type, @AggregationState NullableDoubleState state, @AggregationState NullableDoubleState otherState) {
        }

        @OutputFunction(value="double")
        @TypeParameters(value={@TypeParameter(value="T1"), @TypeParameter(value="T2")})
        public static void output(@TypeParameter(value="ROW(ARRAY(T1),ROW(ROW(T2)),CHAR)") Type type, @AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }

    @AggregationFunction
    @Description(value="Aggregation output function with alias")
    public static final class AggregationOutputFunctionWithAlias {
        @InputFunction
        public static void input(@AggregationState VarianceState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(@AggregationState VarianceState state, @AggregationState VarianceState otherState) {
        }

        @AggregationFunction(value="aggregation_output", alias={"aggregation_output_alias_1", "aggregation_output_alias_2"})
        @OutputFunction(value="double")
        public static void output(@AggregationState VarianceState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="aggregation", alias={"aggregation_alias_1", "aggregation_alias_2"})
    @Description(value="Aggregation function with alias")
    public static final class AggregationFunctionWithAlias {
        @InputFunction
        public static void input(@AggregationState TriStateBooleanState state, @SqlType(value="boolean") boolean value) {
        }

        @CombineFunction
        public static void combine(@AggregationState TriStateBooleanState state, @AggregationState TriStateBooleanState otherState) {
        }

        @OutputFunction(value="boolean")
        public static void output(@AggregationState TriStateBooleanState state, BlockBuilder out) {
        }
    }

    @AggregationFunction(value="output_parameters_wrong_order")
    @Description(value="AggregationState must be the first output parameter")
    public static final class OutputParametersWrongOrder {
        @InputFunction
        public static void input(@AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(BlockBuilder out, @AggregationState NullableDoubleState state) {
        }
    }

    @AggregationFunction(value="input_parameters_wrong_order")
    @Description(value="AggregationState must be the first input parameter")
    public static final class InputParametersWrongOrder {
        @InputFunction
        public static void input(@SqlType(value="double") double value, @AggregationState NullableDoubleState state) {
        }

        @CombineFunction
        public static void combine(@AggregationState NullableDoubleState combine1, @AggregationState NullableDoubleState combine2) {
        }

        @OutputFunction(value="double")
        public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        }
    }
}

