/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.operator.DriverStats;
import io.trino.operator.OperatorStats;
import io.trino.operator.TestOperatorStats;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.jupiter.api.Test;

public class TestDriverStats {
    public static final DriverStats EXPECTED = new DriverStats(new DateTime(1L), new DateTime(2L), new DateTime(3L), new Duration(4.0, TimeUnit.NANOSECONDS), new Duration(5.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)6L), DataSize.ofBytes((long)7L), new Duration(9.0, TimeUnit.NANOSECONDS), new Duration(10.0, TimeUnit.NANOSECONDS), new Duration(12.0, TimeUnit.NANOSECONDS), false, (Set)ImmutableSet.of(), DataSize.ofBytes((long)131L), 141L, new Duration(151.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)132L), 142L, DataSize.ofBytes((long)13L), 14L, new Duration(15.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)16L), 17L, new Duration(101.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)18L), 19L, new Duration(102.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)20L), (List)ImmutableList.of((Object)TestOperatorStats.EXPECTED));

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(DriverStats.class);
        String json = codec.toJson((Object)EXPECTED);
        DriverStats actual = (DriverStats)codec.fromJson(json);
        TestDriverStats.assertExpectedDriverStats(actual);
    }

    public static void assertExpectedDriverStats(DriverStats actual) {
        Assertions.assertThat((Comparable)actual.getCreateTime()).isEqualTo((Object)new DateTime(1L, DateTimeZone.UTC));
        Assertions.assertThat((Comparable)actual.getStartTime()).isEqualTo((Object)new DateTime(2L, DateTimeZone.UTC));
        Assertions.assertThat((Comparable)actual.getEndTime()).isEqualTo((Object)new DateTime(3L, DateTimeZone.UTC));
        Assertions.assertThat((Comparable)actual.getQueuedTime()).isEqualTo((Object)new Duration(4.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getElapsedTime()).isEqualTo((Object)new Duration(5.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getUserMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)6L));
        Assertions.assertThat((Comparable)actual.getRevocableMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)7L));
        Assertions.assertThat((Comparable)actual.getTotalScheduledTime()).isEqualTo((Object)new Duration(9.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getTotalCpuTime()).isEqualTo((Object)new Duration(10.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getTotalBlockedTime()).isEqualTo((Object)new Duration(12.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getPhysicalInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)131L));
        Assertions.assertThat((long)actual.getPhysicalInputPositions()).isEqualTo(141L);
        Assertions.assertThat((Comparable)actual.getPhysicalInputReadTime()).isEqualTo((Object)new Duration(151.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getInternalNetworkInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)132L));
        Assertions.assertThat((long)actual.getInternalNetworkInputPositions()).isEqualTo(142L);
        Assertions.assertThat((Comparable)actual.getRawInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)13L));
        Assertions.assertThat((long)actual.getRawInputPositions()).isEqualTo(14L);
        Assertions.assertThat((Comparable)actual.getRawInputReadTime()).isEqualTo((Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getProcessedInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)16L));
        Assertions.assertThat((long)actual.getProcessedInputPositions()).isEqualTo(17L);
        Assertions.assertThat((Comparable)actual.getInputBlockedTime()).isEqualTo((Object)new Duration(101.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getOutputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)18L));
        Assertions.assertThat((long)actual.getOutputPositions()).isEqualTo(19L);
        Assertions.assertThat((Comparable)actual.getOutputBlockedTime()).isEqualTo((Object)new Duration(102.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getPhysicalWrittenDataSize()).isEqualTo((Object)DataSize.ofBytes((long)20L));
        Assertions.assertThat((List)actual.getOperatorStats()).hasSize(1);
        TestOperatorStats.assertExpectedOperatorStats((OperatorStats)actual.getOperatorStats().get(0));
    }
}

