/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.operator.OperatorSpoolingController;
import io.trino.operator.PipelineSpoolingController;
import io.trino.operator.SpoolingController;
import java.util.concurrent.atomic.AtomicLong;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestSpoolingController {
    TestSpoolingController() {
    }

    @Test
    public void testInlineFirstRowsUntilThresholdThenSpooling() {
        SpoolingControllerAssertions assertion = new SpoolingControllerAssertions((SpoolingController)new PipelineSpoolingController(new AtomicLong(), new AtomicLong(), true, 100L, 1000L, (SpoolingController)new OperatorSpoolingController(900L, 16000L)));
        assertion.verifyNextMode(10, 100, SpoolingController.Mode.INLINE).verifyInlined(1, 10, 100).verifyNextMode(10, 100, SpoolingController.Mode.INLINE).verifyInlined(2, 20, 200).verifyNextMode(50, 400, SpoolingController.Mode.INLINE).verifyInlined(3, 70, 600).verifyNextMode(50, 400, SpoolingController.Mode.BUFFER).verifyBuffered(50, 400).verifyNextMode(50, 400, SpoolingController.Mode.BUFFER).verifyBuffered(100, 800).verifyNextMode(50, 400, SpoolingController.Mode.SPOOL).verifySpooled(1, 150, 1200).verifyEmptyBuffer().verifyNextMode(39, 399, SpoolingController.Mode.BUFFER).verifyBuffered(39, 399);
    }

    @Test
    public void testSpoolingTargetSize() {
        SpoolingControllerAssertions assertion = new SpoolingControllerAssertions((SpoolingController)new PipelineSpoolingController(new AtomicLong(), new AtomicLong(), false, 0L, 0L, (SpoolingController)new OperatorSpoolingController(512L, 2048L)));
        assertion.verifyNextMode(100, 511, SpoolingController.Mode.BUFFER).verifySpooledSegmentTarget(512L).verifyBuffered(100, 511).verifyNextMode(100, 1, SpoolingController.Mode.SPOOL).verifySpooled(1, 200, 512).verifySpooledSegmentTarget(1024L).verifyEmptyBuffer().verifyNextMode(1, 333, SpoolingController.Mode.BUFFER).verifyNextMode(1, 333, SpoolingController.Mode.BUFFER).verifyNextMode(1, 333, SpoolingController.Mode.BUFFER).verifyNextMode(1, 333, SpoolingController.Mode.SPOOL).verifySpooled(2, 204, 1844).verifyEmptyBuffer().verifySpooledSegmentTarget(2048L).verifyNextMode(100, 2047, SpoolingController.Mode.BUFFER).verifyNextMode(100, 2047, SpoolingController.Mode.SPOOL).verifyEmptyBuffer().verifySpooledSegmentTarget(2048L).verifySpooled(3, 404, 5938);
    }

    @Test
    public void testSpoolingEncoderEfficiency() {
        SpoolingControllerAssertions assertion = new SpoolingControllerAssertions((SpoolingController)new PipelineSpoolingController(new AtomicLong(), new AtomicLong(), false, 0L, 0L, (SpoolingController)new OperatorSpoolingController(32L, 1000L)));
        assertion.verifyNextMode(1000, 31, SpoolingController.Mode.BUFFER).verifyBuffered(1000, 31).verifyNextMode(1000, 31, SpoolingController.Mode.SPOOL).verifySpooled(1, 2000, 62).verifySpooledSegmentTarget(64L).verifyEmptyBuffer().verifyNextMode(100, 80, SpoolingController.Mode.SPOOL).verifySpooled(2, 2100, 142).verifySpooledSegmentTarget(128L).verifyEmptyBuffer().verifyNextMode(100, 47, SpoolingController.Mode.BUFFER).verifyBuffered(100, 47).verifyNextMode(54, 1, SpoolingController.Mode.BUFFER).verifyNextMode(100, 80, SpoolingController.Mode.SPOOL).verifySpooledSegmentTarget(256L).verifyEmptyBuffer().verifyNextMode(100, 43, SpoolingController.Mode.BUFFER).verifyNextMode(1, 1, SpoolingController.Mode.BUFFER).verifyNextMode(100, 1, SpoolingController.Mode.BUFFER).verifyNextMode(100, 211, SpoolingController.Mode.SPOOL).verifyEmptyBuffer().verifySpooled(4, 2655, 526).verifySpooledSegmentTarget(512L);
    }

    private record SpoolingControllerAssertions(SpoolingController controller) {
        public SpoolingControllerAssertions verifyNextMode(int positionCount, int rawSizeInBytes, SpoolingController.Mode expected) {
            Assertions.assertThat((Comparable)this.controller.nextMode(positionCount, (long)rawSizeInBytes)).isEqualTo((Object)expected);
            return this;
        }

        private SpoolingControllerAssertions verifyInlined(int inlinedPages, int inlinedPositions, int inlinedRawBytes) {
            SpoolingController.MetricSnapshot inlined = this.controller.getMetrics(SpoolingController.Mode.INLINE);
            ((AbstractLongAssert)Assertions.assertThat((long)inlined.pages()).describedAs("Inlined pages", new Object[0])).isEqualTo((long)inlinedPages);
            ((AbstractLongAssert)Assertions.assertThat((long)inlined.positions()).describedAs("Inlined positions", new Object[0])).isEqualTo((long)inlinedPositions);
            ((AbstractLongAssert)Assertions.assertThat((long)inlined.size()).describedAs("Inlined raw bytes", new Object[0])).isEqualTo((long)inlinedRawBytes);
            return this;
        }

        private SpoolingControllerAssertions verifySpooled(int spooledPages, int spooledPositions, int spooledRawBytes) {
            SpoolingController.MetricSnapshot spooled = this.controller.getMetrics(SpoolingController.Mode.SPOOL);
            ((AbstractLongAssert)Assertions.assertThat((long)spooled.pages()).describedAs("Spooled pages", new Object[0])).isEqualTo((long)spooledPages);
            ((AbstractLongAssert)Assertions.assertThat((long)spooled.positions()).describedAs("Spooled spooledPositions", new Object[0])).isEqualTo((long)spooledPositions);
            ((AbstractLongAssert)Assertions.assertThat((long)spooled.size()).describedAs("Spooled raw bytes", new Object[0])).isEqualTo((long)spooledRawBytes);
            return this;
        }

        private SpoolingControllerAssertions verifyBuffered(int bufferedPositions, int bufferSize) {
            SpoolingController.MetricSnapshot buffered = this.controller.getMetrics(SpoolingController.Mode.BUFFER);
            ((AbstractLongAssert)Assertions.assertThat((long)buffered.positions()).describedAs("Buffered positions", new Object[0])).isEqualTo((long)bufferedPositions);
            ((AbstractLongAssert)Assertions.assertThat((long)buffered.size()).describedAs("Buffered size", new Object[0])).isEqualTo((long)bufferSize);
            return this;
        }

        private SpoolingControllerAssertions verifySpooledSegmentTarget(long size) {
            ((AbstractLongAssert)Assertions.assertThat((long)((OperatorSpoolingController)this.controller.unwrap(OperatorSpoolingController.class)).getCurrentSpooledSegmentTarget()).describedAs("Spooled segment target", new Object[0])).isEqualTo(size);
            return this;
        }

        private SpoolingControllerAssertions verifyEmptyBuffer() {
            return this.verifyBuffered(0, 0);
        }
    }
}

