/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.SourcePage;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.ObjLongConsumer;

public class TestingSourcePage
implements SourcePage {
    private static final long INSTANCE_SIZE = SizeOf.instanceSize(TestingSourcePage.class);
    private final int positionCount;
    private final Block[] blocks;
    private final boolean[] loaded;

    public TestingSourcePage(int positionCount, Block ... blocks) {
        this.positionCount = positionCount;
        this.blocks = Objects.requireNonNull(blocks, "blocks is null");
        this.loaded = new boolean[blocks.length];
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public long getSizeInBytes() {
        long sizeInBytes = 0L;
        for (int i = 0; i < this.blocks.length; ++i) {
            Block block = this.blocks[i];
            if (!this.loaded[i] || block == null) continue;
            sizeInBytes += block.getSizeInBytes();
        }
        return sizeInBytes;
    }

    public long getRetainedSizeInBytes() {
        long retainedSizeInBytes = INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.blocks) + SizeOf.sizeOf((boolean[])this.loaded);
        for (Block block : this.blocks) {
            if (block == null) continue;
            retainedSizeInBytes += block.getRetainedSizeInBytes();
        }
        return retainedSizeInBytes;
    }

    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this, INSTANCE_SIZE);
        consumer.accept(this.blocks, SizeOf.sizeOf((Object[])this.blocks));
        consumer.accept(this.loaded, SizeOf.sizeOf((boolean[])this.loaded));
        for (Block block : this.blocks) {
            if (block == null) continue;
            block.retainedBytesForEachPart(consumer);
        }
    }

    public int getChannelCount() {
        return this.blocks.length;
    }

    public boolean wasLoaded(int channel) {
        return this.loaded[channel];
    }

    public Block getBlock(int channel) {
        Block block = this.blocks[channel];
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (String)"Block %s should not be accessed", (int)channel);
        this.loaded[channel] = true;
        return block;
    }

    public Page getPage() {
        for (Block block : this.blocks) {
            Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"Page cannot be created because block is null");
        }
        Arrays.fill(this.loaded, true);
        Block[] blocks = (Block[])this.blocks.clone();
        return new Page(this.positionCount, blocks);
    }

    public void selectPositions(int[] positions, int offset, int size) {
        for (int i = 0; i < this.blocks.length; ++i) {
            Block block = this.blocks[i];
            if (block == null) continue;
            this.blocks[i] = block.getPositions(positions, offset, size);
        }
    }
}

