/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.operator.aggregation.AbstractTestAggregationFunction;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import java.util.List;

public class TestRealGeometricMeanAggregation
extends AbstractTestAggregationFunction {
    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = RealType.REAL.createFixedSizeBlockBuilder(length);
        for (int i = start; i < start + length; ++i) {
            RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(i));
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    protected Number getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        double product = 1.0;
        for (int i = start; i < start + length; ++i) {
            product *= (double)i;
        }
        return Float.valueOf((float)Math.pow(product, 1.0 / (double)length));
    }

    @Override
    protected String getFunctionName() {
        return "geometric_mean";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)RealType.REAL);
    }
}

