/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import io.airlift.slice.Slices;
import io.trino.block.BlockAssertions;
import io.trino.operator.output.PositionsAppenderFactory;
import io.trino.operator.output.PositionsAppenderPageBuilder;
import io.trino.operator.output.PositionsAppenderSizeAccumulator;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;

public class TestPositionsAppenderPageBuilder {
    @Test
    public void testFullOnPositionCountLimit() {
        int maxPageBytes = 0x100000;
        int maxDirectSize = maxPageBytes * 10;
        PositionsAppenderPageBuilder pageBuilder = PositionsAppenderPageBuilder.withMaxPageSize((int)maxPageBytes, (int)maxDirectSize, List.of(VarcharType.VARCHAR), (PositionsAppenderFactory)new PositionsAppenderFactory(new BlockTypeOperators()));
        RunLengthEncodedBlock rleBlock = (RunLengthEncodedBlock)RunLengthEncodedBlock.create((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test"), (int)10);
        Page inputPage = new Page(new Block[]{rleBlock});
        IntArrayList positions = IntArrayList.wrap((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
        ((AbstractIntegerAssert)Assertions.assertThat((int)32768).as("expected MAX_POSITION_COUNT to be 32768", new Object[0])).isEqualTo(32768);
        for (int i = 0; i < 3276; ++i) {
            pageBuilder.appendToOutputPartition(inputPage, positions);
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)pageBuilder.isFull()).as("pageBuilder should still not be full", new Object[0])).isFalse();
        pageBuilder.appendToOutputPartition(inputPage, positions);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)pageBuilder.isFull()).as("pageBuilder should be full", new Object[0])).isTrue();
        PositionsAppenderSizeAccumulator sizeAccumulator = pageBuilder.computeAppenderSizes();
        Assertions.assertThat((long)sizeAccumulator.getSizeInBytes()).isEqualTo(rleBlock.getValue().getSizeInBytes());
        ((AbstractBooleanAssert)Assertions.assertThat((sizeAccumulator.getDirectSizeInBytes() < (long)maxDirectSize ? 1 : 0) != 0).as("direct size should still be below threshold", new Object[0])).isTrue();
        ((AbstractLongAssert)Assertions.assertThat((long)pageBuilder.getSizeInBytes()).as("pageBuilder sizeInBytes must match sizeAccumulator value", new Object[0])).isEqualTo(sizeAccumulator.getSizeInBytes());
    }

    @Test
    public void testFullOnDirectSizeInBytes() {
        int maxPageBytes = 100;
        int maxDirectSize = 1000;
        PositionsAppenderPageBuilder pageBuilder = PositionsAppenderPageBuilder.withMaxPageSize((int)maxPageBytes, (int)maxDirectSize, List.of(VarcharType.VARCHAR), (PositionsAppenderFactory)new PositionsAppenderFactory(new BlockTypeOperators()));
        PositionsAppenderSizeAccumulator sizeAccumulator = pageBuilder.computeAppenderSizes();
        Assertions.assertThat((long)sizeAccumulator.getSizeInBytes()).isEqualTo(0L);
        Assertions.assertThat((long)sizeAccumulator.getDirectSizeInBytes()).isEqualTo(0L);
        Assertions.assertThat((boolean)pageBuilder.isFull()).isFalse();
        RunLengthEncodedBlock rleBlock = (RunLengthEncodedBlock)RunLengthEncodedBlock.create((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test"), (int)10);
        Page inputPage = new Page(new Block[]{rleBlock});
        IntArrayList positions = IntArrayList.wrap((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
        pageBuilder.appendToOutputPartition(inputPage, positions);
        sizeAccumulator = pageBuilder.computeAppenderSizes();
        Assertions.assertThat((long)sizeAccumulator.getSizeInBytes()).isEqualTo(rleBlock.getValue().getSizeInBytes());
        ((AbstractLongAssert)Assertions.assertThat((long)pageBuilder.getSizeInBytes()).as("pageBuilder sizeInBytes must match sizeAccumulator value", new Object[0])).isEqualTo(sizeAccumulator.getSizeInBytes());
        Assertions.assertThat((long)sizeAccumulator.getDirectSizeInBytes()).isEqualTo(rleBlock.getValue().getSizeInBytes() * 10L);
        Assertions.assertThat((boolean)pageBuilder.isFull()).isFalse();
        while (pageBuilder.computeAppenderSizes().getDirectSizeInBytes() < (long)maxDirectSize) {
            pageBuilder.appendToOutputPartition(inputPage, positions);
        }
        sizeAccumulator = pageBuilder.computeAppenderSizes();
        ((AbstractLongAssert)Assertions.assertThat((long)sizeAccumulator.getSizeInBytes()).as("sizeInBytes must still report the RLE block size only", new Object[0])).isEqualTo(rleBlock.getValue().getSizeInBytes());
        ((AbstractLongAssert)Assertions.assertThat((long)pageBuilder.getSizeInBytes()).as("pageBuilder sizeInBytes must match sizeAccumulator value", new Object[0])).isEqualTo(sizeAccumulator.getSizeInBytes());
        Assertions.assertThat((boolean)pageBuilder.isFull()).isTrue();
        Page result = pageBuilder.build();
        ((AbstractIntegerAssert)Assertions.assertThat((int)result.getPositionCount()).as("result positions should be below the 8192 maximum", new Object[0])).isEqualTo(120);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(result.getBlock(0) instanceof RunLengthEncodedBlock)).as("result block is RLE encoded", new Object[0])).isTrue();
    }

    @Test
    public void testFlushUsefulDictionariesOnRelease() {
        int maxPageBytes = 100;
        int maxDirectSize = 1000;
        PositionsAppenderPageBuilder pageBuilder = PositionsAppenderPageBuilder.withMaxPageSize((int)maxPageBytes, (int)maxDirectSize, List.of(VarcharType.VARCHAR), (PositionsAppenderFactory)new PositionsAppenderFactory(new BlockTypeOperators()));
        Block valueBlock = Utils.nativeValueToBlock((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test"));
        Block dictionaryBlock = DictionaryBlock.create((int)10, (Block)valueBlock, (int[])new int[10]);
        Page inputPage = new Page(new Block[]{dictionaryBlock});
        pageBuilder.appendToOutputPartition(inputPage, IntArrayList.wrap((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        Assertions.assertThat((long)pageBuilder.getSizeInBytes()).isEqualTo(40L);
        Assertions.assertThat((boolean)pageBuilder.isFull()).isFalse();
        Optional flushedPage = pageBuilder.flushOrFlattenBeforeRelease();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)flushedPage.isPresent()).as("pageBuilder should force flush the dictionary", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(((Page)flushedPage.get()).getBlock(0) instanceof DictionaryBlock)).as("result should be dictionary encoded", new Object[0])).isTrue();
    }

    @Test
    public void testFlattenUnhelpfulDictionariesOnRelease() {
        ValueBlock valueBlock = BlockAssertions.createRandomBlockForType((Type)VarcharType.VARCHAR, 10, 0.25f);
        Block dictionaryBlock = DictionaryBlock.create((int)10, (Block)valueBlock, (int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
        Page inputPage = new Page(new Block[]{dictionaryBlock});
        int maxPageBytes = Math.toIntExact(valueBlock.getSizeInBytes() * 10L);
        int maxDirectSize = maxPageBytes * 10;
        PositionsAppenderPageBuilder pageBuilder = PositionsAppenderPageBuilder.withMaxPageSize((int)maxPageBytes, (int)maxDirectSize, List.of(VarcharType.VARCHAR), (PositionsAppenderFactory)new PositionsAppenderFactory(new BlockTypeOperators()));
        pageBuilder.appendToOutputPartition(inputPage, IntArrayList.wrap((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        Assertions.assertThat((long)pageBuilder.getSizeInBytes()).isEqualTo(40L);
        Assertions.assertThat((boolean)pageBuilder.isFull()).isFalse();
        ((OptionalAssert)Assertions.assertThat((Optional)pageBuilder.flushOrFlattenBeforeRelease()).as("pageBuilder should not force a flush", new Object[0])).isEqualTo(Optional.empty());
        Assertions.assertThat((boolean)pageBuilder.isFull()).isFalse();
        ((AbstractLongAssert)Assertions.assertThat((long)pageBuilder.getSizeInBytes()).as("pageBuilder should have transitioned to direct mode", new Object[0])).isEqualTo(valueBlock.getSizeInBytes());
        Page result = pageBuilder.build();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(result.getBlock(0) instanceof ValueBlock)).as("result should not be a dictionary block", new Object[0])).isTrue();
    }
}

