/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.trino.jmh.Benchmarks;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.project.PageProcessor;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.Expressions;
import io.trino.testing.TestingConnectorSession;
import io.trino.type.JsonType;
import io.trino.util.StructuralTestUtil;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.runner.options.WarmupMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=10)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkJsonToMapCast {
    private static final int POSITION_COUNT = 100000;
    private static final int MAP_SIZE = 10;

    @Benchmark
    @OperationsPerInvocation(value=100000)
    public List<Optional<Page>> benchmark(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), SourcePage.create((Page)data.getPage())));
    }

    @Test
    public void verify() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkJsonToMapCast().benchmark(data);
    }

    public static void main(String[] args) throws Exception {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkJsonToMapCast().benchmark(data);
        Benchmarks.benchmark(BenchmarkJsonToMapCast.class, (WarmupMode)WarmupMode.BULK_INDI).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"BIGINT", "DOUBLE", "VARCHAR"})
        private String valueTypeName = "BIGINT";
        private Page page;
        private PageProcessor pageProcessor;

        @Setup
        public void setup() {
            BigintType valueType = switch (this.valueTypeName) {
                case "BIGINT" -> BigintType.BIGINT;
                case "DOUBLE" -> DoubleType.DOUBLE;
                case "VARCHAR" -> VarcharType.VARCHAR;
                default -> throw new UnsupportedOperationException();
            };
            TestingFunctionResolution functionResolution = new TestingFunctionResolution();
            MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)valueType);
            ImmutableList projections = ImmutableList.of((Object)new CallExpression(functionResolution.getCoercion((Type)JsonType.JSON, (Type)mapType), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)JsonType.JSON))));
            this.pageProcessor = (PageProcessor)functionResolution.getExpressionCompiler().compilePageProcessor(Optional.empty(), (List)projections).get();
            this.page = new Page(new Block[]{BenchmarkData.createChannel(100000, 10, (Type)valueType)});
        }

        private static Block createChannel(int positionCount, int mapSize, Type valueType) {
            VariableWidthBlockBuilder blockBuilder = JsonType.JSON.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                DynamicSliceOutput jsonSlice = new DynamicSliceOutput(20 * mapSize);
                jsonSlice.appendByte(123);
                for (int i = 0; i < mapSize; ++i) {
                    if (i != 0) {
                        jsonSlice.appendByte(44);
                    }
                    String key = "key" + i;
                    String value = BenchmarkData.generateRandomJsonValue(valueType);
                    jsonSlice.appendByte(34);
                    jsonSlice.appendBytes(key.getBytes(StandardCharsets.UTF_8));
                    jsonSlice.appendBytes("\":".getBytes(StandardCharsets.UTF_8));
                    jsonSlice.appendBytes(value.getBytes(StandardCharsets.UTF_8));
                }
                jsonSlice.appendByte(125);
                JsonType.JSON.writeSlice((BlockBuilder)blockBuilder, jsonSlice.slice());
            }
            return blockBuilder.build();
        }

        private static String generateRandomJsonValue(Type valueType) {
            if (valueType == BigintType.BIGINT) {
                return Long.toString(ThreadLocalRandom.current().nextLong());
            }
            if (valueType == DoubleType.DOUBLE) {
                return Double.toString(ThreadLocalRandom.current().nextDouble());
            }
            if (valueType == VarcharType.VARCHAR) {
                String characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
                int length = ThreadLocalRandom.current().nextInt(10) + 1;
                StringBuilder builder = new StringBuilder(length + 2);
                builder.append('\"');
                for (int i = 0; i < length; ++i) {
                    builder.append(characters.charAt(ThreadLocalRandom.current().nextInt(characters.length())));
                }
                builder.append('\"');
                return builder.toString();
            }
            throw new UnsupportedOperationException();
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getPage() {
            return this.page;
        }
    }
}

