/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.block.BlockAssertions;
import io.trino.jmh.Benchmarks;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.project.PageProcessor;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.Expressions;
import io.trino.testing.TestingConnectorSession;
import io.trino.util.StructuralTestUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.options.WarmupMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkMapSubscript {
    private static final int POSITIONS = 1024;

    @Benchmark
    @OperationsPerInvocation(value=1024)
    public List<Optional<Page>> mapSubscript(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), SourcePage.create((Page)data.getPage())));
    }

    public static void main(String[] args) throws Exception {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkMapSubscript().mapSubscript(data);
        Benchmarks.benchmark(BenchmarkMapSubscript.class, (WarmupMode)WarmupMode.INDI).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"fix-width", "var-width", "dictionary"})
        private String name = "dictionary";
        @Param(value={"1", "13"})
        private int mapSize = 13;
        private Page page;
        private PageProcessor pageProcessor;

        @Setup
        public void setup() {
            MapType mapType;
            TestingFunctionResolution functionResolution = new TestingFunctionResolution();
            ExpressionCompiler compiler = functionResolution.getExpressionCompiler();
            ImmutableList keys = switch (this.mapSize) {
                case 1 -> ImmutableList.of((Object)"do_not_use");
                case 13 -> ImmutableList.of((Object)"is_inverted", (Object)"device_model", (Object)"country", (Object)"carrier_id", (Object)"network_type", (Object)"os_version", (Object)"device_brand", (Object)"device_type", (Object)"interface", (Object)"device_os", (Object)"app_version", (Object)"device_type_class", (Object[])new String[]{"browser"});
                default -> throw new UnsupportedOperationException();
            };
            Verify.verify((keys.size() == this.mapSize ? 1 : 0) != 0);
            Block valueBlock = switch (this.name) {
                case "fix-width" -> {
                    mapType = StructuralTestUtil.mapType((Type)VarcharType.createUnboundedVarcharType(), (Type)DoubleType.DOUBLE);
                    yield BenchmarkData.createFixWidthValueBlock(1024, this.mapSize);
                }
                case "var-width" -> {
                    mapType = StructuralTestUtil.mapType((Type)VarcharType.createUnboundedVarcharType(), (Type)VarcharType.createUnboundedVarcharType());
                    yield BenchmarkData.createVarWidthValueBlock(1024, this.mapSize);
                }
                case "dictionary" -> {
                    mapType = StructuralTestUtil.mapType((Type)VarcharType.createUnboundedVarcharType(), (Type)VarcharType.createUnboundedVarcharType());
                    yield BenchmarkData.createDictionaryValueBlock(1024, this.mapSize);
                }
                default -> throw new UnsupportedOperationException();
            };
            Block keyBlock = BenchmarkData.createKeyBlock(1024, (List<String>)keys);
            Block block = BenchmarkData.createMapBlock(mapType, 1024, keyBlock, valueBlock);
            ImmutableList.Builder projectionsBuilder = ImmutableList.builder();
            ResolvedFunction resolvedFunction = functionResolution.resolveOperator(OperatorType.SUBSCRIPT, (List<? extends Type>)ImmutableList.of((Object)mapType, (Object)mapType.getKeyType()));
            for (int i = 0; i < this.mapSize; ++i) {
                projectionsBuilder.add((Object)new CallExpression(resolvedFunction, (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)mapType), (Object)Expressions.constant((Object)Slices.utf8Slice((String)((String)keys.get(i))), (Type)VarcharType.createUnboundedVarcharType()))));
            }
            ImmutableList projections = projectionsBuilder.build();
            this.pageProcessor = (PageProcessor)compiler.compilePageProcessor(Optional.empty(), (List)projections).get();
            this.page = new Page(new Block[]{block});
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getPage() {
            return this.page;
        }

        private static Block createMapBlock(MapType mapType, int positionCount, Block keyBlock, Block valueBlock) {
            int[] offsets = new int[positionCount + 1];
            int mapSize = keyBlock.getPositionCount() / positionCount;
            for (int i = 0; i < offsets.length; ++i) {
                offsets[i] = mapSize * i;
            }
            return mapType.createBlockFromKeyValue(Optional.empty(), offsets, keyBlock, valueBlock);
        }

        private static Block createKeyBlock(int positionCount, List<String> keys) {
            Block keyDictionaryBlock = BenchmarkData.createSliceArrayBlock(keys);
            int[] keyIds = new int[positionCount * keys.size()];
            for (int i = 0; i < keyIds.length; ++i) {
                keyIds[i] = i % keys.size();
            }
            return DictionaryBlock.create((int)keyIds.length, (Block)keyDictionaryBlock, (int[])keyIds);
        }

        private static Block createFixWidthValueBlock(int positionCount, int mapSize) {
            BlockBuilder valueBlockBuilder = DoubleType.DOUBLE.createFixedSizeBlockBuilder(positionCount * mapSize);
            for (int i = 0; i < positionCount * mapSize; ++i) {
                DoubleType.DOUBLE.writeDouble(valueBlockBuilder, ThreadLocalRandom.current().nextDouble());
            }
            return valueBlockBuilder.build();
        }

        private static Block createVarWidthValueBlock(int positionCount, int mapSize) {
            VarcharType valueType = VarcharType.createUnboundedVarcharType();
            BlockBuilder valueBlockBuilder = valueType.createBlockBuilder(null, positionCount * mapSize);
            for (int i = 0; i < positionCount * mapSize; ++i) {
                int wordLength = ThreadLocalRandom.current().nextInt(5, 10);
                valueType.writeSlice(valueBlockBuilder, Slices.utf8Slice((String)BenchmarkData.randomString(wordLength)));
            }
            return valueBlockBuilder.build();
        }

        private static Block createDictionaryValueBlock(int positionCount, int mapSize) {
            double distinctRatio = 0.82;
            int dictionarySize = (int)((double)(positionCount * mapSize) * distinctRatio);
            ArrayList<String> dictionaryStrings = new ArrayList<String>(dictionarySize);
            for (int i = 0; i < dictionarySize; ++i) {
                int wordLength = ThreadLocalRandom.current().nextInt(5, 10);
                dictionaryStrings.add(BenchmarkData.randomString(wordLength));
            }
            Block dictionaryBlock = BenchmarkData.createSliceArrayBlock(dictionaryStrings);
            int[] keyIds = new int[positionCount * mapSize];
            for (int i = 0; i < keyIds.length; ++i) {
                keyIds[i] = ThreadLocalRandom.current().nextInt(0, dictionarySize);
            }
            return DictionaryBlock.create((int)keyIds.length, (Block)dictionaryBlock, (int[])keyIds);
        }

        private static String randomString(int length) {
            String symbols = "abcdefghijklmnopqrstuvwxyz";
            char[] chars = new char[length];
            for (int i = 0; i < length; ++i) {
                chars[i] = symbols.charAt(ThreadLocalRandom.current().nextInt(symbols.length()));
            }
            return new String(chars);
        }

        private static Block createSliceArrayBlock(List<String> keys) {
            Slice[] sliceArray = new Slice[keys.size() + 1];
            for (int i = 0; i < keys.size(); ++i) {
                sliceArray[i] = Slices.utf8Slice((String)keys.get(i));
            }
            return BlockAssertions.createSlicesBlock(sliceArray);
        }
    }
}

