/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.Arrays;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
class TestJsonStringArrayExtractScalar {
    private final QueryAssertions assertions = new QueryAssertions();

    TestJsonStringArrayExtractScalar() {
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    void testEmptyString() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.extract("", "$").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT}).hasMessageContaining("Cannot cast to array");
    }

    @Test
    void testObject() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.extract("{}", "$").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT}).hasMessageContaining("Cannot cast to array");
    }

    @Test
    void testScalar() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.extract("1", "$").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT}).hasMessageContaining("Cannot cast to array");
    }

    @Test
    void testEmptyArray() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.extract("[]", "$.name")))).isEqualTo(ImmutableList.of());
    }

    @Test
    void testScalarArrayExtract() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.extract("[1, \"abc\", 2.2]", "$.name")))).isEqualTo(Arrays.asList(null, null, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.extract("[1, \"abc\", 2.2]", "$")))).isEqualTo(Arrays.asList("1", "abc", "2.2"));
    }

    @Test
    void testEmptyElementsArrayExtract() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.extract("[null, [], {}]", "$.name")))).isEqualTo(Arrays.asList(null, null, null));
    }

    @Test
    void testExtract() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.extract("[{\"name\": \"a\"}, {\"name\": \"b\"}, [], {}]", "$.name")))).isEqualTo(Arrays.asList("a", "b", null, null));
    }

    @Test
    void testMixedExtract() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.extract("[{\"name\": \"a\"}, 1]", "$.name")))).isEqualTo(Arrays.asList("a", null));
    }

    @Test
    void testComplexExtract() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.extract("[{\"name\": [1, 2, 3]}, 1]", "$.name")))).isEqualTo(Arrays.asList(null, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.extract("[{\"name\": {}}, 1]", "$.name")))).isEqualTo(Arrays.asList(null, null));
    }

    private QueryAssertions.ExpressionAssertProvider extract(String json, String jsonPath) {
        return this.assertions.expression("transform(cast(json_parse(json) as array(json)), e -> json_extract_scalar(e, '" + jsonPath + "'))").binding("json", "'" + json + "'");
    }
}

