/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.base.Ticker;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.testing.TestingTicker;
import io.airlift.units.Duration;
import io.trino.execution.StageId;
import io.trino.execution.StateMachine;
import io.trino.execution.TaskId;
import io.trino.execution.TaskInfo;
import io.trino.execution.TaskState;
import io.trino.metadata.NodeState;
import io.trino.operator.TaskStats;
import io.trino.server.NodeStateManager;
import io.trino.server.ServerConfig;
import io.trino.server.ShutdownAction;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.testcontainers.shaded.org.awaitility.Awaitility;

class TestNodeStateManager {
    public static final int GRACE_PERIOD_MILLIS = 200;
    private FakeScheduledExecutorService executor;
    private NodeStateManager nodeStateManager;
    private TestingTicker ticker;
    private TestingShutdownAction shutdownAction;
    private AtomicReference<List<TaskInfo>> tasks = new AtomicReference(new ArrayList());
    private TestTaskObservable sqlTasksObservable;

    TestNodeStateManager() {
    }

    @BeforeEach
    public void setUp() {
        this.ticker = new TestingTicker();
        this.executor = new FakeScheduledExecutorService((Ticker)this.ticker);
        this.shutdownAction = new TestingShutdownAction();
        this.sqlTasksObservable = new TestTaskObservable();
        this.nodeStateManager = this.createNodeStateManager(200);
    }

    @Test
    void testDefaultServerState() {
        Assertions.assertThat((Comparable)this.nodeStateManager.getServerState()).isEqualTo((Object)NodeState.ACTIVE);
    }

    @Test
    void testDrain() {
        this.nodeStateManager.transitionState(NodeState.DRAINING);
        Assertions.assertThat((Comparable)this.nodeStateManager.getServerState()).isEqualTo((Object)NodeState.DRAINING);
        this.ticker.increment(1L, TimeUnit.SECONDS);
        this.executor.run();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertThat((Comparable)this.nodeStateManager.getServerState()).isEqualTo((Object)NodeState.DRAINED));
    }

    @Test
    void testTransitionToShuttingDown() {
        Assertions.assertThat((Comparable)this.nodeStateManager.getServerState()).isEqualTo((Object)NodeState.ACTIVE);
        this.nodeStateManager.transitionState(NodeState.SHUTTING_DOWN);
        Assertions.assertThat((Comparable)this.nodeStateManager.getServerState()).isEqualTo((Object)NodeState.SHUTTING_DOWN);
        Awaitility.await().atMost(900L, TimeUnit.MILLISECONDS).until(() -> this.shutdownAction.isShuttingDown());
    }

    @Test
    void testCannotReactivateShuttingDown() {
        Assertions.assertThat((Comparable)this.nodeStateManager.getServerState()).isEqualTo((Object)NodeState.ACTIVE);
        this.nodeStateManager.transitionState(NodeState.SHUTTING_DOWN);
        Assertions.assertThat((Comparable)this.nodeStateManager.getServerState()).isEqualTo((Object)NodeState.SHUTTING_DOWN);
        Awaitility.await().atMost(800L, TimeUnit.MILLISECONDS).until(() -> this.shutdownAction.isShuttingDown());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.nodeStateManager.transitionState(NodeState.ACTIVE)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Invalid state transition");
    }

    @Test
    void testImmediateTransitionToShuttingDownWhenDrained() {
        Assertions.assertThat((Comparable)this.nodeStateManager.getServerState()).isEqualTo((Object)NodeState.ACTIVE);
        this.nodeStateManager.transitionState(NodeState.DRAINING);
        Assertions.assertThat((Comparable)this.nodeStateManager.getServerState()).isEqualTo((Object)NodeState.DRAINING);
        this.ticker.increment(1L, TimeUnit.SECONDS);
        this.executor.run();
        Awaitility.await().atMost(500L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertThat((Comparable)this.nodeStateManager.getServerState()).isEqualTo((Object)NodeState.DRAINED));
        this.nodeStateManager.transitionState(NodeState.SHUTTING_DOWN);
        Assertions.assertThat((Comparable)this.nodeStateManager.getServerState()).isEqualTo((Object)NodeState.SHUTTING_DOWN);
        Awaitility.await().pollInterval(1L, TimeUnit.MILLISECONDS).atMost(100L, TimeUnit.MILLISECONDS).until(() -> this.shutdownAction.isShuttingDown());
    }

    @Test
    void testWaitActiveTasksToFinishDuringShutdown() throws URISyntaxException {
        ArrayList<TaskInfo> taskInfos = new ArrayList<TaskInfo>();
        TaskInfo task = TaskInfo.createInitialTask((TaskId)new TaskId(new StageId("query1", 1), 1, 1), (URI)new URI(""), (String)"1", (boolean)false, Optional.empty(), (TaskStats)new TaskStats(DateTime.now(), null));
        taskInfos.add(task);
        this.tasks.set(taskInfos);
        this.nodeStateManager.transitionState(NodeState.SHUTTING_DOWN);
        Assertions.assertThat((Comparable)this.nodeStateManager.getServerState()).isEqualTo((Object)NodeState.SHUTTING_DOWN);
        this.ticker.increment(1L, TimeUnit.SECONDS);
        this.executor.run();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> this.sqlTasksObservable.getTasks().size() == 1);
        this.tasks.set(Collections.emptyList());
        this.sqlTasksObservable.getTasks().get(task.taskStatus().getTaskId()).stateChanged((Object)TaskState.FINISHED);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertThat((Comparable)this.nodeStateManager.getServerState()).isEqualTo((Object)NodeState.SHUTTING_DOWN));
    }

    @Test
    void testWaitActiveTasksToFinishDuringDraining() throws URISyntaxException {
        ArrayList<TaskInfo> taskInfos = new ArrayList<TaskInfo>();
        TaskInfo task = TaskInfo.createInitialTask((TaskId)new TaskId(new StageId("query1", 1), 1, 1), (URI)new URI(""), (String)"1", (boolean)false, Optional.empty(), (TaskStats)new TaskStats(DateTime.now(), null));
        taskInfos.add(task);
        this.tasks.set(taskInfos);
        this.nodeStateManager.transitionState(NodeState.DRAINING);
        Assertions.assertThat((Comparable)this.nodeStateManager.getServerState()).isEqualTo((Object)NodeState.DRAINING);
        this.ticker.increment(1L, TimeUnit.SECONDS);
        this.executor.run();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> this.sqlTasksObservable.getTasks().size() == 1);
        this.tasks.set(Collections.emptyList());
        this.sqlTasksObservable.getTasks().get(task.taskStatus().getTaskId()).stateChanged((Object)TaskState.FINISHED);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertThat((Comparable)this.nodeStateManager.getServerState()).isEqualTo((Object)NodeState.DRAINED));
    }

    @Test
    void testDrainToActiveToDrain() throws URISyntaxException, InterruptedException {
        this.nodeStateManager = this.createNodeStateManager(400);
        ArrayList<TaskInfo> taskInfos = new ArrayList<TaskInfo>();
        TaskInfo task = TaskInfo.createInitialTask((TaskId)new TaskId(new StageId("query1", 1), 1, 1), (URI)new URI(""), (String)"1", (boolean)false, Optional.empty(), (TaskStats)new TaskStats(DateTime.now(), null));
        taskInfos.add(task);
        this.tasks.set(taskInfos);
        this.nodeStateManager.transitionState(NodeState.DRAINING);
        Assertions.assertThat((Comparable)this.nodeStateManager.getServerState()).isEqualTo((Object)NodeState.DRAINING);
        this.ticker.increment(2L, TimeUnit.SECONDS);
        this.executor.run();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> this.sqlTasksObservable.getTasks().size() == 1);
        this.tasks.set(Collections.emptyList());
        this.sqlTasksObservable.getTasks().get(task.taskStatus().getTaskId()).stateChanged((Object)TaskState.FINISHED);
        Thread.sleep(200L);
        this.nodeStateManager.transitionState(NodeState.ACTIVE);
        this.tasks.set(taskInfos);
        this.nodeStateManager.transitionState(NodeState.DRAINING);
        Awaitility.await().during(800L, TimeUnit.MILLISECONDS).atMost(1500L, TimeUnit.MILLISECONDS).failFast("NodeState should never be drained, while there are still activeTasks", () -> this.nodeStateManager.getServerState().equals((Object)NodeState.DRAINED)).until(() -> this.nodeStateManager.getServerState().equals((Object)NodeState.DRAINING));
    }

    private NodeStateManager createNodeStateManager(int gracePeriodMillis) {
        ServerConfig serverConfig = new ServerConfig();
        serverConfig.setCoordinator(false);
        serverConfig.setGracePeriod(new Duration((double)gracePeriodMillis, TimeUnit.MILLISECONDS));
        Supplier<List> taskInfoSupplier = () -> this.tasks.get();
        return new NodeStateManager((NodeStateManager.SqlTasksObservable)this.sqlTasksObservable, taskInfoSupplier, serverConfig, (ShutdownAction)this.shutdownAction, new LifeCycleManager(Collections.emptyList(), null), (ScheduledExecutorService)this.executor);
    }

    private static class FakeScheduledExecutorService
    implements ScheduledExecutorService {
        private final Ticker clock;
        private List<Job> jobs = new ArrayList<Job>();

        public FakeScheduledExecutorService(Ticker clock) {
            this.clock = clock;
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            this.jobs.add(new Job(command, this.clock.read() + unit.toNanos(delay)));
            return null;
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return null;
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return null;
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return null;
        }

        void run() {
            long now = this.clock.read();
            List<Job> ready = this.jobs.stream().filter(job -> job.time <= now).sorted(Comparator.comparing(Job::time)).toList();
            this.jobs.removeAll(ready);
            new Thread(() -> ready.forEach(j -> j.command.run())).start();
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return List.of();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return false;
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return null;
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return null;
        }

        @Override
        public Future<?> submit(Runnable task) {
            return null;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return List.of();
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return List.of();
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }

        @Override
        public void execute(Runnable command) {
        }
    }

    private static class TestingShutdownAction
    implements ShutdownAction {
        private boolean shuttingDown;

        private TestingShutdownAction() {
        }

        public void onShutdown() {
            this.shuttingDown = true;
        }

        public boolean isShuttingDown() {
            return this.shuttingDown;
        }
    }

    private static class TestTaskObservable
    implements NodeStateManager.SqlTasksObservable {
        Map<TaskId, StateMachine.StateChangeListener<TaskState>> tasks = new HashMap<TaskId, StateMachine.StateChangeListener<TaskState>>();

        private TestTaskObservable() {
        }

        public void addStateChangeListener(TaskId taskId, StateMachine.StateChangeListener<TaskState> stateChangeListener) {
            this.tasks.put(taskId, stateChangeListener);
        }

        Map<TaskId, StateMachine.StateChangeListener<TaskState>> getTasks() {
            return this.tasks;
        }
    }

    record Job(Runnable command, long time) {
    }
}

