/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.inject.Key;
import com.google.inject.Provider;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.JsonResponseHandler;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.StatusResponseHandler;
import io.airlift.http.client.UnexpectedResponseException;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.testing.Closeables;
import io.airlift.tracing.SpanSerialization;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.trino.client.Column;
import io.trino.client.ProtocolHeaders;
import io.trino.client.QueryData;
import io.trino.client.QueryDataJacksonModule;
import io.trino.client.QueryResults;
import io.trino.client.ResultRowsDecoder;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryState;
import io.trino.execution.StageInfo;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.server.BasicQueryInfo;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.spi.Plugin;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.eventlistener.RoutineInfo;
import io.trino.testing.TestingAccessControlManager;
import java.io.Closeable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
public class TestQueryResource {
    static final JsonCodec<List<BasicQueryInfo>> BASIC_QUERY_INFO_CODEC = new JsonCodecFactory((Provider)new ObjectMapperProvider().withModules(Set.of(new QueryDataJacksonModule())).withJsonSerializers(Map.of(Span.class, new SpanSerialization.SpanSerializer(OpenTelemetry.noop()))).withJsonDeserializers(Map.of(Span.class, new SpanSerialization.SpanDeserializer(OpenTelemetry.noop())))).listJsonCodec(BasicQueryInfo.class);
    static final JsonCodec<QueryResults> QUERY_RESULTS_JSON_CODEC = new JsonCodecFactory((Provider)new ObjectMapperProvider().withModules(Set.of(new QueryDataJacksonModule()))).jsonCodec(QueryResults.class);
    private HttpClient client;
    private TestingTrinoServer server;

    @BeforeEach
    public void setup() {
        this.client = new JettyHttpClient();
        this.server = TestingTrinoServer.create();
        this.server.installPlugin((Plugin)new TpchPlugin());
        this.server.createCatalog("tpch", "tpch");
    }

    @AfterEach
    public void teardown() throws Exception {
        Closeables.closeAll((Closeable[])new Closeable[]{this.server, this.client});
        this.server = null;
        this.client = null;
    }

    @Test
    public void testIdempotentResults() {
        String sql = "SELECT * FROM tpch.tiny.lineitem";
        Request request = Request.Builder.preparePost().setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "user").setUri(HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl().resolve("/v1/statement")).build()).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)sql, (Charset)StandardCharsets.UTF_8)).build();
        QueryResults queryResults = (QueryResults)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_JSON_CODEC));
        URI uri = queryResults.getNextUri();
        while (uri != null) {
            QueryResults attempt1 = (QueryResults)this.client.execute(Request.Builder.prepareGet().setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "user").setUri(uri).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_JSON_CODEC));
            QueryResults attempt2 = (QueryResults)this.client.execute(Request.Builder.prepareGet().setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "user").setUri(uri).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_JSON_CODEC));
            this.assertDataEquals(attempt1.getColumns(), attempt2.getData(), attempt1.getData());
            uri = attempt1.getNextUri();
        }
    }

    @Test
    public void testGetQueryInfos() {
        this.runToCompletion("SELECT 1");
        this.runToCompletion("SELECT 2");
        this.runToCompletion("SELECT x FROM y");
        List<BasicQueryInfo> infos = this.getQueryInfos("/v1/query");
        Assertions.assertThat(infos).hasSize(3);
        TestQueryResource.assertStateCounts(infos, 2, 1, 0);
        infos = this.getQueryInfos("/v1/query?state=finished");
        Assertions.assertThat(infos).hasSize(2);
        TestQueryResource.assertStateCounts(infos, 2, 0, 0);
        infos = this.getQueryInfos("/v1/query?state=failed");
        Assertions.assertThat(infos).hasSize(1);
        TestQueryResource.assertStateCounts(infos, 0, 1, 0);
        infos = this.getQueryInfos("/v1/query?state=running");
        Assertions.assertThat(infos).isEmpty();
        TestQueryResource.assertStateCounts(infos, 0, 0, 0);
        infos = this.getQueryInfos("/v1/query?state=finished&state=failed&state=running");
        Assertions.assertThat(infos).hasSize(3);
        TestQueryResource.assertStateCounts(infos, 2, 1, 0);
        this.server.getAccessControl().deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"query", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.VIEW_QUERY)});
        try {
            Assertions.assertThat(this.getQueryInfos("/v1/query")).isEmpty();
            Assertions.assertThat(this.getQueryInfos("/v1/query?state=finished")).isEmpty();
            Assertions.assertThat(this.getQueryInfos("/v1/query?state=failed")).isEmpty();
            Assertions.assertThat(this.getQueryInfos("/v1/query?state=running")).isEmpty();
            Assertions.assertThat(this.getQueryInfos("/v1/query?state=finished&state=failed&state=running")).isEmpty();
        }
        finally {
            this.server.getAccessControl().reset();
        }
    }

    @Test
    public void testGetQueryInfoPruned() {
        String queryId = this.runToCompletion("SELECT now()");
        QueryInfo queryInfoPruned = this.getQueryInfo(queryId, true);
        QueryInfo queryInfoNotPruned = this.getQueryInfo(queryId);
        Assertions.assertThat((List)queryInfoPruned.getRoutines()).hasSize(1);
        Assertions.assertThat((List)queryInfoNotPruned.getRoutines()).hasSize(1);
        Assertions.assertThat((String)((RoutineInfo)queryInfoPruned.getRoutines().get(0)).getRoutine()).isEqualTo("now");
        Assertions.assertThat((String)((RoutineInfo)queryInfoNotPruned.getRoutines().get(0)).getRoutine()).isEqualTo("now");
        Assertions.assertThat((Optional)queryInfoPruned.getOutputStage()).isPresent();
        Assertions.assertThat((Optional)queryInfoNotPruned.getOutputStage()).isPresent();
        Assertions.assertThat((List)((StageInfo)queryInfoPruned.getOutputStage().get()).getTasks()).isEmpty();
        Assertions.assertThat((List)((StageInfo)queryInfoNotPruned.getOutputStage().get()).getTasks()).isNotEmpty();
    }

    @Test
    public void testGetQueryInfoDispatchFailure() {
        String queryId = this.runToCompletion("SELECT");
        QueryInfo info = this.getQueryInfo(queryId);
        Assertions.assertThat((boolean)info.isScheduled()).isFalse();
        Assertions.assertThat((Object)info.getFailureInfo()).isNotNull();
        Assertions.assertThat((Object)info.getFailureInfo().getErrorCode()).isEqualTo((Object)StandardErrorCode.SYNTAX_ERROR.toErrorCode());
        this.server.getAccessControl().deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"query", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.VIEW_QUERY)});
        try {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getQueryInfo(queryId)).isInstanceOf(UnexpectedResponseException.class)).matches(throwable -> ((UnexpectedResponseException)throwable).getStatusCode() == 403);
        }
        finally {
            this.server.getAccessControl().reset();
        }
    }

    @Test
    public void testGetQueryInfoExecutionFailure() {
        String queryId = this.runToCompletion("SELECT cast(rand() AS integer) / 0");
        QueryInfo info = this.getQueryInfo(queryId);
        Assertions.assertThat((boolean)info.isScheduled()).isTrue();
        Assertions.assertThat((Object)info.getFailureInfo()).isNotNull();
        Assertions.assertThat((Object)info.getFailureInfo().getErrorCode()).isEqualTo((Object)StandardErrorCode.DIVISION_BY_ZERO.toErrorCode());
    }

    @Test
    public void testCancel() {
        String queryId = this.startQuery("SELECT * FROM tpch.sf100.lineitem");
        this.server.getAccessControl().deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"query", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.KILL_QUERY)});
        try {
            Assertions.assertThat((int)this.cancelQueryInfo(queryId)).isEqualTo(403);
        }
        finally {
            this.server.getAccessControl().reset();
        }
        Assertions.assertThat((int)this.cancelQueryInfo(queryId)).isEqualTo(204);
        Assertions.assertThat((int)this.cancelQueryInfo(queryId)).isEqualTo(204);
        BasicQueryInfo queryInfo = this.server.getDispatchManager().getQueryInfo(new QueryId(queryId));
        Assertions.assertThat((Comparable)queryInfo.getState()).isEqualTo((Object)QueryState.FAILED);
        Assertions.assertThat((Object)queryInfo.getErrorCode()).isEqualTo((Object)StandardErrorCode.USER_CANCELED.toErrorCode());
    }

    @Test
    public void testKilled() {
        this.testKilled("killed");
    }

    @Test
    public void testPreempted() {
        this.testKilled("preempted");
    }

    private void assertDataEquals(List<Column> columns, QueryData left, QueryData right) {
        if (left == null) {
            Assertions.assertThat((Object)right).isNull();
            return;
        }
        try (ResultRowsDecoder decoder = new ResultRowsDecoder();){
            Assertions.assertThat((Iterable)decoder.toRows(columns, left)).containsAll((Iterable)decoder.toRows(columns, right));
        }
        catch (Exception e) {
            Fail.fail((Throwable)e);
        }
    }

    private void testKilled(String killType) {
        String queryId = this.startQuery("SELECT * FROM tpch.sf100.lineitem");
        this.server.getAccessControl().deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"query", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.KILL_QUERY)});
        try {
            Assertions.assertThat((int)this.killQueryInfo(queryId, killType)).isEqualTo(403);
        }
        finally {
            this.server.getAccessControl().reset();
        }
        Assertions.assertThat((int)this.killQueryInfo(queryId, killType)).isEqualTo(202);
        Assertions.assertThat((int)this.killQueryInfo(queryId, killType)).isEqualTo(409);
        BasicQueryInfo queryInfo = this.server.getDispatchManager().getQueryInfo(new QueryId(queryId));
        Assertions.assertThat((Comparable)queryInfo.getState()).isEqualTo((Object)QueryState.FAILED);
        if (killType.equals("killed")) {
            Assertions.assertThat((Object)queryInfo.getErrorCode()).isEqualTo((Object)StandardErrorCode.ADMINISTRATIVELY_KILLED.toErrorCode());
        } else {
            Assertions.assertThat((Object)queryInfo.getErrorCode()).isEqualTo((Object)StandardErrorCode.ADMINISTRATIVELY_PREEMPTED.toErrorCode());
        }
    }

    private String runToCompletion(String sql) {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl().resolve("/v1/statement")).build();
        Request request = Request.Builder.preparePost().setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "user").setUri(uri).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)sql, (Charset)StandardCharsets.UTF_8)).build();
        QueryResults queryResults = (QueryResults)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_JSON_CODEC));
        while (queryResults.getNextUri() != null) {
            request = Request.Builder.prepareGet().setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "user").setUri(queryResults.getNextUri()).build();
            queryResults = (QueryResults)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_JSON_CODEC));
        }
        return queryResults.getId();
    }

    private String startQuery(String sql) {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl()).replacePath("/v1/statement").build();
        Request request = Request.Builder.preparePost().setUri(uri).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)sql, (Charset)StandardCharsets.UTF_8)).setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "user").build();
        QueryResults queryResults = (QueryResults)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_JSON_CODEC));
        while (queryResults.getNextUri() != null && !queryResults.getStats().getState().equals(QueryState.RUNNING.toString())) {
            request = Request.Builder.prepareGet().setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "user").setUri(queryResults.getNextUri()).build();
            queryResults = (QueryResults)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_JSON_CODEC));
        }
        return queryResults.getId();
    }

    private List<BasicQueryInfo> getQueryInfos(String path) {
        Request request = Request.Builder.prepareGet().setUri(this.server.resolve(path)).setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "unknown").build();
        return (List)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(BASIC_QUERY_INFO_CODEC));
    }

    private static void assertStateCounts(Iterable<BasicQueryInfo> infos, int expectedFinished, int expectedFailed, int expectedRunning) {
        int failed = 0;
        int finished = 0;
        int running = 0;
        block5: for (BasicQueryInfo info : infos) {
            switch (info.getState()) {
                case FINISHED: {
                    ++finished;
                    continue block5;
                }
                case FAILED: {
                    ++failed;
                    continue block5;
                }
                case RUNNING: {
                    ++running;
                    continue block5;
                }
            }
            Fail.fail((String)("Unexpected query state " + String.valueOf(info.getState())));
        }
        Assertions.assertThat((int)failed).isEqualTo(expectedFailed);
        Assertions.assertThat((int)finished).isEqualTo(expectedFinished);
        Assertions.assertThat((int)running).isEqualTo(expectedRunning);
    }

    private QueryInfo getQueryInfo(String queryId) {
        return this.getQueryInfo(queryId, false);
    }

    private QueryInfo getQueryInfo(String queryId, boolean pruned) {
        HttpUriBuilder builder = HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl()).replacePath("/v1/query").appendPath(queryId).addParameter("pretty", new String[]{"true"});
        if (pruned) {
            builder.addParameter("pruned", new String[]{"true"});
        }
        URI uri = builder.build();
        Request request = Request.Builder.prepareGet().setUri(uri).setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "unknown").build();
        JsonCodec codec = ((JsonCodecFactory)this.server.getInstance(Key.get(JsonCodecFactory.class))).jsonCodec(QueryInfo.class);
        return (QueryInfo)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)codec));
    }

    private int cancelQueryInfo(String queryId) {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl()).replacePath("/v1/query").appendPath(queryId).build();
        Request request = Request.Builder.prepareDelete().setUri(uri).setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "unknown").build();
        return ((StatusResponseHandler.StatusResponse)this.client.execute(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler())).getStatusCode();
    }

    private int killQueryInfo(String queryId, String kind) {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl()).replacePath("/v1/query").appendPath(queryId).appendPath(kind).build();
        Request request = Request.Builder.preparePut().setUri(uri).setHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), "unknown").build();
        return ((StatusResponseHandler.StatusResponse)this.client.execute(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler())).getStatusCode();
    }
}

