/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableList;
import com.google.inject.Provider;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.client.ClientTypeSignature;
import io.trino.client.Column;
import io.trino.client.QueryData;
import io.trino.client.QueryResults;
import io.trino.client.ResultRowsDecoder;
import io.trino.client.StatementStats;
import io.trino.client.TrinoJsonCodec;
import io.trino.client.TypedQueryData;
import io.trino.server.protocol.spooling.ServerQueryDataJacksonModule;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestQueryResultsSerialization {
    private static final List<Column> COLUMNS = ImmutableList.of((Object)new Column("_col0", "bigint", new ClientTypeSignature("bigint")));
    private static final JsonCodec<QueryResults> SERVER_CODEC = new JsonCodecFactory((Provider)new ObjectMapperProvider().withModules(Set.of(new ServerQueryDataJacksonModule()))).jsonCodec(QueryResults.class);
    private static final TrinoJsonCodec<QueryResults> CLIENT_CODEC = TrinoJsonCodec.jsonCodec(QueryResults.class);

    @Test
    public void testNullDataSerialization() {
        Assertions.assertThat((String)TestQueryResultsSerialization.serialize(null)).isEqualToIgnoringWhitespace((CharSequence)"  {\n  \"id\" : \"20160128_214710_00012_rk68b\",\n  \"infoUri\" : \"http://coordinator/query.html?20160128_214710_00012_rk68b\",\n  \"columns\" : [ {\n    \"name\" : \"_col0\",\n    \"type\" : \"bigint\",\n    \"typeSignature\" : {\n      \"rawType\" : \"bigint\",\n      \"arguments\" : [ ]\n    }\n  } ],\n  \"stats\" : {\n    \"state\" : \"FINISHED\",\n    \"queued\" : false,\n    \"scheduled\" : false,\n    \"nodes\" : 0,\n    \"totalSplits\" : 0,\n    \"queuedSplits\" : 0,\n    \"runningSplits\" : 0,\n    \"completedSplits\" : 0,\n    \"planningTimeMillis\": 0,\n    \"analysisTimeMillis\": 0,\n    \"cpuTimeMillis\" : 0,\n    \"wallTimeMillis\" : 0,\n    \"queuedTimeMillis\" : 0,\n    \"elapsedTimeMillis\" : 0,\n    \"finishingTimeMillis\": 0,\n    \"physicalInputTimeMillis\": 0,\n    \"processedRows\" : 0,\n    \"processedBytes\" : 0,\n    \"physicalInputBytes\" : 0,\n    \"physicalWrittenBytes\" : 0,\n    \"internalNetworkInputBytes\": 0,\n    \"peakMemoryBytes\" : 0,\n    \"spilledBytes\" : 0\n  },\n  \"warnings\" : [ ]\n}\n");
    }

    @Test
    public void testEmptyArraySerialization() throws Exception {
        this.testRoundTrip(TypedQueryData.of((List)ImmutableList.of()), "[]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testRoundTrip(TypedQueryData.of((List)ImmutableList.of((Object)ImmutableList.of())), "[[]]")).isInstanceOf(RuntimeException.class)).hasMessageContaining("Unexpected token END_ARRAY");
    }

    @Test
    public void testSerialization() throws Exception {
        QueryData values = TypedQueryData.of((List)ImmutableList.of((Object)ImmutableList.of((Object)1L), (Object)ImmutableList.of((Object)5L)));
        this.testRoundTrip(values, "[[1],[5]]");
    }

    private void testRoundTrip(QueryData results, String expectedDataRepresentation) throws Exception {
        Assertions.assertThat((String)TestQueryResultsSerialization.serialize(results)).isEqualToIgnoringWhitespace((CharSequence)this.queryResultsJson(expectedDataRepresentation));
        String serialized = TestQueryResultsSerialization.serialize(results);
        try (ResultRowsDecoder decoder = new ResultRowsDecoder();){
            Assertions.assertThat((Iterable)decoder.toRows(COLUMNS, ((QueryResults)CLIENT_CODEC.fromJson(serialized)).getData())).containsAll((Iterable)decoder.toRows(COLUMNS, results));
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    private String queryResultsJson(String expectedDataField) {
        return String.format("{\n    \"id\" : \"20160128_214710_00012_rk68b\",\n    \"infoUri\" : \"http://coordinator/query.html?20160128_214710_00012_rk68b\",\n    \"columns\" : [ {\n      \"name\" : \"_col0\",\n      \"type\" : \"bigint\",\n      \"typeSignature\" : {\n        \"rawType\" : \"bigint\",\n        \"arguments\" : [ ]\n      }\n    } ],\n    \"data\" : %s,\n    \"stats\" : {\n      \"state\" : \"FINISHED\",\n      \"queued\" : false,\n      \"scheduled\" : false,\n      \"nodes\" : 0,\n      \"totalSplits\" : 0,\n      \"queuedSplits\" : 0,\n      \"runningSplits\" : 0,\n      \"completedSplits\" : 0,\n      \"planningTimeMillis\": 0,\n      \"analysisTimeMillis\": 0,\n      \"cpuTimeMillis\" : 0,\n      \"wallTimeMillis\" : 0,\n      \"queuedTimeMillis\" : 0,\n      \"elapsedTimeMillis\" : 0,\n      \"finishingTimeMillis\": 0,\n      \"physicalInputTimeMillis\": 0,\n      \"processedRows\" : 0,\n      \"processedBytes\" : 0,\n      \"physicalInputBytes\" : 0,\n      \"physicalWrittenBytes\" : 0,\n      \"internalNetworkInputBytes\": 0,\n      \"peakMemoryBytes\" : 0,\n      \"spilledBytes\" : 0\n    },\n    \"warnings\" : [ ]\n  }", expectedDataField);
    }

    private static String serialize(QueryData data) {
        return SERVER_CODEC.toJson((Object)new QueryResults("20160128_214710_00012_rk68b", URI.create("http://coordinator/query.html?20160128_214710_00012_rk68b"), null, null, (List)ImmutableList.of((Object)new Column("_col0", "bigint", new ClientTypeSignature("bigint"))), data, StatementStats.builder().setState("FINISHED").setProgressPercentage(OptionalDouble.empty()).setRunningPercentage(OptionalDouble.empty()).build(), null, (List)ImmutableList.of(), null, OptionalLong.empty()));
    }
}

