/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.trino.server.protocol.spooling.SpoolingConfig;
import io.trino.util.Ciphers;
import java.util.Base64;
import java.util.Map;
import org.junit.jupiter.api.Test;

class TestSpoolingConfig {
    TestSpoolingConfig() {
    }

    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((SpoolingConfig)ConfigAssertions.recordDefaults(SpoolingConfig.class)).setSharedSecretKey(null).setRetrievalMode(SpoolingConfig.SegmentRetrievalMode.STORAGE).setInitialSegmentSize(DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaximumSegmentSize(DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setInliningMaxRows(50000L).setInliningMaxSize(DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setInliningEnabled(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        String randomAesEncryptionKey = Base64.getEncoder().encodeToString(Ciphers.createRandomAesEncryptionKey().getEncoded());
        ImmutableMap properties = ImmutableMap.builder().put((Object)"protocol.spooling.shared-secret-key", (Object)randomAesEncryptionKey).put((Object)"protocol.spooling.retrieval-mode", (Object)"coordinator_storage_redirect").put((Object)"protocol.spooling.inlining.enabled", (Object)"false").put((Object)"protocol.spooling.initial-segment-size", (Object)"1kB").put((Object)"protocol.spooling.max-segment-size", (Object)"8kB").put((Object)"protocol.spooling.inlining.max-rows", (Object)"10000").put((Object)"protocol.spooling.inlining.max-size", (Object)"1MB").buildOrThrow();
        SpoolingConfig expected = new SpoolingConfig().setRetrievalMode(SpoolingConfig.SegmentRetrievalMode.COORDINATOR_STORAGE_REDIRECT).setSharedSecretKey(randomAesEncryptionKey).setInitialSegmentSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setMaximumSegmentSize(DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setInliningMaxRows(10000L).setInliningMaxSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setInliningEnabled(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

