/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.scalar.JsonPath;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Lambda;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.rule.SpecializeTransformWithJsonParse;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingSession;
import io.trino.type.FunctionType;
import io.trino.type.JsonPathType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSpecializeTransformWithJsonParse {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction JSON_STRING_TO_ARRAY = FUNCTIONS.getCoercion(GlobalFunctionCatalog.builtinFunctionName((String)"$internal$json_string_to_array_cast"), (Type)VarcharType.VARCHAR, (Type)new ArrayType((Type)VarcharType.VARCHAR));
    private static final ResolvedFunction TRANSFORM = FUNCTIONS.resolveFunction("transform", TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)VarcharType.VARCHAR), new FunctionType(List.of(VarcharType.VARCHAR), (Type)VarcharType.VARCHAR)}));
    private static final ResolvedFunction JSON_EXTRACT_SCALAR = FUNCTIONS.resolveFunction("json_extract_scalar", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, JsonPathType.JSON_PATH}));

    @Test
    void testArray() {
        JsonPath jsonPath = new JsonPath("$");
        Assertions.assertThat(this.optimize((Expression)new Call(TRANSFORM, (List)ImmutableList.of((Object)new Call(JSON_STRING_TO_ARRAY, (List)ImmutableList.of((Object)new Reference((Type)VarcharType.VARCHAR, "json_string"))), (Object)new Lambda((List)ImmutableList.of((Object)new Symbol((Type)VarcharType.VARCHAR, "json_array")), (Expression)new Call(JSON_EXTRACT_SCALAR, (List)ImmutableList.of((Object)new Reference((Type)VarcharType.VARCHAR, "json_array"), (Object)new Constant((Type)JsonPathType.JSON_PATH, (Object)jsonPath)))))))).isEqualTo(Optional.of(new Call(TestingPlannerContext.PLANNER_CONTEXT.getMetadata().resolveBuiltinFunction("$internal$json_string_array_extract_scalar", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, JsonPathType.JSON_PATH})), (List)ImmutableList.of((Object)new Reference((Type)VarcharType.VARCHAR, "json_string"), (Object)new Constant((Type)JsonPathType.JSON_PATH, (Object)jsonPath)))));
    }

    private Optional<Expression> optimize(Expression expression) {
        return new SpecializeTransformWithJsonParse(TestingPlannerContext.PLANNER_CONTEXT).apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

