/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import io.trino.sql.ir.Reference;
import io.trino.sql.planner.assertions.SymbolAliases;
import java.util.Objects;

public class MatchResult {
    public static final MatchResult NO_MATCH = new MatchResult(false, new SymbolAliases());
    private final boolean matches;
    private final SymbolAliases newAliases;

    public static MatchResult match() {
        return new MatchResult(true, new SymbolAliases());
    }

    public static MatchResult match(String alias, Reference reference) {
        SymbolAliases newAliases = SymbolAliases.builder().put(alias, reference).build();
        return new MatchResult(true, newAliases);
    }

    public static MatchResult match(SymbolAliases newAliases) {
        return new MatchResult(true, newAliases);
    }

    public MatchResult(boolean matches) {
        this(matches, new SymbolAliases());
    }

    private MatchResult(boolean matches, SymbolAliases newAliases) {
        this.matches = matches;
        this.newAliases = Objects.requireNonNull(newAliases, "newAliases is null");
    }

    public boolean isMatch() {
        return this.matches;
    }

    public SymbolAliases getAliases() {
        return this.newAliases;
    }

    public String toString() {
        if (this.matches) {
            return "MATCH";
        }
        return "NO MATCH";
    }
}

