/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.OffsetNode;
import io.trino.sql.planner.plan.PlanNode;

public class OffsetMatcher
implements Matcher {
    private final long rowCount;

    public OffsetMatcher(long rowCount) {
        this.rowCount = rowCount;
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        if (!(node instanceof OffsetNode)) {
            return false;
        }
        OffsetNode offsetNode = (OffsetNode)node;
        return offsetNode.getCount() == this.rowCount;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node));
        return MatchResult.match();
    }
}

