/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneMarkDistinctColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPruneMarkDistinctColumns
extends BaseRuleTest {
    public TestPruneMarkDistinctColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testMarkerSymbolNotReferenced() {
        this.tester().assertThat((Rule<?>)new PruneMarkDistinctColumns()).on(p -> {
            Symbol key = p.symbol("key");
            Symbol key2 = p.symbol("key2");
            Symbol mark = p.symbol("mark");
            Symbol unused = p.symbol("unused");
            return p.project(Assignments.of((Symbol)key2, (Expression)key.toSymbolReference()), (PlanNode)p.markDistinct(mark, (List<Symbol>)ImmutableList.of((Object)key), (PlanNode)p.values(key, unused)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "key"))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"key", (Object)"unused"))));
    }

    @Test
    public void testSourceSymbolNotReferenced() {
        this.tester().assertThat((Rule<?>)new PruneMarkDistinctColumns()).on(p -> {
            Symbol key = p.symbol("key");
            Symbol mark = p.symbol("mark");
            Symbol hash = p.symbol("hash");
            Symbol unused = p.symbol("unused");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{mark}), (PlanNode)p.markDistinct(mark, (List<Symbol>)ImmutableList.of((Object)key), hash, (PlanNode)p.values(key, hash, unused)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"mark", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BooleanType.BOOLEAN, "mark"))), PlanMatchPattern.markDistinct("mark", (List<String>)ImmutableList.of((Object)"key"), "hash", PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "key")), (Object)"hash", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "hash"))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"key", (Object)"hash", (Object)"unused"))))));
    }

    @Test
    public void testKeySymbolNotReferenced() {
        this.tester().assertThat((Rule<?>)new PruneMarkDistinctColumns()).on(p -> {
            Symbol key = p.symbol("key");
            Symbol mark = p.symbol("mark");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{mark}), (PlanNode)p.markDistinct(mark, (List<Symbol>)ImmutableList.of((Object)key), (PlanNode)p.values(key)));
        }).doesNotFire();
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneMarkDistinctColumns()).on(p -> {
            Symbol key = p.symbol("key");
            Symbol mark = p.symbol("mark");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{key, mark}), (PlanNode)p.markDistinct(mark, (List<Symbol>)ImmutableList.of((Object)key), (PlanNode)p.values(key)));
        }).doesNotFire();
    }
}

