/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.plugin.tpch.TpchTransactionHandle;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushTopNThroughProject;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.SortItem;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPushTopNThroughProject
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_BIGINT = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final RowType rowType = RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("y"), (Type)BigintType.BIGINT)));

    public TestPushTopNThroughProject() {
        super(new Plugin[0]);
    }

    @Test
    public void testPushdownTopNNonIdentityProjection() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughProject()).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            Symbol projectedB = p.symbol("projectedB");
            Symbol b = p.symbol("b");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)projectedA), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Symbol)projectedB, (Expression)new Reference((Type)BigintType.BIGINT, "b")), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"projectedA", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"projectedB", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "b"))), PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "b"))));
    }

    @Test
    public void testPushdownTopNNonIdentityProjectionWithExpression() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughProject()).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            Symbol projectedC = p.symbol("projectedC");
            Symbol b = p.symbol("b");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)projectedA), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Symbol)projectedC, (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Reference((Type)BigintType.BIGINT, "b")))), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"projectedA", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"projectedC", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Reference((Type)BigintType.BIGINT, "b"))))), PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "b"))));
    }

    @Test
    public void testDoNotPushdownTopNThroughIdentityProjection() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughProject()).on(p -> {
            Symbol a = p.symbol("a");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.project(Assignments.of((Symbol)a, (Expression)a.toSymbolReference()), (PlanNode)p.values(a)));
        }).doesNotFire();
    }

    @Test
    public void testPushdownTopNThroughProjectionOverFilterOverTableScan() {
        TableHandle nationTableHandle = new TableHandle(this.tester().getCurrentCatalogHandle(), (ConnectorTableHandle)new TpchTableHandle("sf1", "nation", 1.0), (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE);
        TpchColumnHandle nationkeyColumnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)new PushTopNThroughProject()).on(arg_0 -> TestPushTopNThroughProject.lambda$testPushdownTopNThroughProjectionOverFilterOverTableScan$0(nationTableHandle, (ColumnHandle)nationkeyColumnHandle, arg_0)).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"projected", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "nationkey"))), PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("nationkey", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.filter((Expression)Booleans.TRUE, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey"))))));
    }

    @Test
    public void testPushdownTopNThroughProjectionOverTableScan() {
        TableHandle nationTableHandle = new TableHandle(this.tester().getCurrentCatalogHandle(), (ConnectorTableHandle)new TpchTableHandle("sf1", "nation", 1.0), (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE);
        TpchColumnHandle nationkeyColumnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)new PushTopNThroughProject()).on(arg_0 -> TestPushTopNThroughProject.lambda$testPushdownTopNThroughProjectionOverTableScan$0(nationTableHandle, (ColumnHandle)nationkeyColumnHandle, arg_0)).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"projected", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "nationkey"))), PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("nationkey", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")))));
    }

    @Test
    public void testDoesntPushDownTopNThroughExclusiveDereferences() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughProject()).on(p -> {
            Symbol a = p.symbol("a", (Type)rowType);
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)p.symbol("c")), (PlanNode)p.project(Assignments.builder().put(p.symbol("b"), (Expression)new FieldReference((Expression)a.toSymbolReference(), 0)).put(p.symbol("c"), (Expression)new FieldReference((Expression)a.toSymbolReference(), 1)).build(), (PlanNode)p.values(a)));
        }).doesNotFire();
    }

    @Test
    public void testPushTopNThroughOverlappingDereferences() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughProject()).on(p -> {
            Symbol a = p.symbol("a", (Type)rowType);
            Symbol d = p.symbol("d");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)d), (PlanNode)p.project(Assignments.builder().put(p.symbol("b"), (Expression)new FieldReference((Expression)a.toSymbolReference(), 0)).put(p.symbol("c", (Type)rowType), (Expression)a.toSymbolReference()).putIdentity(d).build(), (PlanNode)p.values(a, d)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)rowType, "a"), 0)), (Object)"c", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"d", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "d"))), PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("d", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "d"))));
    }

    private static /* synthetic */ PlanNode lambda$testPushdownTopNThroughProjectionOverTableScan$0(TableHandle nationTableHandle, ColumnHandle nationkeyColumnHandle, PlanBuilder p) {
        Symbol projected = p.symbol("projected");
        Symbol nationkey = p.symbol("nationkey");
        return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)projected), (PlanNode)p.project(Assignments.of((Symbol)projected, (Expression)new Reference((Type)BigintType.BIGINT, "nationkey")), (PlanNode)p.tableScan(nationTableHandle, (List<Symbol>)ImmutableList.of((Object)nationkey), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)nationkey, (Object)nationkeyColumnHandle))));
    }

    private static /* synthetic */ PlanNode lambda$testPushdownTopNThroughProjectionOverFilterOverTableScan$0(TableHandle nationTableHandle, ColumnHandle nationkeyColumnHandle, PlanBuilder p) {
        Symbol projected = p.symbol("projected");
        Symbol nationkey = p.symbol("nationkey");
        return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)projected), (PlanNode)p.project(Assignments.of((Symbol)projected, (Expression)new Reference((Type)BigintType.BIGINT, "nationkey")), (PlanNode)p.filter((Expression)Booleans.TRUE, (PlanNode)p.tableScan(nationTableHandle, (List<Symbol>)ImmutableList.of((Object)nationkey), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)nationkey, (Object)nationkeyColumnHandle)))));
    }
}

