/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.operator.table.ExcludeColumnsFunction;
import io.trino.spi.Plugin;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RewriteExcludeColumnsFunctionToProjection;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

class TestRewriteExcludeColumnsFunctionToProjection
extends BaseRuleTest {
    TestRewriteExcludeColumnsFunctionToProjection() {
        super(new Plugin[0]);
    }

    @Test
    public void rewriteExcludeColumnsFunction() {
        this.tester().assertThat((Rule<?>)new RewriteExcludeColumnsFunctionToProjection()).on(p -> {
            Symbol a = p.symbol("a", (Type)BooleanType.BOOLEAN);
            Symbol b = p.symbol("b", (Type)BigintType.BIGINT);
            Symbol c = p.symbol("c", (Type)SmallintType.SMALLINT);
            Symbol x = p.symbol("x", (Type)BigintType.BIGINT);
            Symbol y = p.symbol("y", (Type)SmallintType.SMALLINT);
            return p.tableFunctionProcessor(builder -> builder.name("exclude_columns").properOutputs(x, y).pruneWhenEmpty().requiredSymbols((List<List<Symbol>>)ImmutableList.of((Object)ImmutableList.of((Object)b, (Object)c))).connectorHandle((ConnectorTableFunctionHandle)new ExcludeColumnsFunction.ExcludeColumnsFunctionHandle()).source((PlanNode)p.values(a, b, c)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "b")), (Object)"y", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)SmallintType.SMALLINT, "c"))), PlanMatchPattern.values("a", "b", "c")));
    }

    @Test
    public void doNotRewriteOtherFunction() {
        this.tester().assertThat((Rule<?>)new RewriteExcludeColumnsFunctionToProjection()).on(p -> {
            Symbol a = p.symbol("a", (Type)BooleanType.BOOLEAN);
            Symbol b = p.symbol("b", (Type)BigintType.BIGINT);
            Symbol c = p.symbol("c", (Type)SmallintType.SMALLINT);
            return p.tableFunctionProcessor(builder -> builder.name("testing_function").requiredSymbols((List<List<Symbol>>)ImmutableList.of((Object)ImmutableList.of((Object)b, (Object)c))).source((PlanNode)p.values(a, b, c)));
        }).doesNotFire();
    }
}

