/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.metadata.TableFunctionHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableFunctionNode;
import io.trino.sql.planner.plan.TableFunctionProcessorNode;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingTransactionHandle;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class TableFunctionProcessorBuilder {
    private String name;
    private List<Symbol> properOutputs = ImmutableList.of();
    private Optional<PlanNode> source = Optional.empty();
    private boolean pruneWhenEmpty;
    private List<TableFunctionNode.PassThroughSpecification> passThroughSpecifications = ImmutableList.of();
    private List<List<Symbol>> requiredSymbols = ImmutableList.of();
    private Optional<Map<Symbol, Symbol>> markerSymbols = Optional.empty();
    private Optional<DataOrganizationSpecification> specification = Optional.empty();
    private Set<Symbol> prePartitioned = ImmutableSet.of();
    private int preSorted;
    private Optional<Symbol> hashSymbol = Optional.empty();
    private ConnectorTableFunctionHandle connectorHandle = new ConnectorTableFunctionHandle(this){};

    public TableFunctionProcessorBuilder name(String name) {
        this.name = name;
        return this;
    }

    public TableFunctionProcessorBuilder properOutputs(Symbol ... properOutputs) {
        this.properOutputs = ImmutableList.copyOf((Object[])properOutputs);
        return this;
    }

    public TableFunctionProcessorBuilder source(PlanNode source) {
        this.source = Optional.of(source);
        return this;
    }

    public TableFunctionProcessorBuilder pruneWhenEmpty() {
        this.pruneWhenEmpty = true;
        return this;
    }

    public TableFunctionProcessorBuilder passThroughSpecifications(TableFunctionNode.PassThroughSpecification ... passThroughSpecifications) {
        this.passThroughSpecifications = ImmutableList.copyOf((Object[])passThroughSpecifications);
        return this;
    }

    public TableFunctionProcessorBuilder requiredSymbols(List<List<Symbol>> requiredSymbols) {
        this.requiredSymbols = requiredSymbols;
        return this;
    }

    public TableFunctionProcessorBuilder markerSymbols(Map<Symbol, Symbol> markerSymbols) {
        this.markerSymbols = Optional.of(markerSymbols);
        return this;
    }

    public TableFunctionProcessorBuilder specification(DataOrganizationSpecification specification) {
        this.specification = Optional.of(specification);
        return this;
    }

    public TableFunctionProcessorBuilder prePartitioned(Set<Symbol> prePartitioned) {
        this.prePartitioned = prePartitioned;
        return this;
    }

    public TableFunctionProcessorBuilder preSorted(int preSorted) {
        this.preSorted = preSorted;
        return this;
    }

    public TableFunctionProcessorBuilder hashSymbol(Symbol hashSymbol) {
        this.hashSymbol = Optional.of(hashSymbol);
        return this;
    }

    public TableFunctionProcessorBuilder connectorHandle(ConnectorTableFunctionHandle connectorHandle) {
        this.connectorHandle = connectorHandle;
        return this;
    }

    public TableFunctionProcessorNode build(PlanNodeIdAllocator idAllocator) {
        return new TableFunctionProcessorNode(idAllocator.getNextId(), this.name, this.properOutputs, this.source, this.pruneWhenEmpty, this.passThroughSpecifications, this.requiredSymbols, this.markerSymbols, this.specification, this.prePartitioned, this.preSorted, this.hashSymbol, new TableFunctionHandle(TestingHandles.TEST_CATALOG_HANDLE, this.connectorHandle, (ConnectorTransactionHandle)TestingTransactionHandle.create()));
    }
}

