/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.JoinType;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TestFullOuterJoinWithCoalesce
extends BasePlanTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));

    @Test
    @Disabled
    public void testFullOuterJoinWithCoalesce() {
        this.assertDistributedPlan("SELECT coalesce(ts.a, r.a) FROM (   SELECT coalesce(t.a, s.a) AS a    FROM (VALUES 1, 2, 3) t(a)    FULL OUTER JOIN (VALUES 1, 4) s(a)   ON t.a = s.a) ts FULL OUTER JOIN (VALUES 2, 5) r(a) on ts.a = r.a", PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)IntegerType.INTEGER, "ts"), (Expression)new Reference((Type)IntegerType.INTEGER, "r"), new Expression[0]))), PlanMatchPattern.join(JoinType.FULL, builder -> builder.equiCriteria("ts", "r").left(PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ts", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)IntegerType.INTEGER, "t"), (Expression)new Reference((Type)IntegerType.INTEGER, "s"), new Expression[0]))), PlanMatchPattern.join(JoinType.FULL, leftJoinBuilder -> leftJoinBuilder.equiCriteria("t", "s").left(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"t"))))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"s"))))))))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"r")))))))));
    }

    @Test
    @Disabled
    public void testArgumentsInDifferentOrder() {
        this.assertDistributedPlan("SELECT coalesce(l.a, r.a) FROM (VALUES 1, 2, 3) l(a) FULL OUTER JOIN (VALUES 1, 4) r(a) ON l.a = r.a GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)IntegerType.INTEGER, "l"), (Expression)new Reference((Type)IntegerType.INTEGER, "r"), new Expression[0]))), PlanMatchPattern.join(JoinType.FULL, builder -> builder.equiCriteria("l", "r").left(PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"l")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"r")))))))))));
        this.assertDistributedPlan("SELECT coalesce(r.a, l.a) FROM (VALUES 1, 2, 3) l(a) FULL OUTER JOIN (VALUES 1, 4) r(a) ON l.a = r.a GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)IntegerType.INTEGER, "r"), (Expression)new Reference((Type)IntegerType.INTEGER, "l"), new Expression[0]))), PlanMatchPattern.join(JoinType.FULL, builder -> builder.equiCriteria("l", "r").left(PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"l")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"r")))))))))));
    }

    @Test
    public void testCoalesceWithManyArguments() {
        this.assertDistributedPlan("SELECT coalesce(l.a, m.a, r.a) FROM (VALUES 1, 2, 3) l(a) FULL OUTER JOIN (VALUES 1, 4) m(a) ON l.a = m.a FULL OUTER JOIN (VALUES 2, 5) r(a) ON l.a = r.a GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)IntegerType.INTEGER, "l"), (Expression)new Reference((Type)IntegerType.INTEGER, "m"), new Expression[]{new Reference((Type)IntegerType.INTEGER, "r")}))), PlanMatchPattern.join(JoinType.FULL, builder -> builder.equiCriteria("l", "r").left(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.FULL, leftJoinBuilder -> leftJoinBuilder.equiCriteria("l", "m").left(PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"l")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"m"))))))).right(PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"r"))))))))));
    }

    @Test
    public void testComplexArgumentToCoalesce() {
        this.assertDistributedPlan("SELECT coalesce(l.a, m.a + 1, r.a) FROM (VALUES 1, 2, 3) l(a) FULL OUTER JOIN (VALUES 1, 4) m(a) ON l.a = m.a FULL OUTER JOIN (VALUES 2, 5) r(a) ON l.a = r.a GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)IntegerType.INTEGER, "l"), (Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "m"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), new Expression[]{new Reference((Type)IntegerType.INTEGER, "r")}))), PlanMatchPattern.join(JoinType.FULL, builder -> builder.equiCriteria("l", "r").left(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.FULL, leftJoinBuilder -> leftJoinBuilder.equiCriteria("l", "m").left(PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"l")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"m"))))))).right(PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"r"))))))))));
    }
}

