/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestGroupBy {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testCastDifferentCase() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT CAST(x AS bigint) FROM (VALUES 42) t(x) GROUP BY CAST(x AS BIGINT)"))).matches("VALUES BIGINT '42'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT CAST(row(x) AS row(\"A\" bigint)) FROM (VALUES 42) t(x) GROUP BY CAST(row(x) AS row(\"A\" bigint))"))).matches("SELECT CAST(row(BIGINT '42') AS row(\"A\" bigint))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT CAST(row(x) AS row(abc bigint)) FROM (VALUES 42) t(x) GROUP BY CAST(row(x) AS row(ABC bigint))"))).matches("SELECT CAST(row(BIGINT '42') AS row(abc bigint))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT CAST(row(x) AS row(\"A\" bigint)) FROM (VALUES 42) t(x) GROUP BY CAST(row(x) AS row(\"A\" BigINT))"))).matches("SELECT CAST(row(BIGINT '42') AS row(\"A\" bigint))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT CAST(row(x) AS row(\"a\" bigint)) FROM (VALUES 42) t(x) GROUP BY CAST(row(x) AS row(\"A\" bigint))"))).failure().hasMessage("line 1:8: 'CAST(ROW (x) AS ROW(\"a\" bigint))' must be an aggregate expression or appear in GROUP BY clause");
    }

    @Test
    public void testDuplicateComplexExpressions() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a + 1, a + 1 FROM (VALUES 1) t(a) GROUP BY 1, 2"))).matches("VALUES (2, 2)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 FROM (VALUES 1) t(a) GROUP BY a + 1, a + 1"))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 FROM (VALUES 1) t(a) GROUP BY t.a + 1, a + 1"))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 FROM (VALUES 1) t(a) GROUP BY A + 1, a + 1"))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 FROM (VALUES 1) t(a) GROUP BY t.A + 1, a + 1"))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a + 1 FROM (VALUES 1) t(a) GROUP BY t.A + 1, 1"))).matches("VALUES 2");
    }

    @Test
    public void testReferenceWithMixedStyle() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a + 1 FROM (VALUES 1) t(a) GROUP BY A + 1"))).matches("VALUES 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a + 1 FROM (VALUES 1) t(a) GROUP BY t.a + 1"))).matches("VALUES 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a + 1 FROM (VALUES 1) t(a) GROUP BY t.A + 1"))).matches("VALUES 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT t.a + 1 FROM (VALUES 1) t(a) GROUP BY a + 1"))).matches("VALUES 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT t.a + 1 FROM (VALUES 1) t(a) GROUP BY A + 1"))).matches("VALUES 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT t.a + 1 FROM (VALUES 1) t(a) GROUP BY t.A + 1"))).matches("VALUES 2");
    }

    @Test
    public void testGroupByRepeatedOrdinals() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT null GROUP BY 1, 1"))).matches("VALUES null");
    }

    @Test
    void testGroupByAuto() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT *\nFROM (VALUES 1) t(a)\nGROUP BY AUTO\n"))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT *\nFROM (VALUES 1, 2) t(a)\nGROUP BY AUTO\n"))).matches("VALUES 1, 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT sum(a)\nFROM (VALUES (1), (2)) t(a)\nGROUP BY AUTO\n"))).matches("VALUES BIGINT '3'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, sum(b)\nFROM (VALUES (1, 10), (1, 20)) t(a, b)\nGROUP BY AUTO\n"))).matches("VALUES (1, BIGINT '30')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a AS new_a, sum(b) AS sum_b\nFROM (VALUES (1, 10), (1, 20)) t(a, b)\nGROUP BY AUTO\n"))).matches("VALUES (1, BIGINT '30')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a + 1, sum(b)\nFROM (VALUES (1, 10), (1, 20)) t(a, b)\nGROUP BY AUTO\n"))).matches("VALUES (2, BIGINT '30')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT abs(a), sum(b)\nFROM (VALUES (-1, 10), (-1, 20)) t(a, b)\nGROUP BY AUTO\n"))).matches("VALUES (1, BIGINT '30')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT sum(b), a\nFROM (VALUES (1, 10), (1, 20)) t(a, b)\nGROUP BY AUTO\n"))).matches("VALUES (BIGINT '30', 1)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT sum(a)\nFROM (VALUES (1, 10), (1, 20)) t(a, b)\nGROUP BY AUTO\n"))).matches("VALUES (BIGINT '2')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT sum(a)\nFROM (VALUES (1, 10), (1, 20)) t(a, b)\nGROUP BY ALL AUTO\n"))).matches("VALUES (BIGINT '2')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT sum(a)\nFROM (VALUES (1, 10), (1, 20)) t(a, b)\nGROUP BY DISTINCT AUTO\n"))).matches("VALUES (BIGINT '2')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, sum(b)\nFROM (VALUES (1, 10), (1, 20)) t(a, b)\nGROUP BY AUTO, ROLLUP(b)\n"))).matches("VALUES (1, BIGINT '10'), (1, BIGINT '20'), (1, BIGINT '30')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, sum(b)\nFROM (VALUES (1, 10), (1, 20)) t(a, b)\nGROUP BY ALL AUTO, ROLLUP(b)\n"))).matches("VALUES (1, BIGINT '10'), (1, BIGINT '20'), (1, BIGINT '30')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, sum(b)\nFROM (VALUES (1, 10), (1, 20)) t(a, b)\nGROUP BY DISTINCT AUTO, ROLLUP(a)\n"))).matches("VALUES (1, BIGINT '30')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, b, c, sum(b)\nFROM (VALUES (1, 1, 1, 1), (1, 1, 1, 2), (2, 2, 2, 3)) t(a, b, c, d)\nGROUP BY AUTO, ROLLUP(a)\n"))).matches("SELECT a, b, c, sum(b)\nFROM (VALUES (1, 1, 1, 1), (1, 1, 1, 2), (2, 2, 2, 3)) t(a, b, c, d)\nGROUP BY (a, b, c), ROLLUP(a)\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, sum(b)\nFROM (VALUES (1, 10), (1, 20)) t(a, b)\nGROUP BY AUTO, CUBE(b)\n"))).matches("VALUES (1, BIGINT '10'), (1, BIGINT '20'), (1, BIGINT '30')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, sum(b)\nFROM (VALUES (1, 10), (1, 20)) t(a, b)\nGROUP BY ALL AUTO, CUBE(b)\n"))).matches("VALUES (1, BIGINT '10'), (1, BIGINT '20'), (1, BIGINT '30')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, sum(b)\nFROM (VALUES (1, 10), (1, 20)) t(a, b)\nGROUP BY DISTINCT AUTO, CUBE(a)\n"))).matches("VALUES (1, BIGINT '30')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, b, c, sum(b)\nFROM (VALUES (1, 1, 1, 1), (1, 1, 1, 2), (2, 2, 2, 3)) t(a, b, c, d)\nGROUP BY AUTO, CUBE(a)\n"))).matches("SELECT a, b, c, sum(b)\nFROM (VALUES (1, 1, 1, 1), (1, 1, 1, 2), (2, 2, 2, 3)) t(a, b, c, d)\nGROUP BY (a, b, c), CUBE(a)\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, sum(b)\nFROM (VALUES (1, 10), (1, 20)) t(a, b)\nGROUP BY AUTO, GROUPING SETS((b))\n"))).matches("VALUES (1, BIGINT '10'), (1, BIGINT '20')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, sum(b)\nFROM (VALUES (1, 10), (1, 20)) t(a, b)\nGROUP BY ALL AUTO, GROUPING SETS((b))\n"))).matches("VALUES (1, BIGINT '10'), (1, BIGINT '20')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, sum(b)\nFROM (VALUES (1, 10), (1, 20)) t(a, b)\nGROUP BY DISTINCT AUTO, GROUPING SETS((a))\n"))).matches("VALUES (1, BIGINT '30')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, b, c, sum(b)\nFROM (VALUES (1, 1, 1, 1), (1, 1, 1, 2), (2, 2, 2, 3)) t(a, b, c, d)\nGROUP BY AUTO, GROUPING SETS((a))\n"))).matches("SELECT a, b, c, sum(b)\nFROM (VALUES (1, 1, 1, 1), (1, 1, 1, 2), (2, 2, 2, 3)) t(a, b, c, d)\nGROUP BY (a, b, c), GROUPING SETS((a))\n");
    }
}

