/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.io.BaseEncoding;
import io.trino.Session;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.query.QueryAssertions;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestJsonTable {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testSimple() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT first, last\n FROM (SELECT '{\"a\" : [1, 2, 3], \"b\" : [4, 5, 6]}') t(json_col), JSON_TABLE(\n     json_col,\n     'lax $.a'\n     COLUMNS(\n         first bigint PATH 'lax $[0]',\n         last bigint PATH 'lax $[last]'))\n"))).matches("VALUES (BIGINT '1', BIGINT '3')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM\n     (SELECT '{\"a\" : {\"b\" : [1, 2, 3], \"c\" : [[4, 5, 6], [7, 8, 9]]}}') t(json_col),\n     JSON_TABLE(\n         json_col,\n         'lax $.a' AS \"path_a\"\n         COLUMNS(\n             NESTED PATH 'lax $.b[*]' AS \"path_b\"\n                     COLUMNS (c1 integer PATH 'lax $ * 10'),\n             NESTED PATH 'lax $.c' AS \"path_c\"\n                     COLUMNS (\n                         NESTED PATH 'lax $[0][*]' AS \"path_d\" COLUMNS (c2 integer PATH 'lax $ * 100'),\n                         NESTED PATH 'lax $[last][*]' AS \"path_e\" COLUMNS (c3 integer PATH 'lax $ * 1000')))\n         PLAN (\"path_a\" OUTER (\"path_b\" UNION (\"path_c\" INNER (\"path_d\" CROSS \"path_e\")))))\n"))).matches("VALUES\n    ('{\"a\" : {\"b\" : [1, 2, 3], \"c\" : [[4, 5, 6], [7, 8, 9]]}}', 10, CAST(null AS integer), CAST(null AS integer)),\n    ('{\"a\" : {\"b\" : [1, 2, 3], \"c\" : [[4, 5, 6], [7, 8, 9]]}}', 20, null, null),\n    ('{\"a\" : {\"b\" : [1, 2, 3], \"c\" : [[4, 5, 6], [7, 8, 9]]}}', 30, null, null),\n    ('{\"a\" : {\"b\" : [1, 2, 3], \"c\" : [[4, 5, 6], [7, 8, 9]]}}', null, 400, 7000),\n    ('{\"a\" : {\"b\" : [1, 2, 3], \"c\" : [[4, 5, 6], [7, 8, 9]]}}', null, 400, 8000),\n    ('{\"a\" : {\"b\" : [1, 2, 3], \"c\" : [[4, 5, 6], [7, 8, 9]]}}', null, 400, 9000),\n    ('{\"a\" : {\"b\" : [1, 2, 3], \"c\" : [[4, 5, 6], [7, 8, 9]]}}', null, 500, 7000),\n    ('{\"a\" : {\"b\" : [1, 2, 3], \"c\" : [[4, 5, 6], [7, 8, 9]]}}', null, 500, 8000),\n    ('{\"a\" : {\"b\" : [1, 2, 3], \"c\" : [[4, 5, 6], [7, 8, 9]]}}', null, 500, 9000),\n    ('{\"a\" : {\"b\" : [1, 2, 3], \"c\" : [[4, 5, 6], [7, 8, 9]]}}', null, 600, 7000),\n    ('{\"a\" : {\"b\" : [1, 2, 3], \"c\" : [[4, 5, 6], [7, 8, 9]]}}', null, 600, 8000),\n    ('{\"a\" : {\"b\" : [1, 2, 3], \"c\" : [[4, 5, 6], [7, 8, 9]]}}', null, 600, 9000)\n");
    }

    @Test
    public void testSubqueries() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT empty_default, error_default\n FROM (SELECT '[[1, 2, 3], [4, 5, 6]]') t(json_col), JSON_TABLE(\n     (SELECT json_col),\n     'lax $[$index]' PASSING (SELECT 0) AS \"index\"\n     COLUMNS(\n         empty_default bigint PATH 'lax $[-42]' DEFAULT (SELECT -42) ON EMPTY,\n         error_default bigint PATH 'strict $[42]' DEFAULT (SELECT 42) ON ERROR))\n"))).matches("VALUES (BIGINT '-42', BIGINT '42')");
    }

    @Test
    public void testCorrelation() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT empty_default, error_default\n FROM (SELECT '[[1, 2, 3], [4, 5, 6]]', 0, -42, 42) t(json_col, index_col, empty_default_col, error_default_col),\n JSON_TABLE(\n     json_col,\n     'lax $[$index]' PASSING index_col AS \"index\"\n     COLUMNS(\n         empty_default bigint PATH 'lax $[-42]' DEFAULT empty_default_col ON EMPTY,\n         error_default bigint PATH 'strict $[42]' DEFAULT error_default_col ON ERROR))\n"))).matches("VALUES (BIGINT '-42', BIGINT '42')");
    }

    @Test
    public void testParameters() {
        Session session = Session.builder((Session)this.assertions.getDefaultSession()).addPreparedStatement("my_query", "SELECT empty_default, error_default\nFROM JSON_TABLE(\n    ?,\n    'lax $[$index]' PASSING ? AS \"index\"\n    COLUMNS(\n        empty_default bigint PATH 'lax $[-42]' DEFAULT ? ON EMPTY,\n        error_default bigint PATH 'strict $[42]' DEFAULT ? ON ERROR))\n").build();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(session, "EXECUTE my_query USING '[[1, 2, 3], [4, 5, 6]]', 0, -42, 42"))).matches("VALUES (BIGINT '-42', BIGINT '42')");
    }

    @Test
    public void testOutputLayout() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM (SELECT '[[1, 2, 3], [4, 5, 6]]', 0, -42, 42) t(json_col, index_col, empty_default_col, error_default_col),\n JSON_TABLE(\n     json_col,\n     'lax $[$index]' PASSING index_col AS \"index\"\n     COLUMNS(\n         empty_default bigint PATH 'lax $[-42]' DEFAULT empty_default_col * 2 ON EMPTY,\n         error_default bigint PATH 'strict $[42]' DEFAULT error_default_col * 2 ON ERROR))\n"))).matches("VALUES ('[[1, 2, 3], [4, 5, 6]]', 0, -42, 42, BIGINT '-84', BIGINT '84')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n        '[]',\n        'lax $' AS \"p\"\n        COLUMNS(\n            a varchar(1) PATH 'lax \"A\"',\n            NESTED PATH 'lax $' AS \"p1\"\n                    COLUMNS (\n                        b varchar(1) PATH 'lax \"B\"',\n                        NESTED PATH 'lax $' AS \"p2 \"COLUMNS (\n                                                c varchar(1) PATH 'lax \"C\"',\n                                                d varchar(1) PATH 'lax \"D\"'),\n                        e varchar(1) PATH 'lax \"E\"'),\n            f varchar(1) PATH 'lax \"F\"',\n            NESTED PATH 'lax $' AS \"p3\"\n                     COLUMNS (g varchar(1) PATH 'lax \"G\"'),\n            h varchar(1) PATH 'lax \"H\"')\n        PLAN DEFAULT (CROSS))\n"))).matches("VALUES ('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H')");
    }

    @Test
    public void testJoinTypes() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM (VALUES ('[1, 2, 3]'), ('[4, 5, 6, 7, 8]')) t(json_col),\n JSON_TABLE(\n     json_col,\n     'lax $[4]'\n     COLUMNS(a integer PATH 'lax $'))\n"))).matches("VALUES ('[4, 5, 6, 7, 8]', 8)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM (VALUES ('[1, 2, 3]'), ('[4, 5, 6, 7, 8]')) t(json_col)\n INNER JOIN\n JSON_TABLE(\n     json_col,\n     'lax $[4]'\n     COLUMNS(a integer PATH 'lax $'))\nON TRUE\n"))).matches("VALUES ('[4, 5, 6, 7, 8]', 8)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM (VALUES ('[1, 2, 3]'), ('[4, 5, 6, 7, 8]')) t(json_col)\n LEFT JOIN\n JSON_TABLE(\n     json_col,\n     'lax $[4]'\n     COLUMNS(a integer PATH 'lax $'))\nON TRUE\n"))).matches("VALUES\n    ('[1, 2, 3]', CAST(null AS integer)),\n    ('[4, 5, 6, 7, 8]', 8)\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM (VALUES 1) t(x)\n RIGHT JOIN\n JSON_TABLE(\n     '[1, 2, 3]',\n     'lax $[4]'\n     COLUMNS(a integer PATH 'lax $'))\nON TRUE\n"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM (VALUES 1) t(x)\n FULL JOIN\n JSON_TABLE(\n     '[1, 2, 3]',\n     'lax $[4]'\n     COLUMNS(a integer PATH 'lax $'))\nON TRUE\n"))).matches("VALUES (1, CAST(null AS integer))");
    }

    @Test
    public void testParentChildRelationship() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n        '[]',\n        'lax $' AS \"root_path\"\n        COLUMNS(\n            a varchar(1) PATH 'lax \"A\"',\n            NESTED PATH 'lax $[*]' AS \"nested_path\"\n                    COLUMNS (b varchar(1) PATH 'lax \"B\"'))\n        PLAN (\"root_path\" OUTER \"nested_path\"))\n"))).matches("VALUES ('A', CAST(null AS varchar(1)))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n        '[]',\n        'lax $' AS \"root_path\"\n        COLUMNS(\n            a varchar(1) PATH 'lax \"A\"',\n            NESTED PATH 'lax $[*]' AS \"nested_path\"\n                    COLUMNS (b varchar(1) PATH 'lax \"B\"'))\n        PLAN (\"root_path\" INNER \"nested_path\"))\n"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n        '[[], [1]]',\n        'lax $' AS \"root_path\"\n        COLUMNS(\n            a varchar(1) PATH 'lax \"A\"',\n            NESTED PATH 'lax $[*]' AS \"nested_path_1\"\n                    COLUMNS (\n                        b varchar(1) PATH 'lax \"B\"',\n                        NESTED PATH 'lax $[*]' AS \"nested_path_2\"\n                                COLUMNS(\n                                    c varchar(1) PATH 'lax \"C\"')))\n        PLAN (\"root_path\" OUTER (\"nested_path_1\" OUTER \"nested_path_2\")))\n"))).matches("VALUES\n    ('A', 'B', CAST(null AS varchar(1))),\n    ('A', 'B', 'C')\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n        '[[], [1]]',\n        'lax $' AS \"root_path\"\n        COLUMNS(\n            a varchar(1) PATH 'lax \"A\"',\n            NESTED PATH 'lax $[*]' AS \"nested_path_1\"\n                    COLUMNS (\n                        b varchar(1) PATH 'lax \"B\"',\n                        NESTED PATH 'lax $[*]' AS \"nested_path_2\"\n                                COLUMNS(\n                                    c varchar(1) PATH 'lax \"C\"')))\n        PLAN (\"root_path\" OUTER (\"nested_path_1\" INNER \"nested_path_2\")))\n"))).matches("VALUES ('A', 'B', 'C')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n        '[]',\n        'lax $' AS \"root_path\"\n        COLUMNS(\n            a varchar(1) PATH 'lax \"A\"',\n            NESTED PATH 'lax $[*]' AS \"nested_path_1\"\n                    COLUMNS (\n                        b varchar(1) PATH 'lax \"B\"',\n                        NESTED PATH 'lax $' AS \"nested_path_2\"\n                                COLUMNS(\n                                    c varchar(1) PATH 'lax \"C\"')))\n        PLAN (\"root_path\" OUTER (\"nested_path_1\" INNER \"nested_path_2\")))\n"))).matches("VALUES ('A', CAST(null AS varchar(1)), CAST(null AS varchar(1)))");
    }

    @Test
    public void testSiblingsRelationship() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n        '[]',\n        'lax $' AS \"root_path\"\n        COLUMNS(\n            a varchar(1) PATH 'lax \"A\"',\n            NESTED PATH 'lax $' AS \"nested_path_b\"\n                    COLUMNS (b varchar(1) PATH 'lax \"B\"'),\n            NESTED PATH 'lax $' AS \"nested_path_c\"\n                    COLUMNS (c varchar(1) PATH 'lax \"C\"'),\n            NESTED PATH 'lax $' AS \"nested_path_d\"\n                    COLUMNS (d varchar(1) PATH 'lax \"D\"'))\n        PLAN (\"root_path\" INNER (\"nested_path_c\" UNION (\"nested_path_d\" CROSS \"nested_path_b\"))))\n"))).matches("VALUES\n    ('A', CAST(null AS varchar(1)), 'C', CAST(null AS varchar(1))),\n    ('A', 'B', CAST(null AS varchar(1)), 'D')\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n        '[10, 1000]',\n        'lax $' AS \"root_path\"\n        COLUMNS(\n            a varchar(1) PATH 'lax \"A\"',\n            NESTED PATH 'lax $[*]' AS \"nested_path_1\"\n                    COLUMNS (b integer PATH 'lax $ * 1'),\n            NESTED PATH 'lax $[*]' AS \"nested_path_2\"\n                    COLUMNS (c integer PATH 'lax $ * 2'),\n            NESTED PATH 'lax $[*]' AS \"nested_path_3\"\n                    COLUMNS (d integer PATH 'lax $ * 3'))\n        PLAN (\"root_path\" INNER (\"nested_path_2\" UNION (\"nested_path_3\" CROSS \"nested_path_1\"))))\n"))).matches("VALUES\n    ('A', CAST(null AS integer),    20,     CAST(null AS integer)),\n    ('A', null,                     2000,   null),\n    ('A', 10,                       null,   30),\n    ('A', 10,                       null,   3000),\n    ('A', 1000,                     null,   30),\n    ('A', 1000,                     null,   3000)\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n        '[10, 1000]',\n        'lax $' AS \"root_path\"\n        COLUMNS(\n            a varchar(1) PATH 'lax \"A\"',\n            NESTED PATH 'lax $[*]' AS \"nested_path_1\"\n                    COLUMNS (b integer PATH 'lax $ * 1'),\n            NESTED PATH 'lax $[42]' AS \"nested_path_2\"\n                    COLUMNS (c integer PATH 'lax $ * 2'))\n        PLAN (\"root_path\" INNER (\"nested_path_1\" CROSS \"nested_path_2\")))\n"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n        '[10, 1000]',\n        'lax $' AS \"root_path\"\n        COLUMNS(\n            a varchar(1) PATH 'lax \"A\"',\n            NESTED PATH 'lax $[*]' AS \"nested_path_1\"\n                    COLUMNS (b integer PATH 'lax $ * 1'),\n            NESTED PATH 'lax $[42]' AS \"nested_path_2\"\n                    COLUMNS (c integer PATH 'lax $ * 2'))\n        PLAN (\"root_path\" INNER (\"nested_path_1\" UNION \"nested_path_2\")))\n"))).matches("VALUES\n    ('A', 10,   CAST(null AS integer)),\n    ('A', 1000, null)\n");
    }

    @Test
    public void testImplicitColumnPath() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n     '{\"A\" : 42, \"b\" : true}',\n     'lax $'\n     COLUMNS(\n        a integer,\n        \"b\" boolean))\n"))).matches("VALUES (42, true)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n     '{\"A\" : 42, \"b\" : true}',\n     'lax $'\n     COLUMNS(c varchar (5) DEFAULT 'empty' ON EMPTY DEFAULT 'error' ON ERROR))\n"))).matches("VALUES 'empty'");
    }

    @Test
    public void testRootPathErrorHandling() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n     '[]',\n     'strict $[42]'\n     COLUMNS(a integer PATH 'lax 1')\n     EMPTY ON ERROR)\n"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n     '[]',\n     'strict $[42]'\n     COLUMNS(a integer PATH 'lax 1'))\n"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n     '[]',\n     'strict $[42]'\n     COLUMNS(a integer PATH 'lax 1')\n     ERROR ON ERROR)\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.PATH_EVALUATION_ERROR}).hasMessage("path evaluation failed: structural error: invalid array subscript for empty array");
    }

    @Test
    public void testNestedPathErrorHandling() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n     '[]',\n     'lax $' AS \"root_path\"\n     COLUMNS(\n        a integer PATH 'lax 1',\n        NESTED PATH 'strict $[42]' AS \"nested_path\"\n            COLUMNS(b integer PATH 'lax 2'))\n     PLAN DEFAULT(INNER)\n     EMPTY ON ERROR)\n"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n     '[]',\n     'lax $' AS \"root_path\"\n     COLUMNS(\n        a integer PATH 'lax 1',\n        NESTED PATH 'strict $[42]' AS \"nested_path\"\n            COLUMNS(b integer PATH 'lax 2'))\n     PLAN DEFAULT(INNER))\n"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n     '[]',\n     'lax $' AS \"root_path\"\n     COLUMNS(\n        a integer PATH 'lax 1',\n        NESTED PATH 'strict $[42]' AS \"nested_path\"\n            COLUMNS(b integer PATH 'lax 2'))\n     PLAN DEFAULT(INNER)\n     ERROR ON ERROR)\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.PATH_EVALUATION_ERROR}).hasMessage("path evaluation failed: structural error: invalid array subscript for empty array");
    }

    @Test
    public void testColumnPathErrorHandling() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n     '[]',\n     'lax $'\n     COLUMNS(a integer PATH 'strict $[42]' ERROR ON ERROR)\n     EMPTY ON ERROR)\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.PATH_EVALUATION_ERROR}).hasMessage("path evaluation failed: structural error: invalid array subscript for empty array");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n     '[]',\n     'lax $'\n     COLUMNS(a integer PATH 'strict $[42]')\n     EMPTY ON ERROR)\n"))).matches("VALUES CAST(null as integer)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n     '[]',\n     'lax $'\n     COLUMNS(a integer PATH 'strict $[42]')\n     ERROR ON ERROR)\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.PATH_EVALUATION_ERROR}).hasMessage("path evaluation failed: structural error: invalid array subscript for empty array");
    }

    @Test
    public void testEmptyInput() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM (SELECT '[]' WHERE rand() > 1) t(json_col),\n JSON_TABLE(\n     json_col,\n     'lax $'\n     COLUMNS(a integer PATH 'lax 1'))\n"))).returnsEmptyResult();
    }

    @Test
    public void testNullInput() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n     CAST (null AS varchar),\n     'lax $'\n     COLUMNS(a integer PATH 'lax 1'))\n"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM (VALUES (CAST(null AS varchar)), (CAST(null AS varchar)), (CAST(null AS varchar))) t(json_col),\n JSON_TABLE(\n     json_col,\n     'lax $'\n     COLUMNS(a integer PATH 'lax 1'))\n"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM (VALUES (CAST(null AS varchar)), (CAST(null AS varchar)), (CAST(null AS varchar))) t(json_col),\n JSON_TABLE(\n     json_col,\n     'lax $'\n     COLUMNS(\n        NESTED PATH 'lax $'\n            COLUMNS(a integer PATH 'lax 1')))\n"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n     CAST (null AS varchar) FORMAT JSON,\n     'lax $'\n     COLUMNS(a varchar FORMAT JSON PATH 'lax $'))\n"))).returnsEmptyResult();
    }

    @Test
    public void testNullPathParameter() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM (SELECT '[1, 2, 3]', CAST(null AS integer)) t(json_col, index_col),\n JSON_TABLE(\n     json_col,\n     'lax $[$index]' PASSING index_col AS \"index\"\n     COLUMNS(a integer PATH 'lax 1')\n     ERROR ON ERROR)\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.PATH_EVALUATION_ERROR}).hasMessage("path evaluation failed: invalid item type. Expected: NUMBER, actual: NULL");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM (SELECT '[1, 2, 3]', CAST(null AS varchar)) t(json_col, index_col),\n JSON_TABLE(\n     json_col,\n     'lax $[$index]' PASSING index_col FORMAT JSON AS \"index\"\n     COLUMNS(a integer PATH 'lax 1')\n     ERROR ON ERROR)\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.PATH_EVALUATION_ERROR}).hasMessage("path evaluation failed: array subscript 'from' value must be singleton numeric");
    }

    @Test
    public void testNullDefaultValue() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT a\n FROM (SELECT null) t(empty_default),\n JSON_TABLE(\n     '[1, 2, 3]',\n     'lax $'\n     COLUMNS(a integer PATH 'lax $[42]' DEFAULT empty_default ON EMPTY DEFAULT -1 ON ERROR))\n"))).matches("VALUES CAST(null AS integer)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT a\n FROM (SELECT null) t(error_default),\n JSON_TABLE(\n     '[1, 2, 3]',\n     'lax $'\n     COLUMNS(a integer PATH 'strict $[42]' DEFAULT -1 ON EMPTY DEFAULT error_default ON ERROR))\n"))).matches("VALUES CAST(null AS integer)");
    }

    @Test
    public void testValueColumnCoercion() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n        '[1, 2, 3]',\n        'lax $'\n        COLUMNS(a real PATH 'lax $[last]'))\n"))).matches("VALUES REAL '3'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n        '[1, 2, 3]',\n        'lax $'\n        COLUMNS(a real PATH 'lax $[42]' DEFAULT 42 ON EMPTY))\n"))).matches("VALUES REAL '42'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n        '[1, 2, 3]',\n        'lax $'\n        COLUMNS(a real PATH 'lax $[42]'))\n"))).matches("VALUES CAST(null AS REAL)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n        '[1, 2, 3]',\n        'lax $'\n        COLUMNS(a real PATH 'strict $[42]' DEFAULT 42 ON ERROR))\n"))).matches("VALUES REAL '42'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n        '[1, 2, 3]',\n        'lax $'\n        COLUMNS(a real PATH 'strict $[42]'))\n"))).matches("VALUES CAST(null AS REAL)");
    }

    @Test
    public void testQueryColumnFormat() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n        '[{\"a\" : true}]',\n        'lax $'\n        COLUMNS(a varchar(50) FORMAT JSON PATH 'lax $[0]'))\n"))).matches("VALUES CAST('{\"a\":true}' AS VARCHAR(50))");
        String varbinaryLiteral = "X'" + BaseEncoding.base16().encode("{\"a\":true}".getBytes(StandardCharsets.UTF_16LE)) + "'";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n        '[{\"a\" : true}]',\n        'lax $'\n        COLUMNS(a varbinary FORMAT JSON ENCODING UTF16 PATH 'lax $[0]'))\n"))).matches("VALUES " + varbinaryLiteral);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n        '[{\"a\" : true}]',\n        'lax $'\n        COLUMNS(a char(50) FORMAT JSON PATH 'lax $[42]' EMPTY OBJECT ON EMPTY))\n"))).matches("VALUES CAST('{}' AS CHAR(50))");
        varbinaryLiteral = "X'" + BaseEncoding.base16().encode("[]".getBytes(StandardCharsets.UTF_16LE)) + "'";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n        '[{\"a\" : true}]',\n        'lax $'\n        COLUMNS(a varbinary FORMAT JSON ENCODING UTF16 PATH 'strict $[42]' EMPTY ARRAY ON ERROR))\n"))).matches("VALUES " + varbinaryLiteral);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n        '[{\"a\" : true}]',\n        'lax $'\n        COLUMNS(a varbinary FORMAT JSON ENCODING UTF16 PATH 'lax $[42]' NULL ON EMPTY))\n"))).matches("VALUES CAST(null AS VARBINARY)");
    }

    @Test
    public void testOrdinalityColumn() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM JSON_TABLE(\n        '[\"a\", \"b\", \"c\", \"d\", \"e\", \"f\", \"g\", \"h\"]',\n        'lax $[*]' AS \"root_path\"\n        COLUMNS(\n            o FOR ORDINALITY,\n            x varchar(1) PATH 'lax $'))\n"))).matches("VALUES\n    (BIGINT '1', 'a'),\n            (2,  'b'),\n            (3,  'c'),\n            (4,  'd'),\n            (5,  'e'),\n            (6,  'f'),\n            (7,  'g'),\n            (8,  'h')\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(" SELECT *\n FROM (VALUES\n        ('[[\"a\", \"b\"], [\"c\", \"d\"], [\"e\", \"f\"]]'),\n        ('[[\"g\", \"h\"], [\"i\", \"j\"], [\"k\", \"l\"]]')) t(json_col),\n JSON_TABLE(\n        json_col,\n        'lax $' AS \"root_path\"\n        COLUMNS(\n            o FOR ORDINALITY,\n            NESTED PATH 'lax $[0][*]' AS \"nested_path_1\"\n                    COLUMNS (\n                        x1 varchar PATH 'lax $',\n                        o1 FOR ORDINALITY),\n            NESTED PATH 'lax $[1][*]' AS \"nested_path_2\"\n                    COLUMNS (\n                        x2 varchar PATH 'lax $',\n                        o2 FOR ORDINALITY),\n            NESTED PATH 'lax $[2][*]' AS \"nested_path_3\"\n                    COLUMNS (\n                        x3 varchar PATH 'lax $',\n                        o3 FOR ORDINALITY))\n        PLAN (\"root_path\" INNER (\"nested_path_2\" UNION (\"nested_path_3\" CROSS \"nested_path_1\"))))\n"))).matches("VALUES\n    ('[[\"a\", \"b\"], [\"c\", \"d\"], [\"e\", \"f\"]]', BIGINT '1', VARCHAR 'a', BIGINT '1', CAST(null AS varchar), CAST(null AS bigint), VARCHAR 'e', BIGINT '1'),\n    ('[[\"a\", \"b\"], [\"c\", \"d\"], [\"e\", \"f\"]]',         1,          'a',         1,                   null,                 null,         'f',         2),\n    ('[[\"a\", \"b\"], [\"c\", \"d\"], [\"e\", \"f\"]]',         1,          'b',         2,                   null,                 null,         'e',         1),\n    ('[[\"a\", \"b\"], [\"c\", \"d\"], [\"e\", \"f\"]]',         1,          'b',         2,                   null,                 null,         'f',         2),\n    ('[[\"a\", \"b\"], [\"c\", \"d\"], [\"e\", \"f\"]]',         1,         null,      null,                    'c',                    1,        null,      null),\n    ('[[\"a\", \"b\"], [\"c\", \"d\"], [\"e\", \"f\"]]',         1,         null,      null,                    'd',                    2,        null,      null),\n\n    ('[[\"g\", \"h\"], [\"i\", \"j\"], [\"k\", \"l\"]]',         1,  VARCHAR 'g', BIGINT '1', CAST(null AS varchar), CAST(null AS bigint), VARCHAR 'k', BIGINT '1'),\n    ('[[\"g\", \"h\"], [\"i\", \"j\"], [\"k\", \"l\"]]',         1,          'g',         1,                   null,                 null,         'l',         2),\n    ('[[\"g\", \"h\"], [\"i\", \"j\"], [\"k\", \"l\"]]',         1,          'h',         2,                   null,                 null,         'k',         1),\n    ('[[\"g\", \"h\"], [\"i\", \"j\"], [\"k\", \"l\"]]',         1,          'h',         2,                   null,                 null,         'l',         2),\n    ('[[\"g\", \"h\"], [\"i\", \"j\"], [\"k\", \"l\"]]',         1,         null,      null,                    'i',                    1,        null,      null),\n    ('[[\"g\", \"h\"], [\"i\", \"j\"], [\"k\", \"l\"]]',         1,         null,      null,                    'j',                    2,        null,      null)\n");
    }
}

