/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestSetOperations {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testExceptInSubquery() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH t(id) AS (VALUES 1, 2, 3) SELECT * FROM t WHERE id IN (    VALUES 1, 1, 2, 3    EXCEPT    VALUES 1)"))).matches("VALUES 2, 3");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH t(id) AS (VALUES 1, 2, 3) SELECT * FROM t WHERE id IN (    VALUES 1, 1, 2, 2, 3    EXCEPT ALL    VALUES 1, 2, 2)"))).matches("VALUES 1, 3");
    }

    @Test
    public void testIntersectInSubquery() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH t(id) AS (VALUES 1, 2, 3) SELECT * FROM t WHERE id IN (    VALUES 1, 1, 2    INTERSECT    VALUES 2, 3)"))).matches("VALUES 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH t(id) AS (VALUES 1, 2, 3) SELECT * FROM t WHERE id IN (    VALUES 1, 1, 2    INTERSECT ALL    VALUES 2, 3)"))).matches("VALUES 2");
    }

    @Test
    public void testUnionInSubquery() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH t(id) AS (VALUES 1, 2, 3, 4) SELECT * FROM t WHERE id IN (    VALUES 1, 2    UNION    VALUES 2, 3)"))).matches("VALUES 1, 2, 3");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH t(id) AS (VALUES 1, 2, 3, 4) SELECT * FROM t WHERE id IN (    VALUES 1, 2    UNION ALL    VALUES 2, 3)"))).matches("VALUES 1, 2, 3");
    }

    @Test
    public void testUnionAllVsDistinctInSubquery() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (    SELECT array_agg(v ORDER BY v) FROM (        VALUES 1, 2, 3        UNION        VALUES 3, 4    ) t(v)),    (    SELECT array_agg(v ORDER BY v) FROM (        VALUES 1, 2, 3        UNION ALL        VALUES 3, 4    ) t(v))"))).matches("VALUES (ARRAY[1, 2, 3, 4], ARRAY[1, 2, 3, 3, 4])");
    }

    @Test
    public void testIntersectAllVsDistinctInSubquery() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (    SELECT array_agg(v ORDER BY v) FROM (        VALUES 1, 2, 3, 3        INTERSECT        VALUES 2, 2, 3, 3, 4    ) t(v)),    (    SELECT array_agg(v ORDER BY v) FROM (        VALUES 1, 2, 3, 3        INTERSECT ALL        VALUES 2, 2, 3, 3, 4    ) t(v))"))).matches("VALUES (ARRAY[2, 3], ARRAY[2, 3, 3])");
    }

    @Test
    public void testExceptAllVsDistinctInSubquery() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (    SELECT array_agg(v ORDER BY v) FROM (        VALUES 1, 1, 2, 2, 3, 3        EXCEPT        VALUES 2, 3, 3, 4    ) t(v)),    (    SELECT array_agg(v ORDER BY v) FROM (        VALUES 1, 1, 2, 2, 3, 3        EXCEPT ALL        VALUES 2, 3, 3, 4    ) t(v))"))).matches("VALUES (ARRAY[1], ARRAY[1, 1, 2])");
    }

    @Test
    public void testExceptWithEmptyBranches() {
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 0 WHERE false EXCEPT ALL SELECT 1 WHERE false EXCEPT ALL SELECT 2 WHERE false"))).describedAs("EXCEPT ALL with all empty branches", new Object[0])).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 0 WHERE false EXCEPT DISTINCT SELECT 1 WHERE false EXCEPT DISTINCT SELECT 2 WHERE false"))).describedAs("EXCEPT DISTINCT with all empty branches", new Object[0])).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES 1, 1, 2, 2, 3 EXCEPT ALL SELECT 1 WHERE false EXCEPT ALL SELECT 2 WHERE false"))).describedAs("EXCEPT ALL with empty subtractions", new Object[0])).matches("VALUES 1, 1, 2, 2, 3");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES 1, 1, 2, 2, 3 EXCEPT DISTINCT SELECT 1 WHERE false EXCEPT DISTINCT SELECT 2 WHERE false "))).describedAs("EXCEPT DISTINCT with empty subtractions", new Object[0])).matches("VALUES 1, 2, 3");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 WHERE false EXCEPT ALL VALUES 2, 3"))).describedAs("EXCEPT ALL with empty set", new Object[0])).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 WHERE false EXCEPT DISTINCT VALUES 2, 3"))).describedAs("EXCEPT DISTINCT with empty set", new Object[0])).returnsEmptyResult();
    }

    @Test
    public void testUnionWithEmptyBranches() {
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 0 WHERE false UNION ALL SELECT 0 WHERE false"))).describedAs("UNION ALL with all empty branches", new Object[0])).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 0 WHERE false UNION DISTINCT SELECT 0 WHERE false"))).describedAs("UNION DISTINCT with all empty branches", new Object[0])).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES 1, 1, 2, 2, 3 UNION ALL VALUES 1, 3, 3, 4 UNION ALL SELECT 0 WHERE false"))).describedAs("UNION ALL with empty branches", new Object[0])).matches("VALUES 1, 1, 1, 2, 2, 3, 3, 3, 4");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES 1, 1, 2, 2, 3 UNION DISTINCT VALUES 1, 3, 3, 4 UNION DISTINCT SELECT 0 WHERE false"))).describedAs("UNION DISTINCT with empty branches", new Object[0])).matches("VALUES 1, 2, 3, 4");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES 1, 1, 2, 2, 3 UNION DISTINCT SELECT 0 WHERE false UNION DISTINCT SELECT 0 WHERE false"))).describedAs("UNION DISTINCT with single non-empty branch", new Object[0])).matches("VALUES 1, 2, 3");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES 1, 1, 2, 2, 3 UNION ALL SELECT 0 WHERE false UNION ALL SELECT 0 WHERE false"))).describedAs("UNION ALL with single non-empty branch", new Object[0])).matches("VALUES 1, 1, 2, 2, 3");
    }

    @Test
    public void testIntersectWithEmptyBranches() {
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 0 WHERE false INTERSECT ALL SELECT 0 WHERE false"))).describedAs("INTERSECT ALL with all empty branches", new Object[0])).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 0 WHERE false INTERSECT DISTINCT SELECT 0 WHERE false"))).describedAs("INTERSECT DISTINCT with all empty branches", new Object[0])).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES 1, 1, 2, 2, 3 INTERSECT ALL SELECT 0 WHERE false"))).describedAs("INTERSECT ALL with empty branches", new Object[0])).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("VALUES 1, 1, 2, 2, 3 INTERSECT DISTINCT SELECT 0 WHERE false"))).describedAs("INTERSECT DISTINCT with empty branches", new Object[0])).returnsEmptyResult();
    }

    @Test
    void testExceptCorresponding() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES (1, 'alice'), (1, 'alice')) t(x, y)\nEXCEPT CORRESPONDING\nSELECT * FROM (VALUES ('alice', 1)) t(y, x)\n"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES (1, 'alice'), (1, 'alice')) t(x, y)\nEXCEPT ALL CORRESPONDING\nSELECT * FROM (VALUES ('alice', 1)) t(y, x)\n"))).matches("VALUES (1, 'alice')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1) t(x)\nEXCEPT CORRESPONDING\nSELECT * FROM (VALUES ('alice', 1)) t(y, x)\n"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES ('alice', 1)) t(y, x)\nEXCEPT CORRESPONDING\nSELECT * FROM (VALUES 1) t(x)\n"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES (1, 'alice')) t(X, Y)\nEXCEPT CORRESPONDING\nSELECT * FROM (VALUES ('alice', 1)) t(y, x)\n"))).returnsEmptyResult();
    }

    @Test
    void testUnionCorresponding() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES ('alice', 1), ('bob', 2)) t(y, x)\nUNION CORRESPONDING\nSELECT 1 AS x, 'alice' AS y\n"))).matches("VALUES ('alice', 1), ('bob', 2)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 AS x, 'alice' AS y\nUNION ALL CORRESPONDING\nSELECT * FROM (VALUES ('alice', 1), ('bob', 2)) t(y, x)\n"))).matches("VALUES (1, 'alice'), (1, 'alice'), (2, 'bob')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES ('alice', 1), ('bob', 2)) t(y, x)\nUNION ALL CORRESPONDING\nSELECT 3 AS x\n"))).matches("VALUES 1, 2, 3");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 3 AS x\nUNION ALL CORRESPONDING\nSELECT * FROM (VALUES ('alice', 1), ('bob', 2)) t(y, x)\n"))).matches("VALUES 1, 2, 3");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES (1, 'alice')) t(X, Y)\nUNION ALL CORRESPONDING\nSELECT * FROM (VALUES ('bob', 2)) t(y, x)\n"))).matches("VALUES (1, 'alice'), (2, 'bob')");
    }

    @Test
    void testIntersectCorresponding() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES (1, 'alice'), (1, 'alice')) t(x, y)\nINTERSECT CORRESPONDING\nSELECT * FROM (VALUES ('alice', 1), ('alice', 1)) t(y, x)\n"))).matches("VALUES (1, 'alice')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES (1, 'alice'), (1, 'alice')) t(x, y)\nINTERSECT ALL CORRESPONDING\nSELECT * FROM (VALUES ('alice', 1), ('alice', 1)) t(y, x)\n"))).matches("VALUES (1, 'alice'), (1, 'alice')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES ('alice', 1), ('bob', 2)) t(y, x)\nINTERSECT ALL CORRESPONDING\nSELECT * FROM (VALUES 1) t(x)\n"))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1) t(x)\nINTERSECT ALL CORRESPONDING\nSELECT * FROM (VALUES ('alice', 1), ('bob', 2)) t(y, x)\n"))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES (1, 'alice'), (2, 'bob')) t(X, Y)\nINTERSECT ALL CORRESPONDING\nSELECT * FROM (VALUES ('alice', 1), ('carol', 3)) t(y, x)\n"))).matches("VALUES (1, 'alice')");
    }

    @Test
    void testCorrespondingDuplicateNames() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 AS x, 2 AS y EXCEPT CORRESPONDING SELECT 1 AS x, 2 AS X"))).failure().hasMessage("line 1:23: Duplicate columns found when using CORRESPONDING in set operations: x");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 AS x, 2 AS X EXCEPT CORRESPONDING SELECT 1 AS y, 2 AS x"))).failure().hasMessage("line 1:23: Duplicate columns found when using CORRESPONDING in set operations: x");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 AS x, 2 AS y UNION CORRESPONDING SELECT 1 AS x, 2 AS X"))).failure().hasMessage("line 1:23: Duplicate columns found when using CORRESPONDING in set operations: x");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 AS x, 2 AS X UNION CORRESPONDING SELECT 1 AS x, 2 AS y"))).failure().hasMessage("line 1:23: Duplicate columns found when using CORRESPONDING in set operations: x");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 AS x, 2 AS y INTERSECT CORRESPONDING SELECT 1 AS x, 2 AS X"))).failure().hasMessage("line 1:23: Duplicate columns found when using CORRESPONDING in set operations: x");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 AS X, 2 AS x INTERSECT CORRESPONDING SELECT 1 AS x, 2 AS y"))).failure().hasMessage("line 1:23: Duplicate columns found when using CORRESPONDING in set operations: x");
    }

    @Test
    void testCorrespondingUnsupportedColumnNames() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 AS x EXCEPT CORRESPONDING BY (x) SELECT 2 AS x"))).failure().hasMessage("line 1:15: CORRESPONDING with columns is unsupported");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 AS x UNION CORRESPONDING BY (x) SELECT 2 AS x"))).failure().hasMessage("line 1:15: CORRESPONDING with columns is unsupported");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 AS x INTERSECT CORRESPONDING BY (x) SELECT 2 AS x"))).failure().hasMessage("line 1:15: CORRESPONDING with columns is unsupported");
    }

    @Test
    void testCorrespondingNameMismatch() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 AS x EXCEPT CORRESPONDING SELECT 2 AS y"))).failure().hasMessage("line 1:15: No corresponding columns");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 AS x UNION CORRESPONDING SELECT 2 AS y"))).failure().hasMessage("line 1:15: No corresponding columns");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 AS x INTERSECT CORRESPONDING SELECT 2 AS y"))).failure().hasMessage("line 1:15: No corresponding columns");
    }

    @Test
    void testCorrespondingWithAnonymousColumn() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 EXCEPT CORRESPONDING SELECT 2 AS x"))).failure().hasMessage("line 1:10: Anonymous columns are not allowed in set operations with CORRESPONDING");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 AS x EXCEPT CORRESPONDING SELECT 2"))).failure().hasMessage("line 1:15: Anonymous columns are not allowed in set operations with CORRESPONDING");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 UNION CORRESPONDING SELECT 2 AS x"))).failure().hasMessage("line 1:10: Anonymous columns are not allowed in set operations with CORRESPONDING");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 AS x UNION CORRESPONDING SELECT 2"))).failure().hasMessage("line 1:15: Anonymous columns are not allowed in set operations with CORRESPONDING");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 INTERSECT CORRESPONDING SELECT 2 AS x"))).failure().hasMessage("line 1:10: Anonymous columns are not allowed in set operations with CORRESPONDING");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 AS x INTERSECT CORRESPONDING SELECT 2"))).failure().hasMessage("line 1:15: Anonymous columns are not allowed in set operations with CORRESPONDING");
    }
}

