/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.DateTimeTestingUtils;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.type.JsonType;
import io.trino.util.StructuralTestUtil;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestJsonOperators {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testCastToBigint() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "JSON 'null'")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "JSON '128'")))).isEqualTo(128L);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as BIGINT)").binding("a", "JSON '12345678901234567890'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "JSON '128.9'")))).isEqualTo(129L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "JSON '1234567890123456789.0'")))).isEqualTo(1234567890123456768L);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as BIGINT)").binding("a", "JSON '12345678901234567890.0'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "JSON '1e-324'")))).isEqualTo(0L);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as BIGINT)").binding("a", "JSON '1e309'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "JSON 'true'")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "JSON 'false'")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "JSON '\"128\"'")))).isEqualTo(128L);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as BIGINT)").binding("a", "JSON '\"12345678901234567890\"'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as BIGINT)").binding("a", "JSON '\"128.9\"'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as BIGINT)").binding("a", "JSON '\"true\"'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as BIGINT)").binding("a", "JSON '\"false\"'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "JSON ' 128'")))).isEqualTo(128L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "json_extract('{\"x\":999}', '$.x')")))).isEqualTo(999L);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as BIGINT)").binding("a", "JSON '{ \"x\" : 123}'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testCastToInteger() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "JSON 'null'")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "JSON '128'")))).isEqualTo(128);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as INTEGER)").binding("a", "JSON '12345678901'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "JSON '128.9'")))).isEqualTo(129);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as INTEGER)").binding("a", "JSON '12345678901.0'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "JSON '1e-324'")))).isEqualTo(0);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as INTEGER)").binding("a", "JSON '1e309'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "JSON 'true'")))).isEqualTo(1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "JSON 'false'")))).isEqualTo(0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "JSON '\"128\"'")))).isEqualTo(128);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as INTEGER)").binding("a", "JSON '\"12345678901234567890\"'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as INTEGER)").binding("a", "JSON '\"128.9\"'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as INTEGER)").binding("a", "JSON '\"true\"'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as INTEGER)").binding("a", "JSON '\"false\"'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "JSON ' 128'")))).isEqualTo(128);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "json_extract('{\"x\":999}', '$.x')")))).isEqualTo(999);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as INTEGER)").binding("a", "JSON '{ \"x\" : 123}'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testCastToSmallint() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "JSON 'null'")))).isNull((Type)SmallintType.SMALLINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "JSON '128'")))).isEqualTo((short)128);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as SMALLINT)").binding("a", "JSON '123456'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "JSON '128.9'")))).isEqualTo((short)129);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as SMALLINT)").binding("a", "JSON '123456.0'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "JSON '1e-324'")))).isEqualTo((short)0);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as SMALLINT)").binding("a", "JSON '1e309'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "JSON 'true'")))).isEqualTo((short)1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "JSON 'false'")))).isEqualTo((short)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "JSON '\"128\"'")))).isEqualTo((short)128);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as SMALLINT)").binding("a", "JSON '\"123456\"'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as SMALLINT)").binding("a", "JSON '\"128.9\"'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as SMALLINT)").binding("a", "JSON '\"true\"'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as SMALLINT)").binding("a", "JSON '\"false\"'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "JSON ' 128'")))).isEqualTo((short)128);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "json_extract('{\"x\":999}', '$.x')")))).isEqualTo((short)999);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as SMALLINT)").binding("a", "JSON '{ \"x\" : 123}'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testCastToTinyint() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "JSON 'null'")))).isNull((Type)TinyintType.TINYINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "JSON '12'")))).isEqualTo((byte)12);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as TINYINT)").binding("a", "JSON '1234'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "JSON '12.9'")))).isEqualTo((byte)13);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as TINYINT)").binding("a", "JSON '1234.0'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "JSON '1e-324'")))).isEqualTo((byte)0);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as TINYINT)").binding("a", "JSON '1e309'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "JSON 'true'")))).isEqualTo((byte)1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "JSON 'false'")))).isEqualTo((byte)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "JSON '\"12\"'")))).isEqualTo((byte)12);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as TINYINT)").binding("a", "JSON '\"1234\"'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as TINYINT)").binding("a", "JSON '\"12.9\"'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as TINYINT)").binding("a", "JSON '\"true\"'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as TINYINT)").binding("a", "JSON '\"false\"'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "JSON ' 12'")))).isEqualTo((byte)12);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "json_extract('{\"x\":99}', '$.x')")))).isEqualTo((byte)99);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as TINYINT)").binding("a", "JSON '{ \"x\" : 123}'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testTypeConstructor() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("JSON '123'")))).hasType((Type)JsonType.JSON).isEqualTo("123");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("JSON '[4,5,6]'")))).hasType((Type)JsonType.JSON).isEqualTo("[4,5,6]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("JSON '{ \"a\": 789 }'")))).hasType((Type)JsonType.JSON).isEqualTo("{\"a\":789}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("JSON 'null'")))).hasType((Type)JsonType.JSON).isEqualTo("null");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("JSON '[null]'")))).hasType((Type)JsonType.JSON).isEqualTo("[null]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("JSON '[13,null,42]'")))).hasType((Type)JsonType.JSON).isEqualTo("[13,null,42]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("JSON '{\"x\": null}'")))).hasType((Type)JsonType.JSON).isEqualTo("{\"x\":null}");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("JSON '{}{'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("JSON '{} \"a\"'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("JSON '{}{abc'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("JSON '{}abc'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("JSON ''")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
    }

    @Test
    public void testCastFromIntegrals() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "cast(null as integer)")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "cast(null as bigint)")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "cast(null as smallint)")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "cast(null as tinyint)")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "128")))).hasType((Type)JsonType.JSON).isEqualTo("128");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "BIGINT '128'")))).hasType((Type)JsonType.JSON).isEqualTo("128");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "SMALLINT '128'")))).hasType((Type)JsonType.JSON).isEqualTo("128");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "TINYINT '127'")))).hasType((Type)JsonType.JSON).isEqualTo("127");
    }

    @Test
    public void testCastToDouble() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "JSON 'null'")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "JSON '128'")))).isEqualTo(128.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "JSON '12345678901234567890'")))).isEqualTo(1.2345678901234567E19);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "JSON '128.9'")))).isEqualTo(128.9);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "JSON '1e-324'")))).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "JSON '1e309'")))).isEqualTo(Double.POSITIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "JSON '-1e309'")))).isEqualTo(Double.NEGATIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "JSON 'true'")))).isEqualTo(1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "JSON 'false'")))).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "JSON '\"128\"'")))).isEqualTo(128.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "JSON '\"12345678901234567890\"'")))).isEqualTo(1.2345678901234567E19);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "JSON '\"128.9\"'")))).isEqualTo(128.9);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "JSON '\"NaN\"'")))).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "JSON '\"Infinity\"'")))).isEqualTo(Double.POSITIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "JSON '\"-Infinity\"'")))).isEqualTo(Double.NEGATIVE_INFINITY);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DOUBLE)").binding("a", "JSON '\"true\"'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "JSON ' 128.9'")))).isEqualTo(128.9);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "json_extract('{\"x\":1.23}', '$.x')")))).isEqualTo(1.23);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DOUBLE)").binding("a", "JSON '{ \"x\" : 123}'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testCastFromDouble() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "cast(null as double)")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "3.14E0")))).hasType((Type)JsonType.JSON).isEqualTo("3.14");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "nan()")))).hasType((Type)JsonType.JSON).isEqualTo("\"NaN\"");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "infinity()")))).hasType((Type)JsonType.JSON).isEqualTo("\"Infinity\"");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "-infinity()")))).hasType((Type)JsonType.JSON).isEqualTo("\"-Infinity\"");
    }

    @Test
    public void testCastFromReal() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "cast(null as REAL)")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "REAL '3.14'")))).hasType((Type)JsonType.JSON).isEqualTo("3.14");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "cast(nan() as REAL)")))).hasType((Type)JsonType.JSON).isEqualTo("\"NaN\"");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "cast(infinity() as REAL)")))).hasType((Type)JsonType.JSON).isEqualTo("\"Infinity\"");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "cast(-infinity() as REAL)")))).hasType((Type)JsonType.JSON).isEqualTo("\"-Infinity\"");
    }

    @Test
    public void testCastToReal() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "JSON 'null'")))).isNull((Type)RealType.REAL);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "JSON '-128'")))).isEqualTo(Float.valueOf(-128.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "JSON '128'")))).isEqualTo(Float.valueOf(128.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "JSON '12345678901234567890'")))).isEqualTo(Float.valueOf(1.2345679E19f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "JSON '128.9'")))).isEqualTo(Float.valueOf(128.9f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "JSON '1e-46'")))).isEqualTo(Float.valueOf(0.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "JSON '1e39'")))).isEqualTo(Float.valueOf(Float.POSITIVE_INFINITY));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "JSON '-1e39'")))).isEqualTo(Float.valueOf(Float.NEGATIVE_INFINITY));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "JSON 'true'")))).isEqualTo(Float.valueOf(1.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "JSON 'false'")))).isEqualTo(Float.valueOf(0.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "JSON '\"128\"'")))).isEqualTo(Float.valueOf(128.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "JSON '\"12345678901234567890\"'")))).isEqualTo(Float.valueOf(1.2345679E19f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "JSON '\"128.9\"'")))).isEqualTo(Float.valueOf(128.9f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "JSON '\"NaN\"'")))).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "JSON '\"Infinity\"'")))).isEqualTo(Float.valueOf(Float.POSITIVE_INFINITY));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "JSON '\"-Infinity\"'")))).isEqualTo(Float.valueOf(Float.NEGATIVE_INFINITY));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as REAL)").binding("a", "JSON '\"true\"'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "JSON ' 128.9'")))).isEqualTo(Float.valueOf(128.9f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "json_extract('{\"x\":1.23}', '$.x')")))).isEqualTo(Float.valueOf(1.23f));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as REAL)").binding("a", "JSON '{ \"x\" : 123}'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testCastToDecimal() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(10,3))").binding("a", "JSON 'null'")))).isNull((Type)DecimalType.createDecimalType((int)10, (int)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(10,3))").binding("a", "JSON '128'")))).hasType((Type)DecimalType.createDecimalType((int)10, (int)3)).isEqualTo(SqlDecimal.decimal((String)"128.000", (DecimalType)DecimalType.createDecimalType((int)10, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(38,8))").binding("a", "cast(DECIMAL '123456789012345678901234567890.12345678' as JSON)")))).hasType((Type)DecimalType.createDecimalType((int)38, (int)8)).isEqualTo(SqlDecimal.decimal((String)"123456789012345678901234567890.12345678", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(10,5))").binding("a", "JSON '123.456'")))).hasType((Type)DecimalType.createDecimalType((int)10, (int)5)).isEqualTo(SqlDecimal.decimal((String)"123.45600", (DecimalType)DecimalType.createDecimalType((int)10, (int)5)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(10,5))").binding("a", "JSON 'true'")))).hasType((Type)DecimalType.createDecimalType((int)10, (int)5)).isEqualTo(SqlDecimal.decimal((String)"1.00000", (DecimalType)DecimalType.createDecimalType((int)10, (int)5)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(10,5))").binding("a", "JSON 'false'")))).hasType((Type)DecimalType.createDecimalType((int)10, (int)5)).isEqualTo(SqlDecimal.decimal((String)"0.00000", (DecimalType)DecimalType.createDecimalType((int)10, (int)5)));
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(10,3))").binding("a", "JSON '1234567890123456'").evaluate()).hasMessage("Cannot cast input json to DECIMAL(10,3)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(10,3))").binding("a", "JSON '{ \"x\" : 123}'").evaluate()).hasMessage("Cannot cast '{\"x\":123}' to DECIMAL(10,3)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(10,3))").binding("a", "JSON '\"abc\"'").evaluate()).hasMessage("Cannot cast '\"abc\"' to DECIMAL(10,3)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testCastFromDecimal() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "cast(null as decimal(5,2))")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "DECIMAL '3.14'")))).hasType((Type)JsonType.JSON).isEqualTo("3.14");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "DECIMAL '12345678901234567890.123456789012345678'")))).hasType((Type)JsonType.JSON).isEqualTo("12345678901234567890.123456789012345678");
    }

    @Test
    public void testCastToBoolean() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "JSON 'null'")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "JSON '0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "JSON '128'")))).isEqualTo(true);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as BOOLEAN)").binding("a", "JSON '12345678901234567890'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "JSON '128.9'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "JSON '1e-324'")))).isEqualTo(false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as BOOLEAN)").binding("a", "JSON '1e309'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "JSON 'true'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "JSON 'false'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "JSON '\"True\"'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "JSON '\"true\"'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "JSON '\"false\"'")))).isEqualTo(false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as BOOLEAN)").binding("a", "JSON '\"128\"'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as BOOLEAN)").binding("a", "JSON '\"\"'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "JSON ' true'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "json_extract('{\"x\":true}', '$.x')")))).isEqualTo(true);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as BOOLEAN)").binding("a", "JSON '{ \"x\" : 123}'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testCastFromBoolean() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "cast(null as boolean)")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "TRUE")))).hasType((Type)JsonType.JSON).isEqualTo("true");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "FALSE")))).hasType((Type)JsonType.JSON).isEqualTo("false");
    }

    @Test
    public void testCastToVarchar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "JSON 'null'")))).isNull((Type)VarcharType.VARCHAR);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "JSON '128'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("128");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "JSON '12345678901234567890'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("12345678901234567890");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "JSON '128.9'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1.289E2");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "JSON '1e-324'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0E0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "JSON '1e309'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("Infinity");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "JSON '-1e309'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("-Infinity");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "JSON 'true'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("true");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "JSON 'false'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("false");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "JSON '\"test\"'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("test");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "JSON '\"null\"'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("null");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "JSON '\"\"'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "JSON ' \"test\"'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("test");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "json_extract('{\"x\":\"y\"}', '$.x')")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("y");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as VARCHAR)").binding("a", "JSON '{ \"x\" : 123}'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testEquals() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "JSON '{\"a\": \"1.1\", \"b\": \"2.3\", \"c\": {\"d\": \"314E-2\" }}'", "JSON '{\"a\": \"1.1\", \"b\": \"2.3\", \"c\": {\"d\": \"314E-2\" }}'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "JSON '[1,2,3]'", "JSON '[1,2,3]'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "JSON '{\"a\":1, \"b\":2}'", "JSON '{\"b\":2, \"a\":1}'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "JSON '{\"a\":1, \"b\":2}'", "CAST(MAP(ARRAY['b','a'], ARRAY[2,1]) AS JSON)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "JSON 'null'", "JSON 'null'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "JSON 'true'", "JSON 'true'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "JSON '{\"x\":\"y\"}'", "JSON '{\"x\":\"y\"}'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "JSON '[1,2,3]'", "JSON '[2,3,1]'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "JSON '{\"p_1\": 1, \"p_2\":\"v_2\", \"p_3\":null, \"p_4\":true, \"p_5\": {\"p_1\":1}}'", "JSON '{\"p_2\":\"v_2\", \"p_4\":true, \"p_1\": 1, \"p_3\":null, \"p_5\": {\"p_1\":1}}'")))).isEqualTo(true);
    }

    @Test
    public void testNotEquals() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "JSON '{\"a\": 1, \"b\": 2, \"c\": {\"d\": 3 }}'").binding("b", "JSON '{\"a\": 1, \"b\": 2, \"c\": {\"d\": 4 }}'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "JSON '[1,2,3]'").binding("b", "JSON '[1,2,3]'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "JSON '{\"a\":1, \"b\":2}'").binding("b", "JSON '{\"b\":2, \"a\":1}'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "JSON 'null'").binding("b", "JSON 'null'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "JSON 'true'").binding("b", "JSON 'true'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "JSON '{\"x\":\"y\"}'").binding("b", "JSON '{\"x\":\"y\"}'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "JSON '[1,2,3]'").binding("b", "JSON '[2,3,1]'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "JSON '{\"p_1\": 1, \"p_2\":\"v_2\", \"p_3\":null, \"p_4\":true, \"p_5\": {\"p_1\":1}}'").binding("b", "JSON '{\"p_2\":\"v_2\", \"p_4\":true, \"p_1\": 1, \"p_3\":null, \"p_5\": {\"p_1\":1}}'")))).isEqualTo(false);
    }

    @Test
    public void testIsDistinctFrom() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS DISTINCT FROM b").binding("a", "JSON 'null'").binding("b", "JSON 'null'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS DISTINCT FROM b").binding("a", "JSON '{ \"a\": 1 , \"b\": 2 , \"c\": { \"d\": 3 }}'").binding("b", "JSON '{ \"a\": 1 , \"b\": 2 , \"c\" : { \"d\" : 4 }}'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS DISTINCT FROM b").binding("a", "JSON '{ \"a\": 1 , \"b\": 2 , \"c\": { \"d\": 3 }}'").binding("b", "JSON '{ \"b\": 2 , \"a\": 1 , \"c\": { \"d\": 3 }}'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS DISTINCT FROM b").binding("a", "JSON '{ \"a\": 1 , \"b\": 2 , \"c\": { \"d\": 3 }}'").binding("b", "JSON 'null'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS DISTINCT FROM b").binding("a", "JSON 'null'").binding("b", "JSON '{ \"a\": 1 , \"b\": 2 , \"c\" : { \"d\" : 4 }}'")))).isEqualTo(true);
    }

    @Test
    public void testCastFromVarchar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "cast(null as varchar)")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "'abc'")))).hasType((Type)JsonType.JSON).isEqualTo("\"abc\"");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "'\"a\":2'")))).hasType((Type)JsonType.JSON).isEqualTo("\"\\\"a\\\":2\"");
    }

    @Test
    public void testCastFromTimestamp() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "cast(null as timestamp)")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "TIMESTAMP '1970-01-01 00:00:01'")))).hasType((Type)JsonType.JSON).isEqualTo(String.format("\"%s\"", DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0)));
    }

    @Test
    public void testCastWithJsonParse() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(json_parse(a) AS ARRAY(ARRAY(INTEGER)))").binding("a", "'[[1,1], [2,2]]'")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)1), (Object)ImmutableList.of((Object)2, (Object)2)));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(json_parse(a) AS ARRAY(INTEGER))").binding("a", "'[1, \"abc\"]'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT, StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("Cannot cast to array(integer). Cannot cast 'abc' to INT\n[1, \"abc\"]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(json_parse(a) AS MAP(VARCHAR,INTEGER))").binding("a", "'{\"a\"\n:1,  \"b\":\t2}'")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)2));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(json_parse(a) AS MAP(ARRAY(INTEGER),ARRAY(INTEGER)))").binding("a", "'{\"[1, 1]\":[2, 2]}'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Cannot cast json to map(array(integer), array(integer))");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(json_parse(a) AS MAP(BOOLEAN,BOOLEAN))").binding("a", "'{true: false, false: false}'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT, StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("Cannot cast to map(boolean, boolean).\n{true: false, false: false}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(json_parse(a) AS ROW(a INTEGER, b ARRAY(INTEGER)))").binding("a", "'{\"a\":1, \"b\": [2, 3]}'")))).hasType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"a", (Type)IntegerType.INTEGER), (Object)RowType.field((String)"b", (Type)new ArrayType((Type)IntegerType.INTEGER))))).isEqualTo(ImmutableList.of((Object)1, (Object)ImmutableList.of((Object)2, (Object)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(json_parse(a) AS ROW(INTEGER, ARRAY(INTEGER)))").binding("a", "'[1, [2, 3]]'")))).hasType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)new ArrayType((Type)IntegerType.INTEGER)))).isEqualTo(ImmutableList.of((Object)1, (Object)ImmutableList.of((Object)2, (Object)3)));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(json_parse(a) AS ROW(a INTEGER, b ARRAY(INTEGER)))").binding("a", "'{\"a\": 1, \"b\": {}}'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT, StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("Cannot cast to row(a integer, b array(integer)). Expected a json array, but got {\n{\"a\": 1, \"b\": {}}");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(json_parse(a) AS ROW(INTEGER, ARRAY(INTEGER)))").binding("a", "'[1, {}]'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT, StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("Cannot cast to row(integer, array(integer)). Expected a json array, but got {\n[1, {}]");
    }

    @Test
    public void testIndeterminate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "cast(null as JSON)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "JSON '128'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "JSON 'true'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "JSON 'false'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "JSON '\"test\"'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "JSON '\"null\"'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "JSON '\"\"'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "JSON 'true'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "JSON 'false'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "JSON '\"True\"'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "JSON '\"true\"'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "JSON '123.456'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "JSON 'true'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "JSON 'false'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "JSON '\"NaN\"'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "JSON '\"Infinity\"'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "JSON '\"-Infinity\"'")))).isEqualTo(false);
    }
}

