/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import io.trino.connector.system.SystemPageSourceProvider;
import io.trino.connector.system.SystemSplitManager;
import io.trino.connector.system.SystemTablesMetadata;
import io.trino.connector.system.SystemTablesProvider;
import io.trino.connector.system.SystemTransactionHandle;
import io.trino.metadata.InternalNodeManager;
import io.trino.security.AccessControl;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.transaction.InternalConnector;
import io.trino.transaction.TransactionId;
import java.util.Objects;
import java.util.function.Function;

public class SystemConnector
implements InternalConnector {
    private final ConnectorMetadata metadata;
    private final ConnectorSplitManager splitManager;
    private final ConnectorPageSourceProvider pageSourceProvider;
    private final Function<TransactionId, ConnectorTransactionHandle> transactionHandleFunction;

    public SystemConnector(InternalNodeManager nodeManager, SystemTablesProvider tables, Function<TransactionId, ConnectorTransactionHandle> transactionHandleFunction, AccessControl accessControl, String catalogName) {
        Objects.requireNonNull(nodeManager, "nodeManager is null");
        Objects.requireNonNull(tables, "tables is null");
        Objects.requireNonNull(transactionHandleFunction, "transactionHandleFunction is null");
        Objects.requireNonNull(accessControl, "accessControl is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        this.metadata = new SystemTablesMetadata(tables);
        this.splitManager = new SystemSplitManager(nodeManager, tables);
        this.pageSourceProvider = new SystemPageSourceProvider(tables, accessControl, catalogName);
        this.transactionHandleFunction = transactionHandleFunction;
    }

    @Override
    public ConnectorTransactionHandle beginTransaction(TransactionId transactionId, IsolationLevel isolationLevel, boolean readOnly) {
        return new SystemTransactionHandle(transactionId, this.transactionHandleFunction);
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }
}

