/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.slice.Slices;
import io.trino.FullConnectorSession;
import io.trino.Session;
import io.trino.connector.system.SystemColumnHandle;
import io.trino.connector.system.SystemSplit;
import io.trino.connector.system.jdbc.FilterUtil;
import io.trino.connector.system.jdbc.JdbcTable;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataListing;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.security.AccessControl;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RelationType;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class TableJdbcTable
extends JdbcTable {
    public static final SchemaTableName NAME = new SchemaTableName("jdbc", "tables");
    public static final ConnectorTableMetadata METADATA = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(NAME).column("table_cat", (Type)VarcharType.VARCHAR).column("table_schem", (Type)VarcharType.VARCHAR).column("table_name", (Type)VarcharType.VARCHAR).column("table_type", (Type)VarcharType.VARCHAR).column("remarks", (Type)VarcharType.VARCHAR).column("type_cat", (Type)VarcharType.VARCHAR).column("type_schem", (Type)VarcharType.VARCHAR).column("type_name", (Type)VarcharType.VARCHAR).column("self_referencing_col_name", (Type)VarcharType.VARCHAR).column("ref_generation", (Type)VarcharType.VARCHAR).build();
    private static final ColumnHandle CATALOG_COLUMN = new SystemColumnHandle("table_cat");
    private final Metadata metadata;
    private final AccessControl accessControl;
    private final InternalNodeManager nodeManager;

    @Inject
    public TableJdbcTable(Metadata metadata, AccessControl accessControl, InternalNodeManager nodeManager) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
    }

    public ConnectorTableMetadata getTableMetadata() {
        return METADATA;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession connectorSession, TupleDomain<Integer> constraint, Set<Integer> requiredColumns, ConnectorSplit split) {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)METADATA);
        Session session = ((FullConnectorSession)connectorSession).getSession();
        SystemSplit systemSplit = (SystemSplit)split;
        Domain schemaDomain = constraint.getDomain((Object)1, (Type)VarcharType.VARCHAR);
        Domain tableDomain = constraint.getDomain((Object)2, (Type)VarcharType.VARCHAR);
        Domain typeDomain = constraint.getDomain((Object)3, (Type)VarcharType.VARCHAR);
        if (FilterUtil.isImpossibleObjectName(schemaDomain) || FilterUtil.isImpossibleObjectName(tableDomain)) {
            return table.build().cursor();
        }
        Optional<String> schemaFilter = FilterUtil.tryGetSingleVarcharValue(schemaDomain);
        Optional<String> tableFilter = FilterUtil.tryGetSingleVarcharValue(tableDomain);
        boolean includeTables = typeDomain.includesNullableValue((Object)Slices.utf8Slice((String)"TABLE"));
        boolean includeViews = typeDomain.includesNullableValue((Object)Slices.utf8Slice((String)"VIEW"));
        if (!includeTables && !includeViews) {
            return table.build().cursor();
        }
        String catalog = systemSplit.getCatalogName().orElseThrow();
        QualifiedTablePrefix prefix = FilterUtil.tablePrefix(catalog, schemaFilter, tableFilter);
        MetadataListing.getRelationTypes(session, this.metadata, this.accessControl, prefix).forEach((name, type) -> {
            boolean isView;
            boolean bl = isView = type == RelationType.VIEW;
            if (includeTables && !isView || includeViews && isView) {
                table.addRow(TableJdbcTable.tableRow(catalog, name, isView ? "VIEW" : "TABLE"));
            }
        });
        return table.build().cursor();
    }

    public Optional<ConnectorSplitSource> splitSource(ConnectorSession connectorSession, TupleDomain<ColumnHandle> constraint) {
        Domain catalogDomain = constraint.getDomain((Object)CATALOG_COLUMN, (Type)VarcharType.VARCHAR);
        if (FilterUtil.isImpossibleObjectName(catalogDomain)) {
            return Optional.of(FixedSplitSource.emptySplitSource());
        }
        Session session = ((FullConnectorSession)connectorSession).getSession();
        HostAddress address = this.nodeManager.getCurrentNode().getHostAndPort();
        List splits = (List)MetadataListing.listCatalogNames(session, this.metadata, this.accessControl, catalogDomain).stream().map(catalog -> new SystemSplit(address, constraint, Optional.of(catalog))).collect(ImmutableList.toImmutableList());
        return Optional.of(new FixedSplitSource((Iterable)splits));
    }

    private static Object[] tableRow(String catalog, SchemaTableName name, String type) {
        return new Object[]{catalog, name.getSchemaName(), name.getTableName(), type, null, null, null, null, null, null};
    }
}

