/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryExecution;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryPreparer;
import io.trino.execution.QueryState;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.StageId;
import io.trino.execution.StateMachine;
import io.trino.execution.TaskId;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.server.BasicQueryInfo;
import io.trino.server.ResultQueryInfo;
import io.trino.server.protocol.Slug;
import io.trino.spi.QueryId;
import io.trino.sql.planner.Plan;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Statement;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.joda.time.DateTime;

public class DataDefinitionExecution<T extends Statement>
implements QueryExecution {
    private final DataDefinitionTask<T> task;
    private final T statement;
    private final Slug slug;
    private final QueryStateMachine stateMachine;
    private final List<Expression> parameters;
    private final WarningCollector warningCollector;

    private DataDefinitionExecution(DataDefinitionTask<T> task, T statement, Slug slug, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        this.task = Objects.requireNonNull(task, "task is null");
        this.statement = (Statement)Objects.requireNonNull(statement, "statement is null");
        this.slug = Objects.requireNonNull(slug, "slug is null");
        this.stateMachine = Objects.requireNonNull(stateMachine, "stateMachine is null");
        this.parameters = parameters;
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        stateMachine.addStateChangeListener(state -> {
            if (state.isDone() && stateMachine.getFinalQueryInfo().isEmpty()) {
                stateMachine.updateQueryInfo(Optional.empty());
            }
        });
    }

    @Override
    public Slug getSlug() {
        return this.slug;
    }

    @Override
    public Session getSession() {
        return this.stateMachine.getSession();
    }

    @Override
    public DataSize getUserMemoryReservation() {
        return DataSize.ofBytes((long)0L);
    }

    @Override
    public DataSize getTotalMemoryReservation() {
        return DataSize.ofBytes((long)0L);
    }

    @Override
    public DateTime getCreateTime() {
        return this.stateMachine.getCreateTime();
    }

    @Override
    public Optional<DateTime> getExecutionStartTime() {
        return this.stateMachine.getExecutionStartTime();
    }

    @Override
    public DateTime getLastHeartbeat() {
        return this.stateMachine.getLastHeartbeat();
    }

    @Override
    public Optional<DateTime> getEndTime() {
        return this.stateMachine.getEndTime();
    }

    @Override
    public Duration getTotalCpuTime() {
        return new Duration(0.0, TimeUnit.NANOSECONDS);
    }

    @Override
    public BasicQueryInfo getBasicQueryInfo() {
        return this.stateMachine.getFinalQueryInfo().map(BasicQueryInfo::new).orElseGet(() -> this.stateMachine.getBasicQueryInfo(Optional.empty()));
    }

    @Override
    public void start() {
        try {
            if (!this.stateMachine.transitionToRunning()) {
                return;
            }
            ListenableFuture<Void> future = this.task.execute(this.statement, this.stateMachine, this.parameters, this.warningCollector);
            Futures.addCallback(future, (FutureCallback)new FutureCallback<Void>(){

                public void onSuccess(@Nullable Void result) {
                    DataDefinitionExecution.this.stateMachine.transitionToFinishing();
                }

                public void onFailure(Throwable throwable) {
                    DataDefinitionExecution.this.fail(throwable);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
        catch (Throwable e) {
            this.fail(e);
            Throwables.throwIfInstanceOf((Throwable)e, Error.class);
        }
    }

    @Override
    public void setOutputInfoListener(Consumer<QueryExecution.QueryOutputInfo> listener) {
    }

    @Override
    public void outputTaskFailed(TaskId taskId, Throwable failure) {
    }

    @Override
    public void resultsConsumed() {
        this.stateMachine.resultsConsumed();
    }

    @Override
    public ListenableFuture<QueryState> getStateChange(QueryState currentState) {
        return this.stateMachine.getStateChange(currentState);
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.stateMachine.addStateChangeListener(stateChangeListener);
    }

    @Override
    public void addFinalQueryInfoListener(StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        this.stateMachine.addQueryInfoStateChangeListener(stateChangeListener);
    }

    @Override
    public void fail(Throwable cause) {
        this.stateMachine.transitionToFailed(cause);
    }

    @Override
    public boolean isDone() {
        return this.getState().isDone();
    }

    @Override
    public void cancelQuery() {
        this.stateMachine.transitionToCanceled();
    }

    @Override
    public void cancelStage(StageId stageId) {
    }

    @Override
    public void failTask(TaskId taskId, Exception reason) {
    }

    @Override
    public void recordHeartbeat() {
        this.stateMachine.recordHeartbeat();
    }

    @Override
    public boolean shouldWaitForMinWorkers() {
        return false;
    }

    @Override
    public void pruneInfo() {
    }

    @Override
    public boolean isInfoPruned() {
        return false;
    }

    @Override
    public QueryId getQueryId() {
        return this.stateMachine.getQueryId();
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.stateMachine.getFinalQueryInfo().orElseGet(() -> this.stateMachine.updateQueryInfo(Optional.empty()));
    }

    @Override
    public ResultQueryInfo getResultQueryInfo() {
        return this.stateMachine.getFinalQueryInfo().map(ResultQueryInfo::new).orElseGet(() -> this.stateMachine.updateResultQueryInfo(Optional.empty(), Optional::empty));
    }

    @Override
    public Optional<Plan> getQueryPlan() {
        return Optional.empty();
    }

    @Override
    public QueryState getState() {
        return this.stateMachine.getQueryState();
    }

    @Override
    public Optional<Duration> getPlanningTime() {
        return this.stateMachine.getPlanningTime();
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    public static class DataDefinitionExecutionFactory
    implements QueryExecution.QueryExecutionFactory<DataDefinitionExecution<?>> {
        private final Map<Class<? extends Statement>, DataDefinitionTask<?>> tasks;

        @Inject
        public DataDefinitionExecutionFactory(Map<Class<? extends Statement>, DataDefinitionTask<?>> tasks) {
            this.tasks = Objects.requireNonNull(tasks, "tasks is null");
        }

        @Override
        public DataDefinitionExecution<?> createQueryExecution(QueryPreparer.PreparedQuery preparedQuery, QueryStateMachine stateMachine, Slug slug, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
            return this.createDataDefinitionExecution(preparedQuery.getStatement(), preparedQuery.getParameters(), stateMachine, slug, warningCollector);
        }

        private <T extends Statement> DataDefinitionExecution<T> createDataDefinitionExecution(T statement, List<Expression> parameters, QueryStateMachine stateMachine, Slug slug, WarningCollector warningCollector) {
            DataDefinitionTask<?> task = this.tasks.get(statement.getClass());
            Preconditions.checkArgument((task != null ? 1 : 0) != 0, (String)"no task for statement: %s", (Object)statement.getClass().getSimpleName());
            stateMachine.setUpdateType(task.getName());
            return new DataDefinitionExecution(task, statement, slug, stateMachine, parameters, warningCollector);
        }
    }
}

