/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;

@ThreadSafe
public class FutureStateChange<T> {
    @GuardedBy(value="listeners")
    private final Set<FutureRef<T>> listeners = new HashSet<FutureRef<T>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<T> createNewListener() {
        SettableFuture listener = SettableFuture.create();
        Set<FutureRef<T>> set = this.listeners;
        synchronized (set) {
            this.listeners.add(new FutureRef(listener));
        }
        listener.addListener(() -> {
            if (listener.isCancelled()) {
                Set<FutureRef<T>> set = this.listeners;
                synchronized (set) {
                    this.listeners.remove(new FutureRef(listener));
                }
            }
        }, MoreExecutors.directExecutor());
        return listener;
    }

    public void complete(T newState) {
        this.fireStateChange(newState, MoreExecutors.directExecutor());
    }

    public void complete(T newState, Executor executor) {
        this.fireStateChange(newState, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChange(T newState, Executor executor) {
        List futures;
        Objects.requireNonNull(executor, "executor is null");
        Set<FutureRef<T>> set = this.listeners;
        synchronized (set) {
            futures = (List)ImmutableList.copyOf(this.listeners).stream().map(FutureRef::future).collect(ImmutableList.toImmutableList());
            this.listeners.clear();
        }
        for (SettableFuture future : futures) {
            executor.execute(() -> future.set(newState));
        }
    }

    private record FutureRef<V>(SettableFuture<V> future) {
        private FutureRef(SettableFuture<V> future) {
            this.future = Objects.requireNonNull(future, "future is null");
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FutureRef futureRef = (FutureRef)o;
            return this.future == futureRef.future;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.future);
        }
    }
}

