/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.execution.buffer.PageSerializer;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;

public final class PageSplitterUtil {
    private static final int PAGE_SPLIT_THRESHOLD_IN_BYTES = 0x200000;

    private PageSplitterUtil() {
    }

    public static List<Slice> splitAndSerializePage(Page page, PageSerializer serializer) {
        List<Page> inputPages = PageSplitterUtil.splitPage(page, 0x200000L);
        ImmutableList.Builder serializedPages = ImmutableList.builderWithExpectedSize((int)inputPages.size());
        for (Page inputPage : inputPages) {
            serializedPages.add((Object)serializer.serialize(inputPage));
        }
        return serializedPages.build();
    }

    public static List<Page> splitPage(Page page, long maxPageSizeInBytes) {
        return PageSplitterUtil.splitPage(page, maxPageSizeInBytes, Long.MAX_VALUE);
    }

    private static List<Page> splitPage(Page page, long maxPageSizeInBytes, long previousPageSize) {
        Preconditions.checkArgument((page.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"page is empty");
        Preconditions.checkArgument((maxPageSizeInBytes > 0L ? 1 : 0) != 0, (Object)"maxPageSizeInBytes must be > 0");
        long currentPageSize = PageSplitterUtil.getPageSizeForSplit(page);
        if (currentPageSize == previousPageSize || currentPageSize <= maxPageSizeInBytes || page.getPositionCount() == 1) {
            return ImmutableList.of((Object)page);
        }
        ImmutableList.Builder outputPages = ImmutableList.builder();
        int positionCount = page.getPositionCount();
        int half = positionCount / 2;
        Page leftHalf = page.getRegion(0, half);
        outputPages.addAll(PageSplitterUtil.splitPage(leftHalf, maxPageSizeInBytes, currentPageSize));
        Page rightHalf = page.getRegion(half, positionCount - half);
        outputPages.addAll(PageSplitterUtil.splitPage(rightHalf, maxPageSizeInBytes, currentPageSize));
        return outputPages.build();
    }

    private static long getPageSizeForSplit(Page page) {
        long size = 0L;
        block4: for (int channel = 0; channel < page.getChannelCount(); ++channel) {
            Block block = page.getBlock(channel);
            Objects.requireNonNull(block);
            int n = 0;
            block5: while (true) {
                Block block2;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RunLengthEncodedBlock.class, DictionaryBlock.class, ValueBlock.class}, (Block)block2, n)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        RunLengthEncodedBlock rleBlock = (RunLengthEncodedBlock)block2;
                        size += rleBlock.getUnderlyingValueBlock().getSizeInBytes();
                        continue block4;
                    }
                    case 1: 
                    case 2: {
                        if (!(block2 instanceof DictionaryBlock) && !(block2 instanceof ValueBlock)) {
                            n = 3;
                            continue block5;
                        }
                        size += block.getSizeInBytes();
                        continue block4;
                    }
                }
                break;
            }
        }
        return size;
    }
}

