/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import jakarta.validation.constraints.NotNull;
import java.util.List;

public class TopologyAwareNodeSelectorConfig {
    private TopologyType type = TopologyType.FLAT;
    private List<String> locationSegmentNames = ImmutableList.of((Object)"machine");

    @NotNull
    public TopologyType getType() {
        return this.type;
    }

    @Config(value="node-scheduler.network-topology.type")
    public TopologyAwareNodeSelectorConfig setType(TopologyType type) {
        this.type = type;
        return this;
    }

    @NotNull
    public List<String> getLocationSegmentNames() {
        return this.locationSegmentNames;
    }

    @Config(value="node-scheduler.network-topology.segments")
    public TopologyAwareNodeSelectorConfig setLocationSegmentNames(List<String> locationSegmentNames) {
        this.locationSegmentNames = ImmutableList.copyOf(locationSegmentNames);
        return this;
    }

    public static enum TopologyType {
        FLAT,
        FILE,
        SUBNET;

    }
}

