/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.units.DataSize;
import io.trino.execution.HeapSizeParser;
import jakarta.validation.constraints.NotNull;

@DefunctConfig(value={"deprecated.legacy-system-pool-enabled", "experimental.reserved-pool-disabled", "experimental.reserved-pool-enabled", "query.max-total-memory-per-node", "query.max-memory-per-task"})
public class NodeMemoryConfig {
    private DataSize maxQueryMemoryPerNode = HeapSizeParser.DEFAULT.parse("30%");
    private DataSize heapHeadroom = HeapSizeParser.DEFAULT.parse("30%");

    @NotNull
    public DataSize getMaxQueryMemoryPerNode() {
        return this.maxQueryMemoryPerNode;
    }

    @Config(value="query.max-memory-per-node")
    public NodeMemoryConfig setMaxQueryMemoryPerNode(String maxQueryMemoryPerNode) {
        this.maxQueryMemoryPerNode = HeapSizeParser.DEFAULT.parse(maxQueryMemoryPerNode);
        return this;
    }

    @NotNull
    public DataSize getHeapHeadroom() {
        return this.heapHeadroom;
    }

    @Config(value="memory.heap-headroom-per-node")
    @ConfigDescription(value="The amount of heap memory to set aside as headroom/buffer (e.g., for untracked allocations)")
    public NodeMemoryConfig setHeapHeadroom(String heapHeadroom) {
        this.heapHeadroom = HeapSizeParser.DEFAULT.parse(heapHeadroom);
        return this;
    }
}

