/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.annotations.VisibleForTesting;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.annotation.NotThreadSafe;
import io.trino.operator.BigintGroupByHash;
import io.trino.operator.FlatGroupByHash;
import io.trino.operator.FlatHashStrategyCompiler;
import io.trino.operator.GroupByHashMode;
import io.trino.operator.UpdateMemory;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import java.util.List;

@NotThreadSafe
public interface GroupByHash {
    public static GroupByHash createGroupByHash(Session session, List<Type> types, boolean hasPrecomputedHash, boolean spillable, int expectedSize, FlatHashStrategyCompiler hashStrategyCompiler, UpdateMemory updateMemory) {
        boolean dictionaryAggregationEnabled = SystemSessionProperties.isDictionaryAggregationEnabled(session);
        return GroupByHash.createGroupByHash(types, GroupByHash.selectGroupByHashMode(hasPrecomputedHash, spillable, types), expectedSize, dictionaryAggregationEnabled, hashStrategyCompiler, updateMemory);
    }

    public static GroupByHashMode selectGroupByHashMode(boolean hasPrecomputedHash, boolean spillable, List<Type> types) {
        if (hasPrecomputedHash) {
            return GroupByHashMode.PRECOMPUTED;
        }
        if (spillable) {
            return GroupByHashMode.CACHED;
        }
        if (types.size() >= 3) {
            return GroupByHashMode.CACHED;
        }
        int variableWidthTypes = 0;
        for (Type type : types) {
            if (type instanceof MapType || type instanceof ArrayType || type instanceof RowType) {
                return GroupByHashMode.CACHED;
            }
            if (!type.isFlatVariableWidth() || ++variableWidthTypes < 2) continue;
            return GroupByHashMode.CACHED;
        }
        return GroupByHashMode.ON_DEMAND;
    }

    public static GroupByHash createGroupByHash(List<Type> types, GroupByHashMode hashMode, int expectedSize, boolean dictionaryAggregationEnabled, FlatHashStrategyCompiler hashStrategyCompiler, UpdateMemory updateMemory) {
        if (types.size() == 1 && types.get(0).equals((Object)BigintType.BIGINT)) {
            return new BigintGroupByHash(hashMode.isHashPrecomputed(), expectedSize, updateMemory);
        }
        return new FlatGroupByHash(types, hashMode, expectedSize, dictionaryAggregationEnabled, hashStrategyCompiler, updateMemory);
    }

    public long getEstimatedSize();

    public int getGroupCount();

    public void appendValuesTo(int var1, PageBuilder var2);

    public Work<?> addPage(Page var1);

    public Work<int[]> getGroupIds(Page var1);

    public long getRawHash(int var1);

    @VisibleForTesting
    public int getCapacity();

    public GroupByHash copy();
}

