/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import io.trino.spi.Page;

public interface SpoolingController {
    default public Mode nextMode(Page page) {
        return this.nextMode(page.getPositionCount(), page.getSizeInBytes());
    }

    public Mode nextMode(int var1, long var2);

    public Mode execute(Mode var1, long var2, long var4);

    default public void finish() {
        this.execute(Mode.SPOOL, 0L, 0L);
    }

    public MetricSnapshot getMetrics(Mode var1);

    @VisibleForTesting
    default public <T extends SpoolingController> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return (T)this;
        }
        throw new IllegalArgumentException("Cannot unwrap " + String.valueOf(this) + " to class " + String.valueOf(clazz));
    }

    public static enum Mode {
        INLINE,
        BUFFER,
        SPOOL;

    }

    public static class ActionMetrics {
        private long pages;
        private long size;
        private long positions;

        public void recordPage(long positions, long size) {
            Verify.verify((positions > 0L ? 1 : 0) != 0, (String)"Expected positions to be non-negative", (Object[])new Object[0]);
            Verify.verify((size > 0L ? 1 : 0) != 0, (String)"Expected size to be non-negative", (Object[])new Object[0]);
            ++this.pages;
            this.positions += positions;
            this.size += size;
        }

        public void reset() {
            this.pages = 0L;
            this.size = 0L;
            this.positions = 0L;
        }

        public boolean isEmpty() {
            return this.pages == 0L && this.size == 0L && this.positions == 0L;
        }

        public MetricSnapshot snapshot() {
            return new MetricSnapshot(this.positions, this.size, this.pages);
        }
    }

    public record MetricSnapshot(long positions, long size, long pages) {
        public MetricSnapshot {
            Verify.verify((positions >= 0L ? 1 : 0) != 0, (String)"Positions are expected to be non-negative", (Object[])new Object[0]);
            Verify.verify((size >= 0L ? 1 : 0) != 0, (String)"Size is expected to be non-negative", (Object[])new Object[0]);
            Verify.verify((pages >= 0L ? 1 : 0) != 0, (String)"Pages are expected to be non-negative", (Object[])new Object[0]);
        }
    }
}

