/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import io.airlift.stats.TDigest;
import io.trino.operator.aggregation.state.TDigestAndPercentileArrayState;
import io.trino.operator.scalar.TDigestFunctions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DoubleType;
import io.trino.util.Failures;
import it.unimi.dsi.fastutil.Arrays;
import java.util.Iterator;
import java.util.List;

@AggregationFunction(value="approx_percentile")
public final class ApproximateDoublePercentileArrayAggregations {
    private ApproximateDoublePercentileArrayAggregations() {
    }

    @InputFunction
    public static void input(@AggregationState TDigestAndPercentileArrayState state, @SqlType(value="double") double value, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        TDigestFunctions.verifyValue(value);
        ApproximateDoublePercentileArrayAggregations.initializePercentilesArray(state, percentilesArrayBlock);
        ApproximateDoublePercentileArrayAggregations.initializeDigest(state);
        TDigest digest = state.getDigest();
        state.addMemoryUsage(-digest.estimatedInMemorySizeInBytes());
        digest.add(value);
        state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
    }

    @InputFunction
    public static void weightedInput(@AggregationState TDigestAndPercentileArrayState state, @SqlType(value="double") double value, @SqlType(value="double") double weight, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        TDigestFunctions.verifyValue(value);
        TDigestFunctions.verifyWeight(weight);
        ApproximateDoublePercentileArrayAggregations.initializePercentilesArray(state, percentilesArrayBlock);
        ApproximateDoublePercentileArrayAggregations.initializeDigest(state);
        TDigest digest = state.getDigest();
        state.addMemoryUsage(-digest.estimatedInMemorySizeInBytes());
        digest.add(value, weight);
        state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
    }

    @CombineFunction
    public static void combine(@AggregationState TDigestAndPercentileArrayState state, TDigestAndPercentileArrayState otherState) {
        TDigest otherDigest = otherState.getDigest();
        TDigest digest = state.getDigest();
        if (digest == null) {
            state.setDigest(otherDigest);
            state.addMemoryUsage(otherDigest.estimatedInMemorySizeInBytes());
        } else {
            state.addMemoryUsage(-digest.estimatedInMemorySizeInBytes());
            digest.mergeWith(otherDigest);
            state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
        }
        state.setPercentiles(otherState.getPercentiles());
    }

    @OutputFunction(value="array(double)")
    public static void output(@AggregationState TDigestAndPercentileArrayState state, BlockBuilder out) {
        TDigest digest = state.getDigest();
        List<Double> percentiles = state.getPercentiles();
        if (percentiles == null || digest == null) {
            out.appendNull();
            return;
        }
        List<Double> valuesAtPercentiles = ApproximateDoublePercentileArrayAggregations.valuesAtPercentiles(digest, percentiles);
        ((ArrayBlockBuilder)out).buildEntry(elementBuilder -> {
            Iterator i$ = valuesAtPercentiles.iterator();
            while (i$.hasNext()) {
                double value = (Double)i$.next();
                DoubleType.DOUBLE.writeDouble(elementBuilder, value);
            }
        });
    }

    public static List<Double> valuesAtPercentiles(TDigest digest, List<Double> percentiles) {
        int[] indexes = new int[percentiles.size()];
        double[] sortedPercentiles = new double[percentiles.size()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = i;
            sortedPercentiles[i] = percentiles.get(i);
        }
        Arrays.quickSort((int)0, (int)percentiles.size(), (a, b) -> Doubles.compare((double)sortedPercentiles[a], (double)sortedPercentiles[b]), (a, b) -> {
            double tempPercentile = sortedPercentiles[a];
            sortedPercentiles[a] = sortedPercentiles[b];
            sortedPercentiles[b] = tempPercentile;
            int tempIndex = indexes[a];
            indexes[a] = indexes[b];
            indexes[b] = tempIndex;
        });
        double[] valuesAtPercentiles = digest.valuesAt(sortedPercentiles);
        double[] result = new double[valuesAtPercentiles.length];
        for (int i = 0; i < valuesAtPercentiles.length; ++i) {
            result[indexes[i]] = valuesAtPercentiles[i];
        }
        return Doubles.asList((double[])result);
    }

    private static void initializePercentilesArray(@AggregationState TDigestAndPercentileArrayState state, Block percentilesArrayBlock) {
        if (state.getPercentiles() == null) {
            ImmutableList.Builder percentilesListBuilder = ImmutableList.builder();
            for (int i = 0; i < percentilesArrayBlock.getPositionCount(); ++i) {
                Failures.checkCondition(!percentilesArrayBlock.isNull(i), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile cannot be null", new Object[0]);
                double percentile = DoubleType.DOUBLE.getDouble(percentilesArrayBlock, i);
                Failures.checkCondition(0.0 <= percentile && percentile <= 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile must be between 0 and 1", new Object[0]);
                percentilesListBuilder.add((Object)percentile);
            }
            state.setPercentiles((List<Double>)percentilesListBuilder.build());
        }
    }

    private static void initializeDigest(@AggregationState TDigestAndPercentileArrayState state) {
        TDigest digest = state.getDigest();
        if (digest == null) {
            digest = new TDigest();
            state.setDigest(digest);
            state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
        }
    }
}

