/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.airlift.stats.TDigest;
import io.trino.operator.aggregation.ApproximateDoublePercentileArrayAggregations;
import io.trino.operator.aggregation.state.TDigestAndPercentileArrayState;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.RealType;
import java.util.Iterator;
import java.util.List;

@AggregationFunction(value="approx_percentile")
public final class ApproximateRealPercentileArrayAggregations {
    private ApproximateRealPercentileArrayAggregations() {
    }

    @InputFunction
    public static void input(@AggregationState TDigestAndPercentileArrayState state, @SqlType(value="real") long value, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        ApproximateDoublePercentileArrayAggregations.input(state, Float.intBitsToFloat((int)value), percentilesArrayBlock);
    }

    @InputFunction
    public static void weightedInput(@AggregationState TDigestAndPercentileArrayState state, @SqlType(value="real") long value, @SqlType(value="double") double weight, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        ApproximateDoublePercentileArrayAggregations.weightedInput(state, Float.intBitsToFloat((int)value), weight, percentilesArrayBlock);
    }

    @CombineFunction
    public static void combine(@AggregationState TDigestAndPercentileArrayState state, @AggregationState TDigestAndPercentileArrayState otherState) {
        ApproximateDoublePercentileArrayAggregations.combine(state, otherState);
    }

    @OutputFunction(value="array(real)")
    public static void output(@AggregationState TDigestAndPercentileArrayState state, BlockBuilder out) {
        TDigest digest = state.getDigest();
        List<Double> percentiles = state.getPercentiles();
        if (percentiles == null || digest == null) {
            out.appendNull();
            return;
        }
        List<Double> valuesAtPercentiles = ApproximateDoublePercentileArrayAggregations.valuesAtPercentiles(digest, percentiles);
        ((ArrayBlockBuilder)out).buildEntry(elementBuilder -> {
            Iterator i$ = valuesAtPercentiles.iterator();
            while (i$.hasNext()) {
                double value = (Double)i$.next();
                RealType.REAL.writeLong(elementBuilder, (long)Float.floatToRawIntBits((float)value));
            }
        });
    }
}

