/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.builder;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.trino.array.IntBigArray;
import io.trino.operator.AggregationMetrics;
import io.trino.operator.FlatHashStrategyCompiler;
import io.trino.operator.GroupByHash;
import io.trino.operator.MeasuredGroupByHashWork;
import io.trino.operator.OperatorContext;
import io.trino.operator.TransformWork;
import io.trino.operator.UpdateMemory;
import io.trino.operator.Work;
import io.trino.operator.WorkProcessor;
import io.trino.operator.aggregation.AggregatorFactory;
import io.trino.operator.aggregation.GroupedAggregator;
import io.trino.operator.aggregation.builder.HashAggregationBuilder;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.plan.AggregationNode;
import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class InMemoryHashAggregationBuilder
implements HashAggregationBuilder {
    private final int[] groupByChannels;
    private final GroupByHash groupByHash;
    private final List<Type> groupByOutputTypes;
    private final List<GroupedAggregator> groupedAggregators;
    private final boolean partial;
    private final OptionalLong maxPartialMemory;
    private final UpdateMemory updateMemory;
    private final AggregationMetrics aggregationMetrics;
    private boolean full;

    public InMemoryHashAggregationBuilder(List<AggregatorFactory> aggregatorFactories, AggregationNode.Step step, int expectedGroups, List<Type> groupByTypes, List<Integer> groupByChannels, Optional<Integer> hashChannel, boolean spillable, OperatorContext operatorContext, Optional<DataSize> maxPartialMemory, FlatHashStrategyCompiler hashStrategyCompiler, UpdateMemory updateMemory, AggregationMetrics aggregationMetrics) {
        this(aggregatorFactories, step, expectedGroups, groupByTypes, groupByChannels, hashChannel, spillable, operatorContext, maxPartialMemory, Optional.empty(), hashStrategyCompiler, updateMemory, aggregationMetrics);
    }

    public InMemoryHashAggregationBuilder(List<AggregatorFactory> aggregatorFactories, AggregationNode.Step step, int expectedGroups, List<Type> groupByTypes, List<Integer> groupByChannels, Optional<Integer> hashChannel, boolean spillable, OperatorContext operatorContext, Optional<DataSize> maxPartialMemory, Optional<Integer> unspillIntermediateChannelOffset, FlatHashStrategyCompiler hashStrategyCompiler, UpdateMemory updateMemory, AggregationMetrics aggregationMetrics) {
        if (hashChannel.isPresent()) {
            this.groupByOutputTypes = ImmutableList.builderWithExpectedSize((int)(groupByTypes.size() + 1)).addAll(groupByTypes).add((Object)BigintType.BIGINT).build();
            this.groupByChannels = new int[groupByChannels.size() + 1];
            for (int i = 0; i < groupByChannels.size(); ++i) {
                this.groupByChannels[i] = groupByChannels.get(i);
            }
            this.groupByChannels[groupByChannels.size()] = hashChannel.get();
        } else {
            this.groupByOutputTypes = ImmutableList.copyOf(groupByTypes);
            this.groupByChannels = Ints.toArray(groupByChannels);
        }
        this.groupByHash = GroupByHash.createGroupByHash(operatorContext.getSession(), groupByTypes, hashChannel.isPresent(), spillable, expectedGroups, hashStrategyCompiler, updateMemory);
        this.partial = step.isOutputPartial();
        this.maxPartialMemory = maxPartialMemory.map(dataSize -> OptionalLong.of(dataSize.toBytes())).orElseGet(OptionalLong::empty);
        this.updateMemory = Objects.requireNonNull(updateMemory, "updateMemory is null");
        Objects.requireNonNull(aggregatorFactories, "aggregatorFactories is null");
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)aggregatorFactories.size());
        for (int i = 0; i < aggregatorFactories.size(); ++i) {
            AggregatorFactory accumulatorFactory = aggregatorFactories.get(i);
            if (unspillIntermediateChannelOffset.isPresent()) {
                builder.add((Object)accumulatorFactory.createUnspillGroupedAggregator(step, unspillIntermediateChannelOffset.get() + i, aggregationMetrics));
                continue;
            }
            builder.add((Object)accumulatorFactory.createGroupedAggregator(aggregationMetrics));
        }
        this.groupedAggregators = builder.build();
        this.aggregationMetrics = Objects.requireNonNull(aggregationMetrics, "aggregationMetrics is null");
    }

    @Override
    public void close() {
    }

    @Override
    public Work<?> processPage(Page page) {
        if (this.groupedAggregators.isEmpty()) {
            return new MeasuredGroupByHashWork(this.groupByHash.addPage(page.getColumns(this.groupByChannels)), this.aggregationMetrics);
        }
        return new TransformWork<int[], Object>(new MeasuredGroupByHashWork<int[]>(this.groupByHash.getGroupIds(page.getColumns(this.groupByChannels)), this.aggregationMetrics), groupByIdBlock -> {
            int groupCount = this.groupByHash.getGroupCount();
            for (GroupedAggregator groupedAggregator : this.groupedAggregators) {
                groupedAggregator.processPage(groupCount, (int[])groupByIdBlock, page);
            }
            return null;
        });
    }

    @Override
    public void updateMemory() {
        this.updateMemory.update();
    }

    @Override
    public boolean isFull() {
        return this.full;
    }

    @Override
    public ListenableFuture<Void> startMemoryRevoke() {
        throw new UnsupportedOperationException("startMemoryRevoke not supported for InMemoryHashAggregationBuilder");
    }

    @Override
    public void finishMemoryRevoke() {
        throw new UnsupportedOperationException("finishMemoryRevoke not supported for InMemoryHashAggregationBuilder");
    }

    public long getSizeInMemory() {
        long sizeInMemory = this.groupByHash.getEstimatedSize();
        for (GroupedAggregator groupedAggregator : this.groupedAggregators) {
            sizeInMemory += groupedAggregator.getEstimatedSize();
        }
        this.updateIsFull(sizeInMemory);
        return sizeInMemory;
    }

    private void updateIsFull(long sizeInMemory) {
        if (!this.partial || this.maxPartialMemory.isEmpty()) {
            return;
        }
        this.full = sizeInMemory > this.maxPartialMemory.getAsLong();
    }

    public long getGroupIdsSortingSize() {
        return this.getGroupCount() * 4L;
    }

    public void setSpillOutput() {
        for (GroupedAggregator groupedAggregator : this.groupedAggregators) {
            groupedAggregator.setSpillOutput();
        }
    }

    public int getKeyChannels() {
        return this.groupByChannels.length;
    }

    public long getGroupCount() {
        return this.groupByHash.getGroupCount();
    }

    @Override
    public WorkProcessor<Page> buildResult() {
        for (GroupedAggregator groupedAggregator : this.groupedAggregators) {
            groupedAggregator.prepareFinal();
        }
        return this.buildResult(this.consecutiveGroupIds());
    }

    public WorkProcessor<Page> buildHashSortedResult() {
        return this.buildResult(this.hashSortedGroupIds());
    }

    public List<Type> buildSpillTypes() {
        ArrayList<Type> types = new ArrayList<Type>(this.groupByOutputTypes);
        for (GroupedAggregator groupedAggregator : this.groupedAggregators) {
            types.add(groupedAggregator.getSpillType());
        }
        return types;
    }

    @VisibleForTesting
    public int getCapacity() {
        return this.groupByHash.getCapacity();
    }

    private WorkProcessor<Page> buildResult(IntIterator groupIds) {
        PageBuilder pageBuilder = new PageBuilder(this.buildTypes());
        return WorkProcessor.create(() -> {
            if (!groupIds.hasNext()) {
                return WorkProcessor.ProcessState.finished();
            }
            pageBuilder.reset();
            while (!pageBuilder.isFull() && groupIds.hasNext()) {
                int groupId = groupIds.nextInt();
                this.groupByHash.appendValuesTo(groupId, pageBuilder);
                pageBuilder.declarePosition();
                for (int i = 0; i < this.groupedAggregators.size(); ++i) {
                    GroupedAggregator groupedAggregator = this.groupedAggregators.get(i);
                    BlockBuilder output = pageBuilder.getBlockBuilder(this.groupByChannels.length + i);
                    groupedAggregator.evaluate(groupId, output);
                }
            }
            return WorkProcessor.ProcessState.ofResult(pageBuilder.build());
        });
    }

    public List<Type> buildTypes() {
        ArrayList<Type> types = new ArrayList<Type>(this.groupByOutputTypes);
        for (GroupedAggregator groupedAggregator : this.groupedAggregators) {
            types.add(groupedAggregator.getType());
        }
        return types;
    }

    private IntIterator consecutiveGroupIds() {
        return IntIterators.fromTo((int)0, (int)this.groupByHash.getGroupCount());
    }

    private IntIterator hashSortedGroupIds() {
        final IntBigArray groupIds = new IntBigArray();
        groupIds.ensureCapacity((long)this.groupByHash.getGroupCount());
        for (int i = 0; i < this.groupByHash.getGroupCount(); ++i) {
            groupIds.set((long)i, i);
        }
        groupIds.sort(0, this.groupByHash.getGroupCount(), (leftGroupId, rightGroupId) -> Long.compare(this.groupByHash.getRawHash(leftGroupId), this.groupByHash.getRawHash(rightGroupId)));
        return new AbstractIntIterator(this){
            private final int totalPositions;
            private int position;
            final /* synthetic */ InMemoryHashAggregationBuilder this$0;
            {
                this.this$0 = this$0;
                this.totalPositions = this.this$0.groupByHash.getGroupCount();
            }

            public boolean hasNext() {
                return this.position < this.totalPositions;
            }

            public int nextInt() {
                return groupIds.get((long)this.position++);
            }
        };
    }

    public static List<Type> toTypes(List<? extends Type> groupByType, List<AggregatorFactory> factories, Optional<Integer> hashChannel) {
        ImmutableList.Builder types = ImmutableList.builderWithExpectedSize((int)(groupByType.size() + (hashChannel.isPresent() ? 1 : 0) + factories.size()));
        types.addAll(groupByType);
        if (hashChannel.isPresent()) {
            types.add((Object)BigintType.BIGINT);
        }
        for (AggregatorFactory factory : factories) {
            types.add((Object)factory.createAggregator(new AggregationMetrics()).getType());
        }
        return types.build();
    }
}

